/*
 * Decompiled with CFR 0.152.
 */
package firehazurd.qcreatures.init;

import com.google.common.collect.Maps;
import firehazurd.qcreatures.QCreatures;
import firehazurd.qcreatures.entity.monster.EntityTroll;
import firehazurd.qcreatures.entity.passive.EntityAngler;
import firehazurd.qcreatures.entity.passive.EntityArmadillo;
import firehazurd.qcreatures.entity.passive.EntityBlowfish;
import firehazurd.qcreatures.entity.passive.EntityOctopus;
import firehazurd.qcreatures.entity.passive.EntityTortoise;
import firehazurd.qcreatures.entity.projectile.EntityThrowableBlock;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class ModEntities {
    public static final Map<Integer, EntityModEggInfo> entityEggs = Maps.newLinkedHashMap();
    public static final Map<Integer, String> idToModEntityName = Maps.newLinkedHashMap();

    public static void init() {
        ModEntities.registerModEntityWithEgg(EntityOctopus.class, "Octopus", 0, 80, 3, true, 8474253, 16091641);
        ModEntities.registerModEntityWithEgg(EntityTortoise.class, "Tortoise", 1, 80, 3, true, 12171309, 8281107);
        ModEntities.registerModEntityWithEgg(EntityTroll.class, "Troll", 3, 120, 3, true, 4870972, 2408212);
        ModEntities.registerModEntityWithEgg(EntityAngler.class, "Angler", 4, 80, 3, true, 7042875, 16774002);
        ModEntities.registerModEntityWithEgg(EntityArmadillo.class, "Armadillo", 5, 80, 3, true, 14334072, 11965005);
        ModEntities.registerModEntityWithEgg(EntityBlowfish.class, "Blowfish", 6, 80, 3, true, 12615716, 15191981);
        ModEntities.registerModEntity(EntityThrowableBlock.class, "ThrowableBlock", 80, 80, 10, true);
        EntityRegistry.addSpawn(EntityOctopus.class, (int)6, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        EntityRegistry.addSpawn(EntityOctopus.class, (int)6, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
        EntityRegistry.addSpawn(EntityTortoise.class, (int)8, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
        EntityRegistry.addSpawn(EntityTortoise.class, (int)8, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
        EntityRegistry.addSpawn(EntityAngler.class, (int)20, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        EntityRegistry.addSpawn(EntityTroll.class, (int)20, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
        EntityRegistry.addSpawn(EntityTroll.class, (int)20, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
        EntityRegistry.addSpawn(EntityArmadillo.class, (int)8, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
        EntityRegistry.addSpawn(EntityArmadillo.class, (int)8, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
        EntityRegistry.addSpawn(EntityBlowfish.class, (int)20, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        EntityRegistry.addSpawn(EntityBlowfish.class, (int)20, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
        EntitySpawnPlacementRegistry.setPlacementType(EntityOctopus.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntityTortoise.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityTroll.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityAngler.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        EntitySpawnPlacementRegistry.setPlacementType(EntityArmadillo.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntitySpawnPlacementRegistry.setPlacementType(EntityBlowfish.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
    }

    public static void registerModEntity(Class<? extends Entity> entityClass, String entityName, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)id, (Object)QCreatures.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        idToModEntityName.put(id, entityName);
    }

    public static void registerModEntityWithEgg(Class<? extends Entity> entityClass, String entityName, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        ModEntities.registerModEntity(entityClass, entityName, id, trackingRange, updateFrequency, sendsVelocityUpdates);
        entityEggs.put(id, new EntityModEggInfo(id, eggPrimary, eggSecondary));
    }

    public static Entity createEntityByID(int modEntityId, World worldIn) {
        Entity entity = null;
        ModContainer modcontainer = FMLCommonHandler.instance().findContainerFor((Object)QCreatures.instance);
        EntityRegistry.EntityRegistration entityregistration = EntityRegistry.instance().lookupModSpawn(modcontainer, modEntityId);
        if (entityregistration != null) {
            Class oclass = entityregistration.getEntityClass();
            try {
                if (oclass != null) {
                    entity = (Entity)oclass.getConstructor(World.class).newInstance(worldIn);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (entity == null) {
            QCreatures.logger.warn("Skipping Quintessential Creatures Entity with id " + modEntityId);
        }
        return entity;
    }

    public static class EntityModEggInfo {
        public final int spawnedID;
        public final int primaryColor;
        public final int secondaryColor;

        public EntityModEggInfo(int id, int primary, int secondary) {
            this.spawnedID = id;
            this.primaryColor = primary;
            this.secondaryColor = secondary;
        }
    }
}

