/*
 * Decompiled with CFR 0.152.
 */
package com.kulttuuri.quickhotbar.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketChangeCurrentRow
implements IMessage {
    public boolean directionUp = false;
    public boolean changeRow = true;

    public PacketChangeCurrentRow() {
    }

    public PacketChangeCurrentRow(boolean directionUp, boolean changeRow) {
        this.directionUp = directionUp;
        this.changeRow = changeRow;
    }

    public void fromBytes(ByteBuf buf) {
        this.directionUp = buf.getBoolean(0);
        this.changeRow = buf.getBoolean(1);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.directionUp);
        buf.writeBoolean(this.changeRow);
    }

    public static class PacketChangeCurrentRowHandler
    implements IMessageHandler<PacketChangeCurrentRow, IMessage> {
        private static final int ITEMS_IN_ROW = 9;

        private ItemStack[] getItemsInRow(int row, InventoryPlayer inventory) throws Exception {
            ItemStack[] items = new ItemStack[9];
            for (int i = 0; i < 9; ++i) {
                int stack = i + row * 9;
                items[i] = inventory.func_70301_a(i + row * 9);
            }
            return items;
        }

        private void setItemsForRow(int row, ItemStack[] items, InventoryPlayer inventory) throws Exception {
            for (int i = 0; i < 9; ++i) {
                inventory.func_70299_a(i + row * 9, items[i]);
            }
        }

        private void setItemForRowSlot(int row, int slot, ItemStack item, InventoryPlayer inventory) throws Exception {
            inventory.func_70299_a(row * 9 + slot, item);
        }

        public IMessage onMessage(PacketChangeCurrentRow message, MessageContext ctx) {
            Side cfr_ignored_0 = ctx.side;
            if (ctx.side == Side.SERVER) {
                try {
                    InventoryPlayer playerInventory = ctx.getServerHandler().field_147369_b.field_71071_by;
                    int currentItem = ctx.getServerHandler().field_147369_b.field_71071_by.field_70461_c;
                    ItemStack[][] items = new ItemStack[4][9];
                    items[1] = this.getItemsInRow(1, playerInventory);
                    items[2] = this.getItemsInRow(2, playerInventory);
                    items[3] = this.getItemsInRow(3, playerInventory);
                    items[0] = this.getItemsInRow(0, playerInventory);
                    if (message.directionUp) {
                        if (message.changeRow) {
                            this.setItemsForRow(1, items[2], playerInventory);
                            this.setItemsForRow(2, items[3], playerInventory);
                            this.setItemsForRow(3, items[0], playerInventory);
                            this.setItemsForRow(0, items[1], playerInventory);
                        } else {
                            this.setItemForRowSlot(1, currentItem, items[2][currentItem], playerInventory);
                            this.setItemForRowSlot(2, currentItem, items[3][currentItem], playerInventory);
                            this.setItemForRowSlot(3, currentItem, items[0][currentItem], playerInventory);
                            this.setItemForRowSlot(0, currentItem, items[1][currentItem], playerInventory);
                        }
                    } else if (message.changeRow) {
                        this.setItemsForRow(1, items[0], playerInventory);
                        this.setItemsForRow(2, items[1], playerInventory);
                        this.setItemsForRow(3, items[2], playerInventory);
                        this.setItemsForRow(0, items[3], playerInventory);
                    } else {
                        this.setItemForRowSlot(1, currentItem, items[0][currentItem], playerInventory);
                        this.setItemForRowSlot(2, currentItem, items[1][currentItem], playerInventory);
                        this.setItemForRowSlot(3, currentItem, items[2][currentItem], playerInventory);
                        this.setItemForRowSlot(0, currentItem, items[3][currentItem], playerInventory);
                    }
                    playerInventory.field_70459_e = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

