/*
 * Decompiled with CFR 0.152.
 */
package com.kulttuuri.quickhotbar.settings;

import com.kulttuuri.quickhotbar.settings.SettingsGlobal;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.lwjgl.input.Keyboard;

public class SettingsClient
extends SettingsGlobal {
    public int SCROLLING_KEY = 29;
    public int SCROLLING_KEY_SWITCH_MODE = 46;
    public int KEY_OPEN_MOD_SETTINGS_MENU = 50;
    public boolean REVERSE_MOUSEWHEEL_SCROLLING = false;
    public boolean IMMEDIATELY_SHOW_POPUP_MENU = false;
    public boolean ALLOW_MODE_SWITCHING = true;
    public boolean CURRENT_SWITCH_MODE_ROW = true;
    public boolean ALLOW_SCROLLING_WITH_KEYBOARD = true;
    public int SCROLLING_KEY_UP = 200;
    public int SCROLLING_KEY_DOWN = 208;
    public boolean ANNOUNCE_MOD_LOADED = true;
    public boolean ENABLE_SETTING_MENU = true;
    public boolean ENABLE_NUMBER_SCROLLING = true;
    public static boolean handleInventorySwitchInServer = false;
    private static boolean SETTINGS_LOADED = false;
    private Configuration config;
    private Property announceModLoaded;
    private Property enableSettingMenu;
    private Property keyBindingsScroll;
    private Property keyBindingSwitchMode;
    private Property keyBindingOpenSettingsMenu;
    private Property allowModeSwitching;
    private Property modeSwitchingIsDefaultMode;
    private Property reverseMouseWheelScrolling;
    private Property immediately_show_popup_menu;
    private Property allowKeyboardScroll;
    private Property scrollKeyUp;
    private Property scrollKeyDown;
    private Property enableNumberScrolling;

    @Override
    public void loadSettingsFromFile(File configurationFile) {
        if (SETTINGS_LOADED) {
            return;
        }
        SETTINGS_LOADED = true;
        this.config = new Configuration(configurationFile);
        this.config.load();
        this.announceModLoaded = this.config.get("general", "announce_mod_loaded", true);
        this.enableSettingMenu = this.config.get("general", "enable_settings_menu_gui", true);
        this.keyBindingsScroll = this.config.get("keybindings", "scrolling_key", "KEY_LCONTROL");
        this.keyBindingSwitchMode = this.config.get("keybindings", "switch_scrolling_mode_key", "KEY_C");
        this.keyBindingOpenSettingsMenu = this.config.get("keybindings", "open_settings_menu_key", "KEY_M");
        this.allowModeSwitching = this.config.get("general", "allow_mode_switching", true);
        this.modeSwitchingIsDefaultMode = this.config.get("general", "mode_switching_default_mode", true);
        this.reverseMouseWheelScrolling = this.config.get("general", "reverse_mousewheel_scrolling", false);
        this.immediately_show_popup_menu = this.config.get("general", "immediately_show_popup_menu", false);
        this.allowKeyboardScroll = this.config.get("general", "allow_scrolling_with_keyboard_keys", true);
        this.scrollKeyUp = this.config.get("keybindings", "keyboard_scroll_key_up", "KEY_UP");
        this.scrollKeyDown = this.config.get("keybindings", "keyboard_scroll_key_down", "KEY_DOWN");
        this.enableNumberScrolling = this.config.get("general", "allow_number_scrolling", true);
        this.ANNOUNCE_MOD_LOADED = this.announceModLoaded.getBoolean(true);
        this.ENABLE_SETTING_MENU = this.enableSettingMenu.getBoolean(true);
        this.SCROLLING_KEY = this.loadKeybindingFromFile(this.keyBindingsScroll.getString().trim(), 29);
        this.SCROLLING_KEY_SWITCH_MODE = this.loadKeybindingFromFile(this.keyBindingSwitchMode.getString().trim(), 29);
        this.KEY_OPEN_MOD_SETTINGS_MENU = this.loadKeybindingFromFile(this.keyBindingOpenSettingsMenu.getString().trim(), 50);
        this.ALLOW_MODE_SWITCHING = this.allowModeSwitching.getBoolean(true);
        this.CURRENT_SWITCH_MODE_ROW = this.modeSwitchingIsDefaultMode.getBoolean(true);
        this.IMMEDIATELY_SHOW_POPUP_MENU = this.immediately_show_popup_menu.getBoolean(false);
        this.REVERSE_MOUSEWHEEL_SCROLLING = this.reverseMouseWheelScrolling.getBoolean(false);
        this.ALLOW_SCROLLING_WITH_KEYBOARD = this.allowKeyboardScroll.getBoolean(true);
        this.SCROLLING_KEY_UP = this.loadKeybindingFromFile(this.scrollKeyUp.getString().trim(), 200);
        this.SCROLLING_KEY_DOWN = this.loadKeybindingFromFile(this.scrollKeyDown.getString().trim(), 208);
        this.ENABLE_NUMBER_SCROLLING = this.enableNumberScrolling.getBoolean(true);
        this.announceModLoaded.comment = "When you join a game, this mod prints out that is has been loaded and it's keybindings. Set to false to disable this behavior. Default: true";
        this.enableSettingMenu.comment = "If this is true, you are able to open mod settings menu. Default: true";
        this.keyBindingsScroll.comment = "Key which you need to hold down to scroll between inventory rows. Default: KEY_LCONTROL. Should you wish to change this key, you can find all supported keys from here: http://www.lwjgl.org/javadoc/org/lwjgl/input/Keyboard.html";
        this.keyBindingSwitchMode.comment = "Key which you can use to switch between row and column switching while also holding the scrolling key. Default: KEY_C. Should you wish to change this key, you can find all supported keys from here: http://www.lwjgl.org/javadoc/org/lwjgl/input/Keyboard.html";
        this.allowModeSwitching.comment = "Should you be able to change between row and column switching modes. Default: true";
        this.keyBindingOpenSettingsMenu.comment = "Keybinding which opens the settings menu. Note that you will also need to hold down the scrolling key to open the menu, for ex. ctrl + m. Default: KEY_M";
        this.modeSwitchingIsDefaultMode.comment = "If true, by default you will browse between rows. If false by default you will browse through columns. Default: true";
        this.immediately_show_popup_menu.comment = "If this is true, popup menu will be shown immediately instead of waiting till user scrolls. Default: false";
        this.reverseMouseWheelScrolling.comment = "If this is true, mousewheel scrolling will be reversed. Default: false";
        this.allowKeyboardScroll.comment = "If this is true, user can scroll inventory rows with bind keyboard keys. Default: true";
        this.scrollKeyUp.comment = "Keyboard key which can be used to scroll inventory rows up. Default: KEY_UP. Should you wish to change this key, you can find all supported keys from here: http://www.lwjgl.org/javadoc/org/lwjgl/input/Keyboard.html";
        this.scrollKeyDown.comment = "Keyboard key which can be used to scroll inventory rows down. Default: KEY_DOWN. Should you wish to change this key, you can find all supported keys from here: http://www.lwjgl.org/javadoc/org/lwjgl/input/Keyboard.html";
        this.enableNumberScrolling.comment = "Should you be able to hold down inventory number slot and scroll that column. Default: true";
        this.config.save();
    }

    public void saveSettings() {
        this.announceModLoaded.set(this.ANNOUNCE_MOD_LOADED);
        this.keyBindingsScroll.set(Keyboard.getKeyName((int)this.SCROLLING_KEY));
        this.keyBindingSwitchMode.set(Keyboard.getKeyName((int)this.SCROLLING_KEY_SWITCH_MODE));
        this.keyBindingOpenSettingsMenu.set(Keyboard.getKeyName((int)this.KEY_OPEN_MOD_SETTINGS_MENU));
        this.allowModeSwitching.set(this.ALLOW_MODE_SWITCHING);
        this.modeSwitchingIsDefaultMode.set(this.CURRENT_SWITCH_MODE_ROW);
        this.reverseMouseWheelScrolling.set(this.REVERSE_MOUSEWHEEL_SCROLLING);
        this.immediately_show_popup_menu.set(this.IMMEDIATELY_SHOW_POPUP_MENU);
        this.allowKeyboardScroll.set(this.ALLOW_SCROLLING_WITH_KEYBOARD);
        this.scrollKeyUp.set(Keyboard.getKeyName((int)this.SCROLLING_KEY_UP));
        this.scrollKeyDown.set(Keyboard.getKeyName((int)this.SCROLLING_KEY_DOWN));
        this.enableNumberScrolling.set(this.ENABLE_NUMBER_SCROLLING);
        this.config.save();
    }

    private int loadKeybindingFromFile(String keyBindingKey, int defaultKey) {
        if (keyBindingKey == null || keyBindingKey.equals("")) {
            return defaultKey;
        }
        if (keyBindingKey.startsWith("KEY_")) {
            keyBindingKey = keyBindingKey.substring(4, keyBindingKey.length());
        }
        if (Keyboard.getKeyIndex((String)keyBindingKey) == 0) {
            return defaultKey;
        }
        return Keyboard.getKeyIndex((String)keyBindingKey);
    }

    public void setCurrentSwitchMode(boolean rowSwitchMode) {
        this.modeSwitchingIsDefaultMode.set(rowSwitchMode);
        this.CURRENT_SWITCH_MODE_ROW = rowSwitchMode;
        this.config.save();
    }
}

