/*
 * Decompiled with CFR 0.152.
 */
package com.kulttuuri.quickhotbar;

import com.kulttuuri.quickhotbar.QuickHotbarMod;
import com.kulttuuri.quickhotbar.gui.GuiSettingsBase;
import com.kulttuuri.quickhotbar.packets.PacketChangeCurrentRow;
import com.kulttuuri.quickhotbar.proxy.IProxy;
import com.kulttuuri.quickhotbar.settings.SettingsClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class QuickHotbarEventHandler {
    private static final ResourceLocation WIDGETS = new ResourceLocation("textures/gui/widgets.png");
    private static final RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
    private static boolean announceWelcomeMessage = false;
    public static boolean renderQuickHotbarPreview = false;
    private static boolean isUpKeyDown = false;
    private static boolean isDownKeyDown = false;
    private static boolean isModeSwitchKeyDown = false;
    private static boolean isNumberKeyDown = false;
    private static final int ITEMS_IN_ROW = 9;

    private int whichNumberKeyIsDown() {
        if (!QuickHotbarMod.clientSettings.ENABLE_NUMBER_SCROLLING) {
            return 0;
        }
        if (Keyboard.isKeyDown((int)2)) {
            return 1;
        }
        if (Keyboard.isKeyDown((int)3)) {
            return 2;
        }
        if (Keyboard.isKeyDown((int)4)) {
            return 3;
        }
        if (Keyboard.isKeyDown((int)5)) {
            return 4;
        }
        if (Keyboard.isKeyDown((int)6)) {
            return 5;
        }
        if (Keyboard.isKeyDown((int)7)) {
            return 6;
        }
        if (Keyboard.isKeyDown((int)8)) {
            return 7;
        }
        if (Keyboard.isKeyDown((int)9)) {
            return 8;
        }
        if (Keyboard.isKeyDown((int)10)) {
            return 9;
        }
        return 0;
    }

    @SubscribeEvent
    public void clientJoinedEvent(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        announceWelcomeMessage = true;
    }

    @SubscribeEvent
    public void disconnectEvent(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        SettingsClient.handleInventorySwitchInServer = false;
    }

    private void announceModWelcomeMessage() {
        SettingsClient settings = QuickHotbarMod.clientSettings;
        if (settings.ANNOUNCE_MOD_LOADED) {
            String keyNameScrolling = Keyboard.getKeyName((int)settings.SCROLLING_KEY).equals("LCONTROL") ? "left ctrl" : Keyboard.getKeyName((int)settings.SCROLLING_KEY).toLowerCase();
            String keyNameUp = Keyboard.getKeyName((int)settings.SCROLLING_KEY_UP);
            String keyNameDown = Keyboard.getKeyName((int)settings.SCROLLING_KEY_DOWN);
            String keyNameOpenmenu = Keyboard.getKeyName((int)settings.KEY_OPEN_MOD_SETTINGS_MENU);
            String keyNameSwitchMode = Keyboard.getKeyName((int)settings.SCROLLING_KEY_SWITCH_MODE);
            String orText = settings.ALLOW_SCROLLING_WITH_KEYBOARD ? " (or " + keyNameUp.toLowerCase() + " & " + keyNameDown.toLowerCase() + ")" : "";
            String numberSwitchText = settings.ENABLE_NUMBER_SCROLLING ? "Number key + scroll for column scrolling. " : "";
            String openMenuText = settings.ENABLE_SETTING_MENU ? keyNameScrolling + " + " + keyNameOpenmenu + " to view mod settings." : "";
            String msg = "Quick Hotbar 1.04 loaded. ";
            msg = msg + keyNameScrolling + " + mouse wheel" + orText + " to scroll. ";
            msg = msg + numberSwitchText;
            msg = msg + openMenuText;
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentTranslation(msg, new Object[0]));
        }
    }

    @SubscribeEvent
    public void renderChatMessagesAboveInventorySlotsPreview(RenderGameOverlayEvent.Chat event) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        if ((this.whichNumberKeyIsDown() != 0 || Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY)) && renderQuickHotbarPreview) {
            event.posY -= 60;
        }
    }

    @SubscribeEvent
    public void handleKeyboardPresses(RenderGameOverlayEvent.Pre event) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        if (!Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY_SWITCH_MODE)) {
            isModeSwitchKeyDown = false;
        }
        if (!Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY_UP)) {
            isUpKeyDown = false;
        }
        if (!Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY_DOWN)) {
            isDownKeyDown = false;
        }
        if (this.whichNumberKeyIsDown() == 0) {
            isNumberKeyDown = false;
        }
        if (!isModeSwitchKeyDown && Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY_SWITCH_MODE) && Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY) && QuickHotbarMod.clientSettings.ALLOW_MODE_SWITCHING) {
            isModeSwitchKeyDown = true;
            QuickHotbarMod.clientSettings.setCurrentSwitchMode(!QuickHotbarMod.clientSettings.CURRENT_SWITCH_MODE_ROW);
            String msg = "";
            msg = QuickHotbarMod.clientSettings.CURRENT_SWITCH_MODE_ROW ? "Switched to row scrolling." : "Switched to column scrolling.";
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentTranslation(msg, new Object[0]));
        }
        if (QuickHotbarMod.clientSettings.ENABLE_SETTING_MENU && Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY) && Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.KEY_OPEN_MOD_SETTINGS_MENU)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiSettingsBase.currentGuiScreen);
        }
        if (QuickHotbarMod.clientSettings.IMMEDIATELY_SHOW_POPUP_MENU && Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY)) {
            renderQuickHotbarPreview = true;
        }
        if (QuickHotbarMod.clientSettings.ALLOW_SCROLLING_WITH_KEYBOARD) {
            if (!isUpKeyDown && this.whichNumberKeyIsDown() != 0 && Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY_UP)) {
                isNumberKeyDown = true;
                isUpKeyDown = true;
                renderQuickHotbarPreview = true;
                try {
                    this.switchItemRows(true, true, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!isDownKeyDown && this.whichNumberKeyIsDown() != 0 && Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY_DOWN)) {
                isNumberKeyDown = true;
                isDownKeyDown = true;
                renderQuickHotbarPreview = true;
                try {
                    this.switchItemRows(false, true, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!isUpKeyDown && Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY) && Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY_UP)) {
                isUpKeyDown = true;
                try {
                    this.switchItemRows(true, true, QuickHotbarMod.clientSettings.CURRENT_SWITCH_MODE_ROW);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (!isDownKeyDown && Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY) && Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY_DOWN)) {
                isDownKeyDown = true;
                try {
                    this.switchItemRows(false, true, QuickHotbarMod.clientSettings.CURRENT_SWITCH_MODE_ROW);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void hideInGameGuiElementsWhenPreviewIsOpen(RenderGameOverlayEvent.Pre event) {
        block2: {
            block3: {
                if (!renderQuickHotbarPreview || !Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY) && this.whichNumberKeyIsDown() == 0) break block2;
                RenderGameOverlayEvent.ElementType cfr_ignored_0 = event.type;
                if (event.type == RenderGameOverlayEvent.ElementType.FOOD) break block3;
                RenderGameOverlayEvent.ElementType cfr_ignored_1 = event.type;
                if (event.type == RenderGameOverlayEvent.ElementType.HEALTH) break block3;
                RenderGameOverlayEvent.ElementType cfr_ignored_2 = event.type;
                if (event.type == RenderGameOverlayEvent.ElementType.EXPERIENCE) break block3;
                RenderGameOverlayEvent.ElementType cfr_ignored_3 = event.type;
                if (event.type != RenderGameOverlayEvent.ElementType.ARMOR) break block2;
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleGameUpdate(TickEvent.RenderTickEvent event) {
        if (announceWelcomeMessage && Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null) {
            announceWelcomeMessage = false;
            this.announceModWelcomeMessage();
        }
        if (renderQuickHotbarPreview && (Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY) || this.whichNumberKeyIsDown() != 0)) {
            if (Minecraft.func_71410_x().field_71456_v == null || !Minecraft.func_71410_x().field_71415_G) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71474_y.field_92117_D = false;
            ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            int width = res.func_78326_a();
            int height = res.func_78328_b();
            this.renderHotbar(mc.field_71456_v, 3, 43, width, height, event.renderTickTime);
            this.renderHotbar(mc.field_71456_v, 2, 63, width, height, event.renderTickTime);
            this.renderHotbar(mc.field_71456_v, 1, 83, width, height, event.renderTickTime);
        } else if (!Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY) && !isNumberKeyDown && renderQuickHotbarPreview) {
            renderQuickHotbarPreview = false;
            Minecraft.func_71410_x().field_71474_y.field_92117_D = true;
        }
    }

    private void renderHotbar(GuiIngame gui, int itemRowNumber, int yPosFromBottom, int width, int height, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71424_I.func_76320_a("actionBar");
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        mc.field_71446_o.func_110577_a(WIDGETS);
        InventoryPlayer inv = mc.field_71439_g.field_71071_by;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)1.0f, (float)1.0f, (float)100.0f);
        gui.func_73729_b(width / 2 - 92, height - yPosFromBottom, 0, 0, 182, 22);
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        for (int i = 0; i < 9; ++i) {
            int x = width / 2 - 90 + i * 20 + 2;
            int z = height - yPosFromBottom;
            int renderSlot = itemRowNumber * 9 + i;
            this.renderInventorySlot(renderSlot, x, z + 3, partialTicks);
        }
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        mc.field_71424_I.func_76319_b();
    }

    private void renderInventorySlot(int par1, int par2, int par3, float par4) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack itemstack = mc.field_71439_g.field_71071_by.field_70462_a[par1];
        if (itemstack != null) {
            float f1 = (float)itemstack.field_77992_b - par4;
            if (f1 > 0.0f) {
                GL11.glPushMatrix();
                float f2 = 1.0f + f1 / 5.0f;
                GL11.glTranslatef((float)(par2 + 8), (float)(par3 + 12), (float)0.0f);
                GL11.glScalef((float)(1.0f / f2), (float)((f2 + 1.0f) / 2.0f), (float)1.0f);
                GL11.glTranslatef((float)(-(par2 + 8)), (float)(-(par3 + 12)), (float)0.0f);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            itemRenderer.func_180450_b(itemstack, par2, par3 + 1);
            if (f1 > 0.0f) {
                GL11.glPopMatrix();
            }
            itemRenderer.func_180453_a(mc.field_71466_p, itemstack, par2, par3 + 1, null);
        }
    }

    @SubscribeEvent
    public void handleMouseScroll(MouseEvent event) {
        int dWheel = event.dwheel;
        if (Keyboard.isKeyDown((int)QuickHotbarMod.clientSettings.SCROLLING_KEY) || this.whichNumberKeyIsDown() != 0) {
            if (dWheel < 0) {
                try {
                    Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70453_c(1);
                    this.switchItemRows(false, false, this.whichNumberKeyIsDown() != 0 ? false : QuickHotbarMod.clientSettings.CURRENT_SWITCH_MODE_ROW);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (dWheel > 0) {
                try {
                    Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70453_c(-1);
                    this.switchItemRows(true, false, this.whichNumberKeyIsDown() != 0 ? false : QuickHotbarMod.clientSettings.CURRENT_SWITCH_MODE_ROW);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void switchItemRows(boolean directionUp, boolean isScrollingWithKeyboard, boolean changeRow) throws Exception {
        boolean reverseScrolling = QuickHotbarMod.clientSettings.REVERSE_MOUSEWHEEL_SCROLLING;
        if (!isScrollingWithKeyboard) {
            directionUp = reverseScrolling ? !directionUp : directionUp;
        }
        renderQuickHotbarPreview = true;
        if (SettingsClient.handleInventorySwitchInServer) {
            this.handleRowSwitchInServer(directionUp, changeRow);
            return;
        }
        if (!directionUp) {
            if (changeRow) {
                this.switchItemRows(3, 2);
                this.switchItemRows(2, 1);
                this.switchItemRows(1, 0);
            } else {
                int currentSlot = this.getCurrentSlot(directionUp, reverseScrolling, isScrollingWithKeyboard);
                this.switchItemsInSlots(27 + currentSlot, 18 + currentSlot);
                this.switchItemsInSlots(18 + currentSlot, 9 + currentSlot);
                this.switchItemsInSlots(9 + currentSlot, 0 + currentSlot);
            }
        } else if (changeRow) {
            this.switchItemRows(0, 1);
            this.switchItemRows(1, 2);
            this.switchItemRows(2, 3);
        } else {
            int currentSlot = this.getCurrentSlot(directionUp, reverseScrolling, isScrollingWithKeyboard);
            this.switchItemsInSlots(0 + currentSlot, 9 + currentSlot);
            this.switchItemsInSlots(9 + currentSlot, 18 + currentSlot);
            this.switchItemsInSlots(18 + currentSlot, 27 + currentSlot);
        }
    }

    private int getCurrentSlot(boolean directionUp, boolean reverseScrolling, boolean isScrollingWithKeyboard) {
        if (!reverseScrolling && !directionUp || reverseScrolling && directionUp) {
            int currentSlot = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c;
            if (!isScrollingWithKeyboard) {
                ++currentSlot;
            }
            if (currentSlot >= 9) {
                currentSlot = 0;
            }
            return currentSlot;
        }
        int currentSlot = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c;
        if (!isScrollingWithKeyboard) {
            --currentSlot;
        }
        if (currentSlot < 0) {
            currentSlot = 8;
        }
        return currentSlot;
    }

    private void handleRowSwitchInServer(boolean directionUp, boolean changeRow) {
        IProxy.simpleNetworkWrapper.sendToServer((IMessage)new PacketChangeCurrentRow(directionUp, changeRow));
    }

    private void switchItemRows(int row1, int row2) {
        for (int i = 0; i < 9; ++i) {
            this.switchItemsInSlots(row1 * 9 + i, row2 * 9 + i);
        }
    }

    private void switchItemsInSlots(int slot1, int slot2) {
        int inventoryId = 0;
        int rightClick = 0;
        int holdingShift = 0;
        Minecraft.func_71410_x().field_71442_b.func_78753_a(inventoryId, slot1 += 9, rightClick, holdingShift, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        Minecraft.func_71410_x().field_71442_b.func_78753_a(inventoryId, slot2 += 9, rightClick, holdingShift, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        Minecraft.func_71410_x().field_71442_b.func_78753_a(inventoryId, slot1, rightClick, holdingShift, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }
}

