/*
 * Decompiled with CFR 0.152.
 */
package com.qkninja.clockhud.client.gui;

import com.qkninja.clockhud.reference.ConfigValues;
import com.qkninja.clockhud.reference.Textures;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class GuiClock
extends Gui {
    private Minecraft mc;
    private static final int SUN_WIDTH = 24;
    private static final int MOON_WIDTH = 16;
    private static final int ICON_HEIGHT = 25;
    private static final int BAR_LENGTH = 200;
    private static final int BAR_HEIGHT = 5;
    private static final int DOT = 5;
    private static final int DAY_TICKS = 24000;
    private static final int NIGHT_TICK = 13000;

    public GuiClock(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderExperienceBar(RenderGameOverlayEvent.Post event) {
        if (event.isCancelable() || event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE || !ConfigValues.guiActive) {
            return;
        }
        this.mc.func_110434_K().func_110577_a(Textures.Gui.HUD);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        GL11.glScalef((float)ConfigValues.scale, (float)ConfigValues.scale, (float)ConfigValues.scale);
        this.func_73729_b(ConfigValues.xCoord + 12 - 2, ConfigValues.yCoord + 12 - 2, 0, 0, 200, 5);
        if (this.isDay()) {
            this.func_73729_b(ConfigValues.xCoord + this.getScaledTime(), ConfigValues.yCoord, 0, 5, 24, 25);
        } else {
            this.func_73729_b(ConfigValues.xCoord + 4 + this.getScaledTime(), ConfigValues.yCoord, 24, 5, 16, 25);
        }
        GL11.glScalef((float)(1.0f / ConfigValues.scale), (float)(1.0f / ConfigValues.scale), (float)(1.0f / ConfigValues.scale));
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
    }

    private int getScaledTime() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        long time = world.func_72912_H().func_76073_f();
        int currentTime = (int)time % 24000;
        if (currentTime >= 0 && currentTime <= 13000) {
            return currentTime * 195 / 13000;
        }
        return (currentTime - 13000) * 195 / 11000;
    }

    private boolean isDay() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        long time = world.func_72912_H().func_76073_f();
        int currentTime = (int)time % 24000;
        return currentTime >= 0 && currentTime <= 13000;
    }
}

