/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Transformer;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import lumien.randomthings.Transformer.RTLoadingPlugin;

public class MCPNames {
    private static Map<String, String> fields;
    private static Map<String, String> methods;

    public static boolean mcp() {
        return RTLoadingPlugin.IN_MCP;
    }

    public static String field(String srgName) {
        if (MCPNames.mcp()) {
            return fields.get(srgName);
        }
        return srgName;
    }

    public static String method(String srgName) {
        if (MCPNames.mcp()) {
            return methods.get(srgName);
        }
        return srgName;
    }

    private static Map<String, String> readMappings(File file) {
        if (!file.isFile()) {
            throw new RuntimeException("Couldn't find MCP mappings.");
        }
        try {
            return (Map)Files.readLines((File)file, (Charset)Charsets.UTF_8, (LineProcessor)new MCPFileParser());
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read SRG->MCP mappings", e);
        }
    }

    static {
        if (MCPNames.mcp()) {
            String mappingDir = "./../mcp/";
            fields = MCPNames.readMappings(new File(mappingDir + "fields.csv"));
            methods = MCPNames.readMappings(new File(mappingDir + "methods.csv"));
        } else {
            methods = null;
            fields = null;
        }
    }

    private static class MCPFileParser
    implements LineProcessor<Map<String, String>> {
        private static final Splitter splitter = Splitter.on((char)',').trimResults();
        private final Map<String, String> map = Maps.newHashMap();
        private boolean foundFirst;

        private MCPFileParser() {
        }

        public boolean processLine(String line) throws IOException {
            if (!this.foundFirst) {
                this.foundFirst = true;
                return true;
            }
            Iterator splitted = splitter.split((CharSequence)line).iterator();
            try {
                String srg = (String)splitted.next();
                String mcp = (String)splitted.next();
                if (!this.map.containsKey(srg)) {
                    this.map.put(srg, mcp);
                }
            }
            catch (NoSuchElementException e) {
                throw new IOException("Invalid Mappings file!", e);
            }
            return true;
        }

        public Map<String, String> getResult() {
            return ImmutableMap.copyOf(this.map);
        }
    }
}

