/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.Extra;

import com.gemo.FalseBook.Extra.FalseBookExtraCore;
import com.gemo.utils.FlatFile;
import java.io.File;
import java.io.IOException;
import org.bukkit.Material;

public class ExtraWorldSettings {
    private FlatFile config;
    private int GlowstoneOffID = Material.SOUL_SAND.getId();
    private byte GlowstoneOffData = 0;
    private boolean PumpkinsEnabled = true;
    private boolean NetherrackEnabled = true;
    private boolean GlowstoneEnabled = true;

    public ExtraWorldSettings(String FileName, String worldName) {
        this.loadSettings(FileName, worldName);
    }

    public FlatFile getConfig() {
        return this.config;
    }

    public void setConfig(FlatFile config) {
        this.config = config;
    }

    public int getGlowstoneOffID() {
        return this.GlowstoneOffID;
    }

    public void setGlowstoneOffID(int glowstoneOffID) {
        this.GlowstoneOffID = glowstoneOffID;
    }

    public byte getGlowstoneOffData() {
        return this.GlowstoneOffData;
    }

    public void setGlowstoneOffData(byte glowstoneOffData) {
        this.GlowstoneOffData = glowstoneOffData;
    }

    public boolean isPumpkinsEnabled() {
        return this.PumpkinsEnabled;
    }

    public void setPumpkinsEnabled(boolean pumpkinsEnabled) {
        this.PumpkinsEnabled = pumpkinsEnabled;
    }

    public boolean isNetherrackEnabled() {
        return this.NetherrackEnabled;
    }

    public void setNetherrackEnabled(boolean netherrackEnabled) {
        this.NetherrackEnabled = netherrackEnabled;
    }

    public boolean isGlowstoneEnabled() {
        return this.GlowstoneEnabled;
    }

    public void setGlowstoneEnabled(boolean glowstoneEnabled) {
        this.GlowstoneEnabled = glowstoneEnabled;
    }

    public boolean saveSettings(String FileName, String worldName) {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        folder = new File("plugins/FalseBook/" + worldName);
        folder.mkdirs();
        try {
            this.config = new FlatFile("FalseBook/" + worldName + "/" + FileName, false);
            this.config.setBoolean("TogglePumpkins", this.isPumpkinsEnabled());
            this.config.setBoolean("ToggleNetherrack", this.isNetherrackEnabled());
            this.config.setBoolean("ToggleGlowstone", this.isGlowstoneEnabled());
            this.config.setInt("GlowstoneOffTypeID", this.getGlowstoneOffID());
            this.config.setInt("GlowstoneOffDataValue", (int)this.getGlowstoneOffData());
            this.config.writeFile();
            return true;
        }
        catch (IOException e) {
            FalseBookExtraCore.printInConsole("Error while saving file: plugins/FalseBook/" + worldName + "/" + FileName);
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadSettings(String FileName, String worldName) {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        folder = new File("plugins/FalseBook/" + worldName);
        folder.mkdirs();
        try {
            this.config = new FlatFile("FalseBook/" + worldName + "/" + FileName, false);
            if (this.config.readFile()) {
                this.setPumpkinsEnabled(this.config.getBoolean("TogglePumpkins", true));
                this.setNetherrackEnabled(this.config.getBoolean("ToggleNetherrack", true));
                this.setGlowstoneEnabled(this.config.getBoolean("ToggleGlowstone", true));
                this.setGlowstoneOffID(this.config.getInt("GlowstoneOffTypeID", Material.SOUL_SAND.getId()));
                this.setGlowstoneOffData((byte)this.config.getInt("GlowstoneOffDataValue", 0));
                this.saveSettings(FileName, worldName);
            } else {
                this.saveSettings(FileName, worldName);
            }
            return true;
        }
        catch (Exception e) {
            try {
                FalseBookExtraCore.printInConsole("Error while reading file: plugins/FalseBook/" + worldName + "/" + FileName);
                this.config.regenerateFile("FalseBook/" + worldName + "/" + FileName);
                this.saveSettings(FileName, worldName);
                FalseBookExtraCore.printInConsole("recreated file: plugins/FalseBook/" + worldName + "/" + FileName);
                return true;
            }
            catch (IOException e1) {
                FalseBookExtraCore.printInConsole("Error while reading file: plugins/FalseBook/" + worldName + "/" + FileName);
                return false;
            }
        }
    }
}

