/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.worldedit.BlockVector;

public class Vector {
    protected final double x;
    protected final double y;
    protected final double z;

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector(Vector pt) {
        this.x = pt.x;
        this.y = pt.y;
        this.z = pt.z;
    }

    public Vector() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public double getX() {
        return this.x;
    }

    public int getBlockX() {
        return (int)Math.round(this.x);
    }

    public Vector setX(double x) {
        return new Vector(x, this.y, this.z);
    }

    public Vector setX(int x) {
        return new Vector((double)x, this.y, this.z);
    }

    public double getY() {
        return this.y;
    }

    public int getBlockY() {
        return (int)Math.round(this.y);
    }

    public Vector setY(double y) {
        return new Vector(this.x, y, this.z);
    }

    public Vector setY(int y) {
        return new Vector(this.x, (double)y, this.z);
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockZ() {
        return (int)Math.round(this.z);
    }

    public Vector setZ(double z) {
        return new Vector(this.x, this.y, z);
    }

    public Vector setZ(int z) {
        return new Vector(this.x, this.y, (double)z);
    }

    public Vector add(Vector other) {
        return new Vector(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Vector add(double x, double y, double z) {
        return new Vector(this.x + x, this.y + y, this.z + z);
    }

    public Vector add(int x, int y, int z) {
        return new Vector(this.x + (double)x, this.y + (double)y, this.z + (double)z);
    }

    public Vector add(Vector ... others) {
        double newX = this.x;
        double newY = this.y;
        double newZ = this.z;
        for (int i = 0; i < others.length; ++i) {
            newX += others[i].x;
            newY += others[i].y;
            newZ += others[i].z;
        }
        return new Vector(newX, newY, newZ);
    }

    public Vector subtract(Vector other) {
        return new Vector(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public Vector subtract(double x, double y, double z) {
        return new Vector(this.x - x, this.y - y, this.z - z);
    }

    public Vector subtract(int x, int y, int z) {
        return new Vector(this.x - (double)x, this.y - (double)y, this.z - (double)z);
    }

    public Vector subtract(Vector ... others) {
        double newX = this.x;
        double newY = this.y;
        double newZ = this.z;
        for (int i = 0; i < others.length; ++i) {
            newX -= others[i].x;
            newY -= others[i].y;
            newZ -= others[i].z;
        }
        return new Vector(newX, newY, newZ);
    }

    public Vector multiply(Vector other) {
        return new Vector(this.x * other.x, this.y * other.y, this.z * other.z);
    }

    public Vector multiply(double x, double y, double z) {
        return new Vector(this.x * x, this.y * y, this.z * z);
    }

    public Vector multiply(int x, int y, int z) {
        return new Vector(this.x * (double)x, this.y * (double)y, this.z * (double)z);
    }

    public Vector multiply(Vector ... others) {
        double newX = this.x;
        double newY = this.y;
        double newZ = this.z;
        for (int i = 0; i < others.length; ++i) {
            newX *= others[i].x;
            newY *= others[i].y;
            newZ *= others[i].z;
        }
        return new Vector(newX, newY, newZ);
    }

    public Vector multiply(double n) {
        return new Vector(this.x * n, this.y * n, this.z * n);
    }

    public Vector multiply(float n) {
        return new Vector(this.x * (double)n, this.y * (double)n, this.z * (double)n);
    }

    public Vector multiply(int n) {
        return new Vector(this.x * (double)n, this.y * (double)n, this.z * (double)n);
    }

    public Vector divide(Vector other) {
        return new Vector(this.x / other.x, this.y / other.y, this.z / other.z);
    }

    public Vector divide(double x, double y, double z) {
        return new Vector(this.x / x, this.y / y, this.z / z);
    }

    public Vector divide(int x, int y, int z) {
        return new Vector(this.x / (double)x, this.y / (double)y, this.z / (double)z);
    }

    public Vector divide(int n) {
        return new Vector(this.x / (double)n, this.y / (double)n, this.z / (double)n);
    }

    public Vector divide(double n) {
        return new Vector(this.x / n, this.y / n, this.z / n);
    }

    public Vector divide(float n) {
        return new Vector(this.x / (double)n, this.y / (double)n, this.z / (double)n);
    }

    public double length() {
        return Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0) + Math.pow(this.z, 2.0));
    }

    public double distance(Vector pt) {
        return Math.sqrt(Math.pow(pt.x - this.x, 2.0) + Math.pow(pt.y - this.y, 2.0) + Math.pow(pt.z - this.z, 2.0));
    }

    public double distanceSq(Vector pt) {
        return Math.pow(pt.x - this.x, 2.0) + Math.pow(pt.y - this.y, 2.0) + Math.pow(pt.z - this.z, 2.0);
    }

    public Vector normalize() {
        return this.divide(this.length());
    }

    public boolean containedWithin(Vector min, Vector max) {
        return this.x >= min.getX() && this.x <= max.getX() && this.y >= min.getY() && this.y <= max.getY() && this.z >= min.getZ() && this.z <= max.getZ();
    }

    public boolean containedWithinBlock(Vector min, Vector max) {
        return this.getBlockX() >= min.getBlockX() && this.getBlockX() <= max.getBlockX() && this.getBlockY() >= min.getBlockY() && this.getBlockY() <= max.getBlockY() && this.getBlockZ() >= min.getBlockZ() && this.getBlockZ() <= max.getBlockY();
    }

    public Vector clampY(int min, int max) {
        return new Vector(this.x, Math.max((double)min, Math.min((double)max, this.y)), this.z);
    }

    public Vector transform2D(double angle, double aboutX, double aboutZ, double translateX, double translateZ) {
        angle = Math.toRadians(angle);
        double x = this.x;
        double z = this.z;
        double x2 = x * Math.cos(angle) - z * Math.sin(angle);
        double z2 = x * Math.sin(angle) + z * Math.cos(angle);
        return new Vector(x2 + aboutX + translateX, this.y, z2 + aboutZ + translateZ);
    }

    public static Vector toBlockPoint(double x, double y, double z) {
        return new Vector((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
    }

    public BlockVector toBlockPoint() {
        return new BlockVector((int)Math.floor(this.x), (int)Math.floor(this.y), (int)Math.floor(this.z));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vector)) {
            return false;
        }
        Vector other = (Vector)obj;
        return other.getX() == this.x && other.getY() == this.y && other.getZ() == this.z;
    }

    public int hashCode() {
        return new Double(this.x).hashCode() >> 13 ^ new Double(this.y).hashCode() >> 7 ^ new Double(this.z).hashCode();
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public BlockVector toBlockVector() {
        return new BlockVector(this);
    }

    public static Vector getMinimum(Vector v1, Vector v2) {
        return new Vector(Math.min(v1.getX(), v2.getX()), Math.min(v1.getY(), v2.getY()), Math.min(v1.getZ(), v2.getZ()));
    }

    public static Vector getMaximum(Vector v1, Vector v2) {
        return new Vector(Math.max(v1.getX(), v2.getX()), Math.max(v1.getY(), v2.getY()), Math.max(v1.getZ(), v2.getZ()));
    }
}

