/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.Vector;

public class Vector2D {
    protected final double x;
    protected final double z;

    public Vector2D(double x, double z) {
        this.x = x;
        this.z = z;
    }

    public Vector2D(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public Vector2D(float x, float z) {
        this.x = x;
        this.z = z;
    }

    public Vector2D(Vector2D pt) {
        this.x = pt.x;
        this.z = pt.z;
    }

    public Vector2D() {
        this.x = 0.0;
        this.z = 0.0;
    }

    public double getX() {
        return this.x;
    }

    public int getBlockX() {
        return (int)Math.round(this.x);
    }

    public Vector2D setX(double x) {
        return new Vector2D(x, this.z);
    }

    public Vector2D setX(int x) {
        return new Vector2D((double)x, this.z);
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockZ() {
        return (int)Math.round(this.z);
    }

    public Vector2D setZ(double z) {
        return new Vector2D(this.x, z);
    }

    public Vector2D setZ(int z) {
        return new Vector2D(this.x, (double)z);
    }

    public BlockVector2D toBlockVector2D() {
        return new BlockVector2D(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vector2D)) {
            return false;
        }
        Vector other = (Vector)obj;
        return other.x == this.x && other.z == this.z;
    }

    public int hashCode() {
        return new Double(this.x).hashCode() >> 13 ^ new Double(this.z).hashCode();
    }

    public String toString() {
        return "(" + this.x + ", " + this.z + ")";
    }
}

