/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class BukkitUtil {
    private static final Map<World, LocalWorld> wlw = new HashMap<World, LocalWorld>();

    private BukkitUtil() {
    }

    public static LocalWorld getLocalWorld(World w) {
        LocalWorld lw = wlw.get(w);
        if (lw == null) {
            lw = new BukkitWorld(w);
            wlw.put(w, lw);
        }
        return lw;
    }

    public static BlockVector toVector(Block block) {
        return new BlockVector(block.getX(), block.getY(), block.getZ());
    }

    public static BlockVector toVector(BlockFace face) {
        return new BlockVector(face.getModX(), face.getModY(), face.getModZ());
    }

    public static BlockWorldVector toWorldVector(Block block) {
        return new BlockWorldVector(BukkitUtil.getLocalWorld(block.getWorld()), block.getX(), block.getY(), block.getZ());
    }

    public static Vector toVector(Location loc) {
        return new Vector(loc.getX(), loc.getY(), loc.getZ());
    }

    public static Vector toVector(org.bukkit.util.Vector vector) {
        return new Vector(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Location toLocation(WorldVector pt) {
        return new Location(BukkitUtil.toWorld(pt), pt.getX(), pt.getY(), pt.getZ());
    }

    public static Location toLocation(World world, Vector pt) {
        return new Location(world, pt.getX(), pt.getY(), pt.getZ());
    }

    public static Player matchSinglePlayer(Server server, String name) {
        List players = server.matchPlayer(name);
        if (players.size() == 0) {
            return null;
        }
        return (Player)players.get(0);
    }

    public static Block toBlock(BlockWorldVector pt) {
        return BukkitUtil.toWorld(pt).getBlockAt(BukkitUtil.toLocation(pt));
    }

    public static World toWorld(WorldVector pt) {
        return ((BukkitWorld)pt.getWorld()).getWorld();
    }
}

