/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.selections;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.bukkit.selections.RegionSelection;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.CuboidRegionSelector;
import com.sk89q.worldedit.regions.RegionSelector;
import org.bukkit.Location;
import org.bukkit.World;

public class CuboidSelection
extends RegionSelection {
    protected CuboidRegion cuboid;

    public CuboidSelection(World world, Location pt1, Location pt2) {
        this(world, BukkitUtil.toVector(pt1), BukkitUtil.toVector(pt2));
    }

    public CuboidSelection(World world, Vector pt1, Vector pt2) {
        super(world);
        if (pt1 == null) {
            throw new IllegalArgumentException("Null point 1 not permitted");
        }
        if (pt2 == null) {
            throw new IllegalArgumentException("Null point 2 not permitted");
        }
        CuboidRegionSelector sel = new CuboidRegionSelector();
        sel.selectPrimary(pt1);
        sel.selectSecondary(pt2);
        try {
            this.cuboid = sel.getRegion();
        }
        catch (IncompleteRegionException e) {
            throw new RuntimeException("IncompleteRegionException unexpectedly thrown");
        }
        this.setRegionSelector(sel);
        this.setRegion(this.cuboid);
    }

    public CuboidSelection(World world, RegionSelector sel, CuboidRegion region) {
        super(world, sel, region);
        this.cuboid = region;
    }
}

