/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.data;

import com.sk89q.worldedit.data.DataException;
import com.sk89q.worldedit.data.McRegionChunkStore;
import com.sk89q.worldedit.data.MissingChunkException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZippedMcRegionChunkStore
extends McRegionChunkStore {
    protected File zipFile;
    protected ZipFile zip;
    protected String folder;

    public ZippedMcRegionChunkStore(File zipFile, String folder) throws IOException, ZipException {
        this.zipFile = zipFile;
        this.folder = folder;
        this.zip = new ZipFile(zipFile);
    }

    public ZippedMcRegionChunkStore(File zipFile) throws IOException, ZipException {
        this.zipFile = zipFile;
        this.zip = new ZipFile(zipFile);
    }

    protected InputStream getInputStream(String name) throws IOException, DataException {
        ZipEntry entry;
        String file = "region/" + name;
        if (this.folder != null) {
            if (!this.folder.equals("")) {
                file = this.folder + "/" + file;
            }
        } else {
            ZipEntry testEntry = this.zip.getEntry("level.dat");
            if (testEntry == null) {
                testEntry = this.getEntry("world/level.dat");
                Pattern pattern = Pattern.compile(".*[\\\\/]level\\.dat$");
                if (testEntry == null) {
                    Enumeration<? extends ZipEntry> e = this.zip.entries();
                    while (e.hasMoreElements()) {
                        testEntry = e.nextElement();
                        if (!pattern.matcher(testEntry.getName()).matches()) continue;
                        this.folder = testEntry.getName().replaceAll("level\\.dat$", "");
                        this.folder = this.folder.substring(0, this.folder.length() - 1);
                        file = this.folder + file;
                        break;
                    }
                } else {
                    file = "world/" + file;
                }
            }
        }
        if ((entry = this.getEntry(file)) == null) {
            throw new MissingChunkException();
        }
        try {
            return this.zip.getInputStream(entry);
        }
        catch (ZipException e) {
            throw new IOException("Failed to read " + file + " in ZIP");
        }
    }

    private ZipEntry getEntry(String file) {
        ZipEntry entry = this.zip.getEntry(file);
        if (entry != null) {
            return entry;
        }
        return this.zip.getEntry(file.replace("/", "\\"));
    }

    public void close() throws IOException {
        this.zip.close();
    }

    public boolean isValid() {
        Enumeration<? extends ZipEntry> e = this.zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry testEntry = e.nextElement();
            if (!testEntry.getName().matches(".*\\.mcr$")) continue;
            return true;
        }
        return false;
    }
}

