/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.tools;

import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.tools.DoubleActionBlockTool;

public class BlockDataCyler
implements DoubleActionBlockTool {
    public boolean canUse(LocalPlayer player) {
        return player.hasPermission("worldedit.tool.data-cycler");
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleCycle(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session, WorldVector clicked, boolean forward) {
        int data;
        LocalWorld world;
        block31: {
            int increment;
            world = clicked.getWorld();
            int type = world.getBlockType(clicked);
            data = world.getBlockData(clicked);
            if (config.allowedDataCycleBlocks.size() > 0 && !player.hasPermission("worldedit.override.data-cycler") && !config.allowedDataCycleBlocks.contains(type)) {
                player.printError("You are not permitted to cycle the data value of that block.");
                return true;
            }
            int n = increment = forward ? 1 : -1;
            if (type == 17) {
                data = (data + increment) % 3;
            } else if (type == 18) {
                data = (data + increment) % 3;
            } else if (type == 6) {
                int saplingType = data & 3;
                int age = data & 0xC;
                data = (saplingType + increment) % 4 | age;
            } else if (type == 81) {
                data = (data + increment) % 16;
            } else if (type == 60) {
                data = (data + increment) % 9;
            } else if (type == 59) {
                data = (data + increment) % 6;
            } else {
                if (type == 66) {
                    if (data >= 6 && data <= 9) {
                        data = (data + increment) % 4 + 6;
                        break block31;
                    } else {
                        player.printError("This minecart track orientation is not supported.");
                        return true;
                    }
                }
                if (type == 53 || type == 67) {
                    data = (data + increment) % 4;
                } else if (type == 63) {
                    data = (data + increment) % 16;
                } else if (type == 68) {
                    data = (data + increment - 2) % 4 + 2;
                } else if (type == 44) {
                    data = (data + increment) % 3;
                } else if (type == 43) {
                    data = (data + increment) % 3;
                } else if (type == 61 || type == 62 || type == 23) {
                    data = (data + increment) % 4 + 2;
                } else if (type == 86 || type == 91) {
                    data = (data + increment) % 4;
                } else {
                    if (type != 35) {
                        player.printError("That block's data cannot be cycled.");
                        return true;
                    }
                    data = forward ? BlockDataCyler.nextClothColor(data) : BlockDataCyler.prevClothColor(data);
                }
            }
        }
        world.setBlockData(clicked, data);
        return true;
    }

    public boolean actPrimary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session, WorldVector clicked) {
        return this.handleCycle(server, config, player, session, clicked, true);
    }

    public boolean actSecondary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session, WorldVector clicked) {
        return this.handleCycle(server, config, player, session, clicked, false);
    }

    private static int nextClothColor(int data) {
        switch (data) {
            case 0: {
                return 8;
            }
            case 8: {
                return 7;
            }
            case 7: {
                return 15;
            }
            case 15: {
                return 12;
            }
            case 12: {
                return 14;
            }
            case 14: {
                return 1;
            }
            case 1: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 13;
            }
            case 13: {
                return 9;
            }
            case 9: {
                return 3;
            }
            case 3: {
                return 11;
            }
            case 11: {
                return 10;
            }
            case 10: {
                return 2;
            }
            case 2: {
                return 6;
            }
            case 6: {
                return 0;
            }
        }
        return 0;
    }

    private static int prevClothColor(int data) {
        switch (data) {
            case 8: {
                return 0;
            }
            case 7: {
                return 8;
            }
            case 15: {
                return 7;
            }
            case 12: {
                return 15;
            }
            case 14: {
                return 12;
            }
            case 1: {
                return 14;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 4;
            }
            case 13: {
                return 5;
            }
            case 9: {
                return 13;
            }
            case 3: {
                return 9;
            }
            case 11: {
                return 3;
            }
            case 10: {
                return 11;
            }
            case 2: {
                return 10;
            }
            case 6: {
                return 2;
            }
            case 0: {
                return 6;
            }
        }
        return 0;
    }
}

