/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC;

import com.alta189.sqlLibrary.SQLite.sqlCore;
import com.gemo.FalseBook.Core.FalseBookCore;
import com.gemo.FalseBook.IC.DataLoader;
import com.gemo.FalseBook.IC.FalseBookICBlockListener;
import com.gemo.FalseBook.IC.FalseBookICPlayerListener;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import com.gemo.FalseBook.IC.ICs.NotLoadedIC;
import com.gemo.FalseBook.IC.ICs.SelftriggeredBaseIC;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0020;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0111;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0230;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0232;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0260;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0261;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0262;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0263;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0270;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0271;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0272;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0280;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0281;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0282;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0285;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0420;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC1110;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC9999;
import com.gemo.FalseBook.IC.WikiPage;
import com.gemo.utils.FlatFile;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class FalseBookICCore
extends JavaPlugin
implements Runnable {
    private FalseBookCore core;
    private FlatFile config;
    private static String pluginName;
    private static int ticks;
    public static boolean loadUnloadedChunks;
    public static int maxReplaceBlocks;
    public static Server server;
    public int mainTaskID = -1;
    private FalseBookICBlockListener blockListener;
    private FalseBookICPlayerListener playerListener;
    private static boolean enableSTICs;
    private sqlCore SQLite;

    static {
        ticks = 10;
        loadUnloadedChunks = true;
        maxReplaceBlocks = 2500;
        enableSTICs = true;
    }

    public static void printInConsole(String str) {
        System.out.println("[FalseBook IC] " + str);
    }

    @Override
    public void run() {
        SelftriggeredBaseIC IC2;
        for (SelftriggeredBaseIC IC2 : FalseBookICBlockListener.getSensorList().values()) {
            IC2.Execute();
        }
        IC2 = null;
    }

    public void onDisable() {
        if (this.searchCore()) {
            if (this.SQLite.checkConnection().booleanValue()) {
                this.SQLite.close();
            }
            System.out.println(String.valueOf(pluginName) + " disabled");
        }
    }

    public void onEnable() {
        if (!this.searchCore()) {
            FalseBookICCore.printInConsole(">>>>> FalseBookCore.jar not found! FalseBookIC.jar is being disabled!");
            return;
        }
        server = this.getServer();
        this.blockListener = new FalseBookICBlockListener(this);
        this.playerListener = new FalseBookICPlayerListener(this);
        this.loadVersion();
        this.loadSettings("FalseBook/FalseBookIC.properties");
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvent(Event.Type.BLOCK_PLACE, (Listener)this.blockListener, Event.Priority.Highest, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_BREAK, (Listener)this.blockListener, Event.Priority.Highest, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_PISTON_EXTEND, (Listener)this.blockListener, Event.Priority.Highest, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_PISTON_RETRACT, (Listener)this.blockListener, Event.Priority.Highest, (Plugin)this);
        pm.registerEvent(Event.Type.REDSTONE_CHANGE, (Listener)this.blockListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.SIGN_CHANGE, (Listener)this.blockListener, Event.Priority.Highest, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_INTERACT, (Listener)this.playerListener, Event.Priority.Highest, (Plugin)this);
        System.out.println(String.valueOf(pluginName) + " enabled");
        this.SQLite = new sqlCore(Logger.getLogger("Minecraft"), pluginName, "SelftriggeredICs", "plugins/FalseBook");
        this.SQLite.initialize();
        if (!this.SQLite.checkTable("SensorICs").booleanValue()) {
            FalseBookICCore.printInConsole("Creating table SensorICs");
            String query = "CREATE TABLE SensorICs (Id INT AUTO_INCREMENT PRIMARY_KEY, SensorId INT, WorldName VARCHAR(255), SignX INT, SignY INT, SignZ INT);";
            this.SQLite.createTable(query);
        }
        if (enableSTICs) {
            this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, (Runnable)new DataLoader(this), 60L);
            this.mainTaskID = this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)this, 1L, (long)ticks);
        }
    }

    public void loadSensors() {
        String query = "Select * FROM SensorICs;";
        ResultSet result = null;
        result = this.SQLite.sqlQuery(query);
        int loadedICs = 0;
        try {
            while (result != null && result.next()) {
                int ID = result.getInt("Id");
                String WorldName = result.getString("WorldName");
                int x = result.getInt("SignX");
                int y = result.getInt("SignY");
                int z = result.getInt("SignZ");
                Location loc = new Location(server.getWorld(WorldName), (double)x, (double)y, (double)z, 0.0f, 0.0f);
                if (loc.getWorld() == null) continue;
                SelftriggeredBaseIC newIC = null;
                switch (result.getInt("SensorId")) {
                    case 0: {
                        newIC = new MC0020(this, loc);
                        break;
                    }
                    case 1: {
                        newIC = new MC9999(this, loc);
                        break;
                    }
                    case 2: {
                        newIC = new MC1110(this, loc);
                        break;
                    }
                    case 3: {
                        newIC = new MC0111(this, loc);
                        break;
                    }
                    case 4: {
                        newIC = new MC0420(this, loc);
                        break;
                    }
                    case 5: {
                        newIC = new MC0230(this, loc);
                        break;
                    }
                    case 6: {
                        newIC = new MC0232(this, loc);
                        break;
                    }
                    case 7: {
                        newIC = new MC0260(this, loc);
                        break;
                    }
                    case 8: {
                        newIC = new MC0261(this, loc);
                        break;
                    }
                    case 9: {
                        newIC = new MC0262(this, loc);
                        break;
                    }
                    case 10: {
                        newIC = new MC0263(this, loc);
                        break;
                    }
                    case 11: {
                        newIC = new MC0270(this, loc);
                        break;
                    }
                    case 12: {
                        newIC = new MC0271(this, loc);
                        break;
                    }
                    case 13: {
                        newIC = new MC0272(this, loc);
                        break;
                    }
                    case 14: {
                        newIC = new MC0280(this, loc);
                        break;
                    }
                    case 15: {
                        newIC = new MC0281(this, loc);
                        break;
                    }
                    case 16: {
                        newIC = new MC0282(this, loc);
                        break;
                    }
                    case 17: {
                        newIC = new MC0285(this, loc);
                        break;
                    }
                    default: {
                        newIC = null;
                    }
                }
                if (newIC == null) continue;
                if (newIC.signBlock != null) {
                    ++loadedICs;
                    FalseBookICBlockListener.getSensorList().put(loc.toString(), newIC);
                    continue;
                }
                FalseBookICBlockListener.getFailedICsList().add(new NotLoadedIC(ID, newIC.MCName, newIC.Name, loc));
            }
            FalseBookICCore.printInConsole("Loaded selftriggered ICs: " + loadedICs + " done");
            FalseBookICCore.printInConsole("Loaded selftriggered ICs: " + FalseBookICBlockListener.getFailedICsList().size() + " failed");
            if (FalseBookICBlockListener.getFailedICsList().size() > 0) {
                FalseBookICCore.printInConsole("List of failed ICs: ");
                for (NotLoadedIC thisIC : FalseBookICBlockListener.getFailedICsList()) {
                    FalseBookICCore.printInConsole("ID: " + thisIC.ID + ", " + thisIC.MCName + " @ Location - World: " + thisIC.loc.getWorld().getName() + " , X: " + thisIC.loc.getBlockX() + " , Y: " + thisIC.loc.getBlockY() + " , Z: " + thisIC.loc.getBlockZ());
                }
            }
        }
        catch (SQLException e) {
            FalseBookICCore.printInConsole("Error while loading selftriggered ICs: ");
            FalseBookICCore.printInConsole("");
            e.printStackTrace();
        }
    }

    public void addSensor(int SensorID, Location loc) {
        if (this.STICExistsInDB(loc)) {
            return;
        }
        String query = "INSERT INTO SensorICs  VALUES (" + this.getNextID() + ", " + SensorID + ", " + "'" + loc.getWorld().getName() + "', " + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ() + ");";
        this.SQLite.insertQuery(query);
    }

    public boolean STICExistsInDB(Location loc) {
        String query = "SELECT * FROM SensorICs WHERE WorldName='" + loc.getWorld().getName() + "'" + " AND SignX=" + loc.getBlockX() + " AND SignY=" + loc.getBlockY() + " AND SignZ=" + loc.getBlockZ() + " LIMIT 1;";
        ResultSet result = null;
        result = this.SQLite.sqlQuery(query);
        try {
            int count = 0;
            while (result != null && result.next()) {
                ++count;
            }
            return count > 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getNextID() {
        String query = "SELECT Id FROM SensorICs ORDER BY Id DESC LIMIT 1;";
        ResultSet result = null;
        result = this.SQLite.sqlQuery(query);
        try {
            if (result != null && result.next()) {
                return result.getInt("Id") + 1;
            }
            return 1;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 1;
        }
    }

    public void removeSensor(Location loc) {
        String query = "DELETE FROM SensorICs WHERE WorldName='" + loc.getWorld().getName() + "'" + " AND SignX=" + loc.getBlockX() + " AND SignY=" + loc.getBlockY() + " AND SignZ=" + loc.getBlockZ() + ";";
        this.SQLite.deleteQuery(query);
    }

    public void removeSensor(int SensorID) {
        String query = "DELETE FROM SensorICs WHERE Id=" + SensorID + ";";
        this.SQLite.deleteQuery(query);
    }

    public void clearAllSensors() {
        String query = "DELETE FROM SensorICs;";
        this.SQLite.deleteQuery(query);
    }

    public boolean loadSettings(String FileName) {
        try {
            this.config = new FlatFile(FileName, false);
            if (this.config.readFile()) {
                loadUnloadedChunks = this.config.getBoolean("LoadUnloadedChunks", loadUnloadedChunks);
                enableSTICs = this.config.getBoolean("SelftriggeredICs", enableSTICs);
                ticks = this.config.getInt("TicksBetween", ticks);
                maxReplaceBlocks = this.config.getInt("maxReplaceBlocks", maxReplaceBlocks);
                this.saveSettings(FileName);
            } else {
                this.saveSettings(FileName);
            }
            return true;
        }
        catch (Exception e) {
            try {
                this.config.regenerateFile(FileName);
                this.saveSettings(FileName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            FalseBookICCore.printInConsole("Error while reading file: plugins/" + FileName);
            return false;
        }
    }

    public boolean saveSettings(String FileName) {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        try {
            this.config = new FlatFile(FileName, false);
            this.config.setBoolean("SelftriggeredICs", enableSTICs);
            this.config.setInt("TicksBetween", ticks);
            this.config.setInt("maxReplaceBlocks", maxReplaceBlocks);
            this.config.setBoolean("LoadUnloadedChunks", loadUnloadedChunks);
            this.config.writeFile();
            return true;
        }
        catch (IOException e) {
            FalseBookICCore.printInConsole("Error while saving file: plugins/" + FileName);
            e.printStackTrace();
            return false;
        }
    }

    public FalseBookICBlockListener getBlockListener() {
        return this.blockListener;
    }

    public void loadVersion() {
        PluginDescriptionFile pdfFile = this.getDescription();
        pluginName = String.valueOf(pdfFile.getName()) + " v" + pdfFile.getVersion() + " by GeMo";
    }

    private boolean searchCore() {
        PluginManager pm = this.getServer().getPluginManager();
        if (pm.getPlugin("FalseBookCore") != null) {
            if (pm.getPlugin("FalseBookCore").isEnabled()) {
                this.setCore((FalseBookCore)pm.getPlugin("FalseBookCore"));
                return true;
            }
            this.setCore((FalseBookCore)pm.getPlugin("FalseBookCore"));
            return true;
        }
        return false;
    }

    public void setCore(FalseBookCore core) {
        this.core = core;
    }

    public FalseBookCore getCore() {
        return this.core;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (label.equalsIgnoreCase("fbic") && player.isOp() && args != null) {
                if (args.length == 1) {
                    if (args[0].equalsIgnoreCase("icstatus")) {
                        player.sendMessage(ChatColor.AQUA + "[FalseBook IC Status]:");
                        player.sendMessage(ChatColor.YELLOW + "Selftriggered ICs loaded: " + ChatColor.GREEN + FalseBookICBlockListener.getSensorList().values().size());
                        player.sendMessage(ChatColor.YELLOW + "Selftriggered ICs NOT loaded: " + ChatColor.RED + FalseBookICBlockListener.getFailedICsList().size());
                        if (FalseBookICBlockListener.getFailedICsList().size() > 0) {
                            player.sendMessage(ChatColor.AQUA + "List of failed ICs: ");
                            for (NotLoadedIC notLoadedIC : FalseBookICBlockListener.getFailedICsList()) {
                                player.sendMessage(ChatColor.RED + "ID: " + notLoadedIC.ID + ", " + notLoadedIC.MCName + " @ World: " + notLoadedIC.loc.getWorld().getName() + " , X: " + notLoadedIC.loc.getBlockX() + " , Y: " + notLoadedIC.loc.getBlockY() + " , Z: " + notLoadedIC.loc.getBlockZ());
                            }
                        }
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("importics")) {
                        player.sendMessage(ChatColor.YELLOW + "Importing ICs...");
                        FalseBookICBlockListener.loadWLAN();
                        player.sendMessage(ChatColor.YELLOW + "Done...!");
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("reloadsettings")) {
                        player.sendMessage(ChatColor.YELLOW + "Reloading IC-Settings...");
                        this.loadSettings("FalseBook/FalseBookIC.properties");
                        player.sendMessage(ChatColor.YELLOW + "IC-Settings reloaded successfully!");
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("ExportWiki")) {
                        player.sendMessage(ChatColor.YELLOW + "Exporting Wiki");
                        for (BaseIC baseIC : FalseBookICBlockListener.registeredTICs.values()) {
                            baseIC.ExportAsWikiHTML();
                        }
                        for (BaseIC baseIC : FalseBookICBlockListener.registeredSTICs.values()) {
                            baseIC.ExportAsWikiHTML();
                        }
                        Object var6_14 = null;
                        this.exportWikiAllICs();
                        this.exportWikiPackageICs("standard");
                        this.exportWikiPackageICs("detection");
                        this.exportWikiPackageICs("standard");
                        this.exportWikiPackageICs("selftriggered");
                        this.exportWikiPackageICs("worldedit");
                        this.exportWikiInformation();
                        player.sendMessage(ChatColor.YELLOW + "Done!");
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("loadics")) {
                        player.sendMessage(ChatColor.YELLOW + "Reloading ICs...");
                        if (this.mainTaskID != -1) {
                            this.getServer().getScheduler().cancelTask(this.mainTaskID);
                        }
                        FalseBookICBlockListener.getFailedICsList().clear();
                        FalseBookICBlockListener.setSensorList(new HashMap<String, SelftriggeredBaseIC>());
                        DataLoader dataLoader = new DataLoader(this);
                        dataLoader.run();
                        if (enableSTICs) {
                            this.mainTaskID = this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)this, 1L, (long)ticks);
                        }
                        player.sendMessage(ChatColor.YELLOW + FalseBookICBlockListener.getSensorList().values().size() + " selftriggered ICs loaded.");
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("clearics")) {
                        player.sendMessage(ChatColor.YELLOW + "Clearing ICs...");
                        if (this.mainTaskID != -1) {
                            this.getServer().getScheduler().cancelTask(this.mainTaskID);
                        }
                        FalseBookICBlockListener.setSensorList(new HashMap<String, SelftriggeredBaseIC>());
                        this.clearAllSensors();
                        player.sendMessage(ChatColor.YELLOW + "Selftriggered ICs cleared successfully!");
                        return true;
                    }
                } else if (args.length == 2) {
                    if (args[0].equalsIgnoreCase("jumpto")) {
                        try {
                            int n = Integer.valueOf(args[1]);
                            for (NotLoadedIC thisIC : FalseBookICBlockListener.getFailedICsList()) {
                                if (thisIC.ID != n) continue;
                                player.sendMessage(ChatColor.YELLOW + "Teleporting to IC with ID: " + thisIC.ID);
                                player.teleport(thisIC.loc);
                                return true;
                            }
                            player.sendMessage(ChatColor.RED + "The given ID was not found!");
                        }
                        catch (Exception exception) {
                            player.sendMessage(ChatColor.RED + "Please enter a number. (Example: /fbic jumpto 2)");
                        }
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("deleteic")) {
                        try {
                            int n = Integer.valueOf(args[1]);
                            for (NotLoadedIC thisIC : FalseBookICBlockListener.getFailedICsList()) {
                                if (thisIC.ID != n) continue;
                                player.sendMessage(ChatColor.YELLOW + "Deleting failed " + thisIC.MCName + " with ID: " + thisIC.ID);
                                this.removeSensor(thisIC.ID);
                                player.sendMessage(ChatColor.YELLOW + "Done!");
                                FalseBookICBlockListener.getFailedICsList().remove(thisIC);
                                return true;
                            }
                            player.sendMessage(ChatColor.RED + "The given ID was not found!");
                        }
                        catch (Exception exception) {
                            player.sendMessage(ChatColor.RED + "Please enter a number. (Example: /fbic deleteic 2)");
                        }
                        return true;
                    }
                } else if (args.length == 3) {
                    if (args[0].equalsIgnoreCase("set") && args[1].equalsIgnoreCase("TicksBetween")) {
                        try {
                            int n;
                            ticks = n = Integer.valueOf(args[2]).intValue();
                            this.saveSettings("FalseBook/FalseBookIC.properties");
                            player.sendMessage(ChatColor.YELLOW + "TicksBetween execution set to: " + ticks);
                            player.sendMessage(ChatColor.GRAY + "Type /reload to apply the changes.");
                        }
                        catch (Exception exception) {
                            player.sendMessage(ChatColor.RED + "Please enter a number. (Example: /fbic set TicksBetween 2)");
                        }
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("set") && args[1].equalsIgnoreCase("maxReplaceBlocks")) {
                        try {
                            int n;
                            maxReplaceBlocks = n = Integer.valueOf(args[2]).intValue();
                            this.saveSettings("FalseBook/FalseBookIC.properties");
                            player.sendMessage(ChatColor.YELLOW + "maxReplaceBlocks set to: " + maxReplaceBlocks);
                            player.sendMessage(ChatColor.GRAY + "Type /reload to apply the changes.");
                        }
                        catch (Exception exception) {
                            player.sendMessage(ChatColor.RED + "Please enter a number. (Example: /fbic set maxReplaceBlocks 2500)");
                        }
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("set") && args[1].equalsIgnoreCase("SelftriggeredICs")) {
                        try {
                            boolean bl;
                            enableSTICs = bl = Boolean.valueOf(args[2]).booleanValue();
                            this.saveSettings("FalseBook/FalseBookIC.properties");
                            player.sendMessage(ChatColor.YELLOW + "SelftriggeredICs set to: " + enableSTICs);
                            player.sendMessage(ChatColor.GRAY + "Type /reload to apply the changes.");
                        }
                        catch (Exception exception) {
                            player.sendMessage(ChatColor.RED + "Please enter a number. (Example: /fbic set enableSTICs true)");
                        }
                        return true;
                    }
                }
            }
        }
        return true;
    }

    public void exportWikiPackageICs(String packageName) {
        String folderName = "plugins/FalseBook/IC-Wiki";
        if (!new File(String.valueOf(folderName) + "/templates/template_packages.html").exists()) {
            return;
        }
        WikiPage thisPage = new WikiPage(String.valueOf(folderName) + "/templates/template_packages.html");
        String thisName = "";
        String icList = "";
        icList = String.valueOf(icList) + "<ul>";
        thisPage.replaceText("%PACKAGENAME%", String.valueOf(packageName.toUpperCase()) + " ICs");
        thisName = "";
        icList = "";
        icList = String.valueOf(icList) + "<ul>";
        TreeMap<String, BaseIC> newMapST = new TreeMap<String, BaseIC>();
        newMapST.putAll(FalseBookICBlockListener.registeredTICs);
        newMapST.putAll(FalseBookICBlockListener.registeredSTICs);
        icList = "<ul>";
        for (BaseIC IC : newMapST.values()) {
            if (!IC.getClass().getPackage().getName().contains(packageName)) continue;
            thisName = IC.MCName.substring(1, IC.MCName.length() - 1);
            icList = String.valueOf(icList) + "<li><a href=\"" + thisName + ".html\">" + thisName + "</a> - " + IC.Name + "</li>";
        }
        icList = String.valueOf(icList) + "</ul>";
        thisPage.replaceText("%ICLIST%", icList);
        File newFile = new File(String.valueOf(folderName) + "/" + packageName + "_ics.html");
        if (newFile.exists()) {
            newFile.delete();
        }
        thisPage.savePage(String.valueOf(folderName) + "/" + packageName + "_ics.html");
        thisPage = null;
        newMapST.clear();
        newMapST = null;
    }

    public void exportWikiAllICs() {
        String folderName = "plugins/FalseBook/IC-Wiki";
        if (!new File(String.valueOf(folderName) + "/templates/template_all.html").exists()) {
            return;
        }
        WikiPage thisPage = new WikiPage(String.valueOf(folderName) + "/templates/template_all.html");
        String thisName = "";
        String icList = "";
        icList = String.valueOf(icList) + "<ul>";
        TreeMap<String, BaseIC> newMap = new TreeMap<String, BaseIC>();
        newMap.putAll(FalseBookICBlockListener.registeredTICs);
        for (BaseIC IC : newMap.values()) {
            thisName = IC.MCName.substring(1, IC.MCName.length() - 1);
            icList = String.valueOf(icList) + "<li><a href=\"" + thisName + ".html\">" + thisName + "</a> - " + IC.Name + "</li>";
        }
        icList = String.valueOf(icList) + "</ul>";
        thisPage.replaceText("%TICLIST%", icList);
        newMap.clear();
        newMap = null;
        TreeMap<String, SelftriggeredBaseIC> newMapST = new TreeMap<String, SelftriggeredBaseIC>();
        newMapST.putAll(FalseBookICBlockListener.registeredSTICs);
        icList = "<ul>";
        for (BaseIC IC : newMapST.values()) {
            thisName = IC.MCName.substring(1, IC.MCName.length() - 1);
            icList = String.valueOf(icList) + "<li><a href=\"" + thisName + ".html\">" + thisName + "</a> - " + IC.Name + "</li>";
        }
        icList = String.valueOf(icList) + "</ul>";
        thisPage.replaceText("%STICLIST%", icList);
        thisPage.savePage(String.valueOf(folderName) + "/all_ics.html");
        thisPage = null;
        newMapST.clear();
        newMapST = null;
    }

    public void exportWikiInformation() {
        String folderName = "plugins/FalseBook/IC-Wiki";
        if (!new File(String.valueOf(folderName) + "/templates/template_info.html").exists()) {
            return;
        }
        PluginDescriptionFile pdfFile = this.getDescription();
        String version = pdfFile.getVersion();
        WikiPage thisPage = new WikiPage(String.valueOf(folderName) + "/templates/template_info.html");
        thisPage.replaceText("%VERSION%", version);
        thisPage.replaceText("%TICCOUNT%", "" + FalseBookICBlockListener.registeredTICs.values().size());
        thisPage.replaceText("%STICCOUNT%", "" + FalseBookICBlockListener.registeredSTICs.values().size());
        thisPage.savePage(String.valueOf(folderName) + "/information.html");
        thisPage = null;
    }
}

