/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.detection;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC1270
extends BaseIC {
    public MC1270(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "POWER SENSOR";
        this.MCName = "[MC1270]";
        this.MCGroup = "detection";
        this.chipState = new BaseChip(true, false, false, "Clock", "", "");
        this.chipState.setOutputs("Output: High if the block is powered", "", "");
        this.chipState.setLines("Y offset, with 0 being the IC block. Leave blank to default to the block below.", "");
        this.ICDescription = "The MC1270 checks for a powered block relative to the block behind the IC sign whenever the input goes from low to high. By default it checks the block directly underneath but this can be changed.<br /><br />The <a href=\"MC0270.html\">MC0270</a> is the selftriggered version.";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC1270.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC1270.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(3, "");
        if (event.getLine(2).length() < 1) {
            event.setLine(2, "-1");
        }
        String yOffset = event.getLine(2);
        try {
            if (yOffset.length() > 0) {
                Integer.parseInt(yOffset);
            }
        }
        catch (NumberFormatException e) {
            MC1270.cancelCreation(event, "The third line must be a number or be blank.");
            return;
        }
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC1270.getBlockPositions(signBlock);
        if (MC1270.isPowered(positions.get(0))) {
            int offSet = -1;
            try {
                offSet = Integer.valueOf(signBlock.getLine(2));
            }
            catch (Exception e) {
                offSet = -1;
            }
            Block block = MC1270.getICBlock(signBlock).getBlock().getRelative(0, offSet, 0);
            if (block.isBlockPowered() || block.isBlockIndirectlyPowered()) {
                MC1270.switchLever(signBlock, true);
            } else {
                MC1270.switchLever(signBlock, false);
            }
            block = null;
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

