/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.selftriggered;

import com.gemo.FalseBook.IC.FalseBookICBlockListener;
import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import com.gemo.FalseBook.IC.ICs.SelftriggeredBaseIC;
import com.gemo.FalseBook.IC.ICs.selftriggered.MC0111;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.SignChangeEvent;

public class MC1110
extends SelftriggeredBaseIC {
    String networkName = "";
    boolean oldStatus;
    boolean curStatus;

    public void initIC(FalseBookICCore plugin) {
        this.TypeID = 2;
        this.Name = "TRANSMITTER";
        this.MCName = "[MC1110]";
        this.MCGroup = "selftriggered";
        this.chipState = new BaseChip(false, false, false, "Data", "", "");
        this.chipState.setOutputs("Output = Input", "", "");
        this.chipState.setLines("networkname", "");
        this.ICDescription = "The MC1110 transmits the input value to a particular named band or network.";
    }

    public MC1110(FalseBookICCore plugin) {
        super(plugin);
        this.initIC(plugin);
    }

    public MC1110(FalseBookICCore plugin, Location loc) {
        super(plugin);
        this.initIC(plugin);
        if (!loc.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            return;
        }
        this.signBlock = (Sign)loc.getBlock().getState();
        if (!this.signBlock.getLine(1).equalsIgnoreCase(this.MCName)) {
            return;
        }
        this.oldStatus = MC1110.isActivated(this.signBlock);
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC1110.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        this.signBlock = (Sign)event.getBlock().getState();
        Player player = event.getPlayer();
        if (BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            event.setLine(0, this.Name);
            event.setLine(1, this.MCName);
            event.setLine(3, "");
            if (event.getLine(2) == null) {
                MC1110.cancelCreation(event, "Please define a Networkname!");
                return;
            }
            if (event.getLine(2).length() < 1) {
                MC1110.cancelCreation(event, "Please define a Networkname!");
                return;
            }
        } else {
            MC1110.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        this.signBlock = (Sign)event.getBlock().getState();
        this.networkName = event.getLine(2);
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute() {
        if (!super.validateIC(this.MCName, this.signBlock.getLine(1))) {
            return;
        }
        if (this.startUp) {
            this.networkName = this.signBlock.getLine(2);
            this.positions = MC1110.getBlockPositions(this.signBlock);
            this.startUp = false;
        }
    }

    public void setStatus(boolean newStatus) {
        if (!super.validateIC(this.MCName, this.signBlock.getLine(1))) {
            return;
        }
        if (newStatus != this.oldStatus) {
            SelftriggeredBaseIC IC2;
            this.oldStatus = newStatus;
            for (SelftriggeredBaseIC IC2 : FalseBookICBlockListener.getSensorList().values()) {
                if (!(IC2 instanceof MC0111) || !this.networkName.equalsIgnoreCase(((MC0111)IC2).networkName)) continue;
                ((MC0111)IC2).setStatus(newStatus);
            }
            IC2 = null;
            MC1110.switchLever(this.signBlock, newStatus);
        }
    }

    public boolean getStatus() {
        return this.oldStatus;
    }

    public String getNetworkName() {
        return this.networkName;
    }
}

