/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.standard;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC3032
extends BaseIC {
    public MC3032(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "NEG JK-FF";
        this.MCName = "[MC3032]";
        this.MCGroup = "standard";
        this.chipState = new BaseChip(true, true, true, "Clock", "K-Input", "J-Input");
        this.chipState.setOutputs("Output", "", "");
        this.ICDescription = "The MC3032 implements a JK flip flop that updates its output based on the states of inputs J and K when the clock falls.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC3032.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        if (!BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            MC3032.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        event.setLine(0, this.Name);
        event.setLine(1, this.MCName);
        event.setLine(2, "");
        event.setLine(3, "");
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC3032.getBlockPositions(signBlock);
        boolean inputC = MC3032.isPowered(positions.get(0));
        boolean inputK = MC3032.isPowered(positions.get(1));
        boolean inputJ = MC3032.isPowered(positions.get(2));
        if (!MC3032.isActivator(signBlock, positions.get(0))) {
            return;
        }
        if (!inputC) {
            if (inputJ && !inputK) {
                MC3032.switchLever(signBlock, true);
            } else if (!inputJ && inputK) {
                MC3032.switchLever(signBlock, false);
            }
            if (inputJ && inputK) {
                MC3032.switchLever(signBlock, !MC3032.isActivated(signBlock));
            }
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

