/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.standard;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;

public class MC3101
extends BaseIC {
    private HashMap<String, String> ModeList = new HashMap();
    private HashMap<String, Integer> CountList = new HashMap();
    private HashMap<String, Integer> StartCountList = new HashMap();

    public MC3101(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "COUNTER";
        this.MCName = "[MC3101]";
        this.MCGroup = "standard";
        this.chipState = new BaseChip(true, true, false, "Clock", "Reset", "");
        this.chipState.setOutputs("Output", "", "");
        this.chipState.setLines("the counter reset value", "ONCE (player resets the signal via resetinput) or INF (the IC resets itself, when reaching the counter reset value)");
        this.ICDescription = "The MC3101 implements a counter that counts down from a given input. The counter counts down each time clock input toggles from low to high, it starts from a predefined value to 0. Output is high when counter reaches 0. If in 'infinite' mode, it will automatically reset the next time clock is toggled. Otherwise, it only resets when the 'reset' input toggles from low to high.";
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
            MC3101.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
            return;
        }
        Player player = event.getPlayer();
        int val = 0;
        String mode = "";
        String locStr = event.getBlock().getLocation().toString();
        if (BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
            event.setLine(0, this.Name);
            event.setLine(1, this.MCName);
            try {
                val = Integer.valueOf(event.getLine(2));
                if (val < 0) {
                    val = -val;
                    event.setLine(2, "" + val);
                }
                if (val == 0) {
                    MC3101.cancelCreation(event, "Line 3 must be a Number > 0.");
                    return;
                }
            }
            catch (Exception e) {
                MC3101.cancelCreation(event, "Line 3 must be a Number > 0.");
                return;
            }
            if (event.getLine(3).length() > 0) {
                if (!event.getLine(3).equalsIgnoreCase("ONCE") && !event.getLine(3).equalsIgnoreCase("INF")) {
                    MC3101.cancelCreation(event, "Line 4 must be ONCE or INF. (default: INF)");
                    return;
                }
                event.setLine(3, event.getLine(3).toUpperCase());
            } else {
                event.setLine(3, "INF");
            }
        } else {
            MC3101.cancelCreation(event, "You are not allowed to build a " + this.Name + ".");
            return;
        }
        val = Integer.valueOf(event.getLine(2));
        mode = event.getLine(3);
        this.ModeList.put(locStr, mode);
        this.CountList.put(locStr, val);
        this.StartCountList.put(locStr, val);
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        ArrayList<Location> positions = MC3101.getBlockPositions(signBlock);
        String locStr = signBlock.getBlock().getLocation().toString();
        if (!(this.ModeList.containsKey(locStr) && this.CountList.containsKey(locStr) && this.StartCountList.containsKey(locStr))) {
            this.ModeList.put(locStr, signBlock.getLine(3));
            this.CountList.put(locStr, Integer.valueOf(signBlock.getLine(2)));
            this.StartCountList.put(locStr, Integer.valueOf(signBlock.getLine(2)));
        }
        if (this.ModeList.get(locStr).equalsIgnoreCase("INF")) {
            if (!MC3101.LocationEquals(event.getBlock().getLocation(), positions.get(0))) {
                return;
            }
            if (MC3101.isPowered(positions.get(0))) {
                this.CountList.put(locStr, this.CountList.get(locStr) - 1);
                if (this.CountList.get(locStr) == 0) {
                    MC3101.switchLever(signBlock, true);
                } else {
                    MC3101.switchLever(signBlock, false);
                    if (this.CountList.get(locStr) == -1) {
                        this.CountList.put(locStr, this.StartCountList.get(locStr));
                    }
                }
            }
        } else if (this.ModeList.get(locStr).equalsIgnoreCase("ONCE")) {
            if (MC3101.isPowered(positions.get(1))) {
                this.CountList.put(locStr, this.StartCountList.get(locStr));
                MC3101.switchLever(signBlock, false);
            } else if (MC3101.isPowered(positions.get(0))) {
                if (!MC3101.LocationEquals(event.getBlock().getLocation(), positions.get(0))) {
                    return;
                }
                this.CountList.put(locStr, this.CountList.get(locStr) - 1);
                if (this.CountList.get(locStr) < 1) {
                    MC3101.switchLever(signBlock, true);
                }
            }
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

