/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.IC.ICs.worldedit;

import com.gemo.FalseBook.IC.FalseBookICCore;
import com.gemo.FalseBook.IC.ICs.BaseChip;
import com.gemo.FalseBook.IC.ICs.BaseIC;
import java.awt.Point;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.util.Vector;

public class MC1210
extends BaseIC {
    public MC1210(FalseBookICCore plugin) {
        super(plugin);
        this.Name = "SET P-DOOR";
        this.MCName = "[MC1210]";
        this.MCGroup = "worldedit";
        this.chipState = new BaseChip(true, false, false, "Clock", "", "");
        this.chipState.setOutputs("Output = Input", "", "");
        this.chipState.setLines("BlockIDOn[:SubID][-BlockIDOff[:SubID]] (Examples: 'wool:15-stone' or 'grass' or 'dirt-44:2')", "xOffset,yOffset[,zOffset]:width,height (0 being the IC block). Example: -1,2,2:3,5");
    }

    @Override
    public void checkCreation(SignChangeEvent event) {
        Player player;
        block20: {
            if (!event.getBlock().getType().equals((Object)Material.WALL_SIGN)) {
                MC1210.cancelCreation(event, ChatColor.RED + "There was an internal error while creating this IC.");
                return;
            }
            player = event.getPlayer();
            if (BaseIC.hasPermission(player, this.MCName, this.MCGroup)) {
                block19: {
                    String[] itemSplit;
                    String[] items;
                    block18: {
                        event.setLine(0, this.Name);
                        event.setLine(1, this.MCName);
                        if (event.getLine(2) == null) {
                            MC1210.cancelCreation(event, "Line 2 must contain a block id/name.");
                            return;
                        }
                        items = event.getLine(2).split("-");
                        itemSplit = items[0].split(":");
                        try {
                            if (!MC1210.isValidBlock(Integer.valueOf(itemSplit[0]))) {
                                MC1210.cancelCreation(event, "Block ('" + itemSplit[0] + "') not found.");
                                return;
                            }
                        }
                        catch (Exception e) {
                            if (MC1210.isValidBlock(MC1210.getItemIDFromName(itemSplit[0]))) break block18;
                            MC1210.cancelCreation(event, "Block ('" + itemSplit[0] + "') not found.");
                            return;
                        }
                    }
                    if (items.length > 1) {
                        itemSplit = items[1].split(":");
                        try {
                            if (!MC1210.isValidBlock(Integer.valueOf(itemSplit[0]))) {
                                MC1210.cancelCreation(event, "Block ('" + itemSplit[0] + "') not found.");
                                return;
                            }
                        }
                        catch (Exception e) {
                            if (MC1210.isValidBlock(itemSplit[0])) break block19;
                            MC1210.cancelCreation(event, "Block ('" + itemSplit[0] + "') not found.");
                            return;
                        }
                    }
                }
                if (event.getLine(3).length() > 0) {
                    try {
                        String[] doorSplit = event.getLine(3).split(":");
                        String[] doorPosition = doorSplit[0].split(",");
                        Integer.parseInt(doorPosition[0]);
                        if (doorPosition.length == 2) {
                            Integer.parseInt(doorPosition[1]);
                        }
                        if (doorPosition.length == 3) {
                            Integer.parseInt(doorPosition[1]);
                            Integer.parseInt(doorPosition[2]);
                        }
                        if (doorSplit.length == 2) {
                            String[] doorSize = doorSplit[1].split(",");
                            if (Integer.parseInt(doorSize[0]) < 1) {
                                MC1210.cancelCreation(event, "Door width must be more then 0.");
                                return;
                            }
                            if (doorSize.length == 2 && Integer.parseInt(doorSize[1]) < 1) {
                                MC1210.cancelCreation(event, "Door height must be more then 0.");
                                return;
                            }
                            break block20;
                        }
                        MC1210.cancelCreation(event, "Door size required.");
                        return;
                    }
                    catch (Exception e) {
                        MC1210.cancelCreation(event, "Line 4 is not valid.");
                        return;
                    }
                }
                MC1210.cancelCreation(event, "Door position and size required.");
                return;
            }
            MC1210.cancelCreation(event, "Sorry, you are not allowed to build a " + this.Name + ".");
            return;
        }
        player.sendMessage(ChatColor.GREEN + this.Name + " created.");
    }

    private static Point FetchPoint(String data, int a) {
        String[] pointData = data.split(",");
        Point point = new Point(a, a);
        try {
            point.x = Integer.parseInt(pointData[0]);
            if (pointData.length == 2) {
                point.y = Integer.parseInt(pointData[1]);
            }
        }
        catch (Exception ex) {
            return null;
        }
        return point;
    }

    private static Vector FetchVector(String data, int a) {
        String[] pointData = data.split(",");
        Vector point = new Vector(a, a, a);
        try {
            point.setX(Integer.parseInt(pointData[0]));
            if (pointData.length == 2) {
                point.setY(Integer.parseInt(pointData[1]));
                point.setZ(Integer.parseInt("0"));
            }
            if (pointData.length == 3) {
                point.setY(Integer.parseInt(pointData[1]));
                point.setZ(Integer.parseInt(pointData[2]));
            }
        }
        catch (Exception ex) {
            return null;
        }
        return point;
    }

    private static int GetItemID(String data) {
        int itemID = -1;
        itemID = MC1210.getItemIDFromName(data);
        if (itemID < 0) {
            try {
                itemID = Integer.parseInt(data);
            }
            catch (Exception e) {
                return -1;
            }
        }
        return itemID;
    }

    @Override
    public void Execute(Sign signBlock, int State, BlockRedstoneEvent event) {
        Block b;
        int n;
        int n2;
        Location[] locationArray;
        int y;
        int x;
        ArrayList<Location> positions = MC1210.getBlockPositions(signBlock);
        String[] items = signBlock.getLine(2).split("-");
        Vector doorPosition = null;
        Point doorSize = null;
        if (signBlock.getLine(3) != null) {
            String[] doorSplit = signBlock.getLine(3).split(":");
            doorPosition = MC1210.FetchVector(doorSplit[0], 0);
            if (doorSplit.length == 2) {
                doorSize = MC1210.FetchPoint(doorSplit[1], 1);
            }
        }
        if (doorPosition == null || doorSize == null) {
            return;
        }
        String[] itemSplit = items[0].split(":");
        int itemID = MC1210.GetItemID(itemSplit[0]);
        Byte itemData = 0;
        if (itemSplit.length > 1) {
            try {
                itemData = Byte.parseByte(itemSplit[1]);
            }
            catch (Exception e) {
                return;
            }
        }
        int itemID2 = 0;
        Byte itemData2 = 0;
        if (items.length > 1) {
            itemSplit = items[1].split(":");
            itemID2 = MC1210.GetItemID(itemSplit[0]);
            itemData2 = 0;
            if (itemSplit.length > 1) {
                try {
                    itemData2 = Byte.parseByte(itemSplit[1]);
                }
                catch (Exception e) {
                    return;
                }
            }
        }
        if (itemID < 0 || itemID2 < 0) {
            return;
        }
        if (itemID < 0 && !MC1210.isValidBlock(itemID) || !MC1210.isValidBlock(itemID2) && itemID2 > 0) {
            return;
        }
        Location basePosition = MC1210.getICBlock(signBlock);
        Location[] newBlockPositions = new Location[doorSize.x * doorSize.y];
        int direction = MC1210.getDirection(signBlock);
        int hFix = 1;
        int zFix = -1;
        if (direction == 1 || direction == 3) {
            if (direction == 3) {
                hFix = -1;
                zFix = 1;
            }
            x = 0;
            while (x < doorSize.x) {
                y = 0;
                while (y < doorSize.y) {
                    newBlockPositions[x * doorSize.y + y] = new Location(basePosition.getWorld(), basePosition.getX() + (double)((x + doorPosition.getBlockX()) * hFix), basePosition.getY() + (double)y + (double)doorPosition.getBlockY(), basePosition.getZ() + (double)(doorPosition.getBlockZ() * zFix));
                    ++y;
                }
                ++x;
            }
        } else if (direction == 2 || direction == 4) {
            zFix = 1;
            if (direction == 2) {
                hFix = -1;
                zFix = -1;
            }
            x = 0;
            while (x < doorSize.x) {
                y = 0;
                while (y < doorSize.y) {
                    newBlockPositions[x * doorSize.y + y] = new Location(basePosition.getWorld(), basePosition.getX() + (double)(doorPosition.getBlockZ() * zFix), basePosition.getY() + (double)y + (double)doorPosition.getBlockY(), basePosition.getZ() + (double)((x + doorPosition.getBlockX()) * hFix));
                    ++y;
                }
                ++x;
            }
        }
        if (MC1210.isPowered(positions.get(0))) {
            locationArray = newBlockPositions;
            n2 = newBlockPositions.length;
            n = 0;
            while (n < n2) {
                Location pos = locationArray[n];
                b = pos.getBlock();
                if (!MC1210.LocationEquals(b.getLocation(), signBlock.getBlock().getLocation())) {
                    b.setTypeIdAndData(itemID, itemData.byteValue(), true);
                }
                ++n;
            }
            MC1210.switchLever(signBlock, true);
        } else {
            locationArray = newBlockPositions;
            n2 = newBlockPositions.length;
            n = 0;
            while (n < n2) {
                Location pos = locationArray[n];
                b = pos.getBlock();
                if (!MC1210.LocationEquals(b.getLocation(), signBlock.getBlock().getLocation())) {
                    b.setTypeIdAndData(itemID2, itemData2.byteValue(), true);
                }
                ++n;
            }
            MC1210.switchLever(signBlock, false);
        }
        int i = 0;
        while (i < positions.size()) {
            positions.set(i, null);
            ++i;
        }
        positions.clear();
        positions = null;
    }
}

