/*
 * Decompiled with CFR 0.152.
 */
package com.bukkit.gemo.FalseBook.Block;

import com.bukkit.gemo.FalseBook.Block.FalseBookBlockCore;
import com.gemo.utils.FlatFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.bukkit.Material;

public class BlockWorldSettings {
    private FlatFile config;
    private boolean LightswitchEnabled = true;
    private int maxLightswitchToggle = 20;
    private boolean BridgeEnabled = true;
    private boolean DoorEnabled = true;
    private boolean GateEnabled = true;
    private int maxBridgeLength = 20;
    private int maxBridgeSideWidth = 5;
    private int maxGateWidth = 20;
    private int maxDoorSideWidth = 5;
    private int AreaSelectionTool = Material.WOOD_HOE.getId();
    private boolean CraftOnWorkbench = false;
    private float AppleDropChance = 10.0f;
    private boolean readBooks = true;
    private ArrayList<Integer> allowedBridgeBlocks = new ArrayList();
    private ArrayList<Integer> allowedDoorBlocks = new ArrayList();
    private ArrayList<Integer> allowedGateBlocks = new ArrayList();

    public BlockWorldSettings(String FileName, String worldName) {
        this.loadSettings(FileName, worldName);
    }

    public FlatFile getConfig() {
        return this.config;
    }

    public void setConfig(FlatFile config) {
        this.config = config;
    }

    public boolean saveSettings(String FileName, String worldName) {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        folder = new File("plugins/FalseBook/" + worldName);
        folder.mkdirs();
        try {
            this.config = new FlatFile("FalseBook/" + worldName + "/" + FileName, false);
            this.config.setInt("MaxBridgeLength", this.maxBridgeLength);
            this.config.setInt("MaxBridgeSideWidth", this.maxBridgeSideWidth);
            this.config.setInt("MaxDoorSideWidth", this.maxDoorSideWidth);
            this.config.setInt("MaxGateWidth", this.maxGateWidth);
            this.config.setBoolean("BridgeEnabled", this.BridgeEnabled);
            this.config.setBoolean("DoorEnabled", this.DoorEnabled);
            this.config.setBoolean("GateEnabled", this.GateEnabled);
            this.config.setInt("AreaSelectionTool", this.AreaSelectionTool);
            this.config.setBoolean("CraftCauldronOnWorkbench", this.CraftOnWorkbench);
            this.config.setFloat("AppleDropChance", this.AppleDropChance);
            this.config.setBoolean("ReadableBookshelfs", this.readBooks);
            this.config.setBoolean("LightswitchEnabled", this.LightswitchEnabled);
            this.config.setInt("maxLightswitchToggle", this.maxLightswitchToggle);
            if (this.allowedBridgeBlocks.size() == 0) {
                this.allowedBridgeBlocks.add(1);
                this.allowedBridgeBlocks.add(2);
                this.allowedBridgeBlocks.add(3);
                this.allowedBridgeBlocks.add(4);
                this.allowedBridgeBlocks.add(5);
                this.allowedBridgeBlocks.add(17);
                this.allowedBridgeBlocks.add(20);
                this.allowedBridgeBlocks.add(24);
                this.allowedBridgeBlocks.add(35);
                this.allowedBridgeBlocks.add(43);
                this.allowedBridgeBlocks.add(44);
                this.allowedBridgeBlocks.add(48);
                this.allowedBridgeBlocks.add(49);
            }
            this.config.setIntArrayList("AllowedBridgeBlocks", this.allowedBridgeBlocks, ",");
            if (this.allowedDoorBlocks.size() == 0) {
                this.allowedDoorBlocks.add(1);
                this.allowedDoorBlocks.add(2);
                this.allowedDoorBlocks.add(3);
                this.allowedDoorBlocks.add(4);
                this.allowedDoorBlocks.add(5);
                this.allowedDoorBlocks.add(17);
                this.allowedDoorBlocks.add(20);
                this.allowedDoorBlocks.add(24);
                this.allowedDoorBlocks.add(35);
                this.allowedDoorBlocks.add(43);
                this.allowedDoorBlocks.add(44);
                this.allowedDoorBlocks.add(48);
                this.allowedDoorBlocks.add(49);
            }
            this.config.setIntArrayList("AllowedDoorBlocks", this.allowedDoorBlocks, ",");
            if (this.allowedGateBlocks.size() == 0) {
                this.allowedGateBlocks.add(85);
            }
            this.config.setIntArrayList("AllowedGateBlocks", this.allowedGateBlocks, ",");
            this.config.writeFile();
            return true;
        }
        catch (IOException e) {
            FalseBookBlockCore.printInConsole("Error while saving file: plugins/FalseBook/" + worldName + "/" + FileName);
            return false;
        }
    }

    public boolean loadSettings(String FileName, String worldName) {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        folder = new File("plugins/FalseBook/" + worldName);
        folder.mkdirs();
        try {
            this.config = new FlatFile("FalseBook/" + worldName + "/" + FileName, false);
            if (this.config.readFile()) {
                this.maxBridgeLength = this.config.getInt("MaxBridgeLength", this.maxBridgeLength);
                this.maxBridgeSideWidth = this.config.getInt("MaxBridgeSideWidth", this.maxBridgeSideWidth);
                this.maxDoorSideWidth = this.config.getInt("MaxDoorSideWidth", this.maxDoorSideWidth);
                this.maxGateWidth = this.config.getInt("MaxGateWidth", this.maxGateWidth);
                this.BridgeEnabled = this.config.getBoolean("BridgeEnabled", this.BridgeEnabled);
                this.DoorEnabled = this.config.getBoolean("DoorEnabled", this.DoorEnabled);
                this.GateEnabled = this.config.getBoolean("GateEnabled", this.GateEnabled);
                this.allowedBridgeBlocks = this.config.getIntArrayList("AllowedBridgeBlocks", ",");
                this.allowedDoorBlocks = this.config.getIntArrayList("AllowedDoorBlocks", ",");
                this.allowedGateBlocks = this.config.getIntArrayList("AllowedGateBlocks", ",");
                this.AreaSelectionTool = this.config.getInt("AreaSelectionTool", this.AreaSelectionTool);
                this.CraftOnWorkbench = this.config.getBoolean("CraftCauldronOnWorkbench", this.CraftOnWorkbench);
                this.AppleDropChance = this.config.getFloat("AppleDropChance", this.AppleDropChance);
                this.readBooks = this.config.getBoolean("ReadableBookshelfs", this.readBooks);
                this.LightswitchEnabled = this.config.getBoolean("LightswitchEnabled", this.LightswitchEnabled);
                this.maxLightswitchToggle = this.config.getInt("maxLightswitchToggle", this.maxLightswitchToggle);
                this.saveSettings(FileName, worldName);
            } else {
                this.saveSettings(FileName, worldName);
            }
            return true;
        }
        catch (Exception e) {
            try {
                FalseBookBlockCore.printInConsole("Error while reading file: plugins/FalseBook/" + worldName + "/" + FileName);
                this.config.regenerateFile("FalseBook/" + worldName + "/" + FileName);
                this.saveSettings(FileName, worldName);
                FalseBookBlockCore.printInConsole("recreated file: plugins/FalseBook/" + worldName + "/" + FileName);
                return true;
            }
            catch (IOException e1) {
                FalseBookBlockCore.printInConsole("Error while reading file: plugins/FalseBook/" + worldName + "/" + FileName);
                return false;
            }
        }
    }

    public boolean isBridgeEnabled() {
        return this.BridgeEnabled;
    }

    public void setBridgeEnabled(boolean bridgeEnabled) {
        this.BridgeEnabled = bridgeEnabled;
    }

    public boolean isDoorEnabled() {
        return this.DoorEnabled;
    }

    public void setDoorEnabled(boolean doorEnabled) {
        this.DoorEnabled = doorEnabled;
    }

    public boolean isGateEnabled() {
        return this.GateEnabled;
    }

    public void setGateEnabled(boolean gateEnabled) {
        this.GateEnabled = gateEnabled;
    }

    public int getMaxBridgeLength() {
        return this.maxBridgeLength;
    }

    public void setMaxBridgeLength(int maxBridgeLength) {
        this.maxBridgeLength = maxBridgeLength;
    }

    public int getMaxBridgeSideWidth() {
        return this.maxBridgeSideWidth;
    }

    public void setMaxBridgeSideWidth(int maxBridgeSideWidth) {
        this.maxBridgeSideWidth = maxBridgeSideWidth;
    }

    public int getMaxGateWidth() {
        return this.maxGateWidth;
    }

    public void setMaxGateWidth(int maxGateWidth) {
        this.maxGateWidth = maxGateWidth;
    }

    public int getMaxDoorSideWidth() {
        return this.maxDoorSideWidth;
    }

    public void setMaxDoorSideWidth(int maxDoorSideWidth) {
        this.maxDoorSideWidth = maxDoorSideWidth;
    }

    public int getAreaSelectionTool() {
        return this.AreaSelectionTool;
    }

    public void setAreaSelectionTool(int areaSelectionTool) {
        this.AreaSelectionTool = areaSelectionTool;
    }

    public boolean isCraftOnWorkbench() {
        return this.CraftOnWorkbench;
    }

    public void setCraftOnWorkbench(boolean craftOnWorkbench) {
        this.CraftOnWorkbench = craftOnWorkbench;
    }

    public float getAppleDropChance() {
        return this.AppleDropChance;
    }

    public void setAppleDropChance(int appleDropChance) {
        this.AppleDropChance = appleDropChance;
    }

    public boolean isReadBooks() {
        return this.readBooks;
    }

    public void setReadBooks(boolean readBooks) {
        this.readBooks = readBooks;
    }

    public ArrayList<Integer> getAllowedGateBlocks() {
        return this.allowedGateBlocks;
    }

    public void setAllowedGateBlocks(ArrayList<Integer> allowedGateBlocks) {
        this.allowedGateBlocks = allowedGateBlocks;
    }

    public ArrayList<Integer> getAllowedBridgeBlocks() {
        return this.allowedBridgeBlocks;
    }

    public void setAllowedBridgeBlocks(ArrayList<Integer> allowedBridgeBlocks) {
        this.allowedBridgeBlocks = allowedBridgeBlocks;
    }

    public ArrayList<Integer> getAllowedDoorBlocks() {
        return this.allowedDoorBlocks;
    }

    public void setAllowedDoorBlocks(ArrayList<Integer> allowedDoorBlocks) {
        this.allowedDoorBlocks = allowedDoorBlocks;
    }

    public boolean isLightswitchEnabled() {
        return this.LightswitchEnabled;
    }

    public void setLightswitchEnabled(boolean lightswitchEnabled) {
        this.LightswitchEnabled = lightswitchEnabled;
    }

    public int getMaxLightswitchToggle() {
        return this.maxLightswitchToggle;
    }

    public void setMaxLightswitchToggle(int maxLightswitchToggle) {
        this.maxLightswitchToggle = maxLightswitchToggle;
    }
}

