/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.Cart;

import com.gemo.FalseBook.Cart.CartWorldSettings;
import com.gemo.FalseBook.Cart.FalseBookCartBlockListener;
import com.gemo.FalseBook.Cart.FalseBookCartVehicleListener;
import com.gemo.FalseBook.Core.FalseBookCore;
import com.gemo.utils.FileUtils;
import com.gemo.utils.UtilPermissions;
import java.io.File;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class FalseBookCartCore
extends JavaPlugin {
    private FalseBookCore core;
    private static String pluginName;
    public static Server server;
    private FalseBookCartVehicleListener cartListener;
    private FalseBookCartBlockListener blockListener;
    public static HashMap<String, String> playerStationSelection;
    private static HashMap<String, CartWorldSettings> Settings;

    public static void printInConsole(String str) {
        System.out.println("[FalseBook Cart] " + str);
    }

    public void onDisable() {
        if (this.searchCore()) {
            System.out.println(String.valueOf(pluginName) + " disabled");
        }
    }

    public void onEnable() {
        if (!this.searchCore()) {
            FalseBookCartCore.printInConsole(">>>>> FalseBookCore.jar not found! FalseBookCart.jar is being disabled!");
            return;
        }
        this.loadVersion();
        server = this.getServer();
        this.checkForDefaultSettings();
        this.loadWorldSettings();
        this.cartListener = new FalseBookCartVehicleListener(this);
        this.blockListener = new FalseBookCartBlockListener(this);
        playerStationSelection = new HashMap();
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvent(Event.Type.SIGN_CHANGE, (Listener)this.blockListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_PLACE, (Listener)this.blockListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.REDSTONE_CHANGE, (Listener)this.blockListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.VEHICLE_CREATE, (Listener)this.cartListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.VEHICLE_MOVE, (Listener)this.cartListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.VEHICLE_COLLISION_ENTITY, (Listener)this.cartListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.VEHICLE_COLLISION_BLOCK, (Listener)this.cartListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.VEHICLE_EXIT, (Listener)this.cartListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.VEHICLE_DESTROY, (Listener)this.cartListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.VEHICLE_DAMAGE, (Listener)this.cartListener, Event.Priority.Normal, (Plugin)this);
        System.out.println(String.valueOf(pluginName) + " enabled");
    }

    public boolean playerCanUseCommand(Player player, String command) {
        return UtilPermissions.playerCanUseCommand((Player)player, (String)command);
    }

    public String getGroupName(Player player) {
        return UtilPermissions.getGroupName((Player)player);
    }

    public FalseBookCartVehicleListener getCartListener() {
        return this.cartListener;
    }

    public FalseBookCartBlockListener getBlockListener() {
        return this.blockListener;
    }

    public void loadVersion() {
        PluginDescriptionFile pdfFile = this.getDescription();
        pluginName = String.valueOf(pdfFile.getName()) + " v" + pdfFile.getVersion() + " by GeMo";
    }

    private boolean searchCore() {
        PluginManager pm = this.getServer().getPluginManager();
        if (pm.getPlugin("FalseBookCore") != null) {
            if (pm.getPlugin("FalseBookCore").isEnabled()) {
                this.setCore((FalseBookCore)pm.getPlugin("FalseBookCore"));
                return true;
            }
            this.setCore((FalseBookCore)pm.getPlugin("FalseBookCore"));
            return true;
        }
        return false;
    }

    public void setCore(FalseBookCore core) {
        this.core = core;
    }

    public FalseBookCore getCore() {
        return this.core;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (label.equalsIgnoreCase("fbcart") && player.isOp()) {
                if (args != null && args.length == 1 && args[0].equalsIgnoreCase("reloadsettings")) {
                    player.sendMessage(ChatColor.YELLOW + "Reloading Cart-Settings...");
                    Settings.clear();
                    this.checkForDefaultSettings();
                    this.loadWorldSettings();
                    player.sendMessage(ChatColor.YELLOW + "Cart-Settings reloaded successfully!");
                }
            } else if (label.equalsIgnoreCase("fbst") && UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.command.fbst") && args != null) {
                if (args.length == 1) {
                    FalseBookCartCore.setStation(player, args[0]);
                    player.sendMessage(ChatColor.GREEN + "Setting Current Station to: " + ChatColor.WHITE + FalseBookCartCore.getStation(player));
                } else {
                    player.sendMessage(ChatColor.GRAY + "Current Station: " + FalseBookCartCore.getStation(player));
                }
            }
        }
        return true;
    }

    public void checkForDefaultSettings() {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        File f = new File("plugins/FalseBook/FalseBookCart.properties");
        if (!f.exists()) {
            return;
        }
        f = null;
        int i = 0;
        while (i < server.getWorlds().size()) {
            this.checkForDefaultSettings(((World)server.getWorlds().get(i)).getName());
            ++i;
        }
    }

    public void checkForDefaultSettings(String worldName) {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        File f = new File("plugins/FalseBook/FalseBookCart.properties");
        if (!f.exists()) {
            return;
        }
        f = null;
        if (server.getWorld(worldName) == null) {
            return;
        }
        folder = new File("plugins/FalseBook/" + server.getWorld(worldName).getName());
        folder.mkdirs();
        try {
            f = new File("plugins/FalseBook/" + server.getWorld(worldName).getName() + "/FalseBookCart.properties");
            if (!f.exists()) {
                FileUtils.copyFile((String)"plugins/FalseBook/FalseBookCart.properties", (String)("plugins/FalseBook/" + server.getWorld(worldName).getName() + "/FalseBookCart.properties"));
            }
        }
        catch (Exception e) {
            FalseBookCartCore.printInConsole("Error while copying 'plugins/FalseBook/FalseBookCart.properties' to 'plugins/FalseBook/" + server.getWorld(worldName).getName() + "/FalseBookCart.properties'");
        }
    }

    public void loadWorldSettings() {
        if (Settings != null) {
            Settings.clear();
        } else {
            Settings = new HashMap();
        }
        int i = 0;
        while (i < server.getWorlds().size()) {
            this.loadWorldSettings(((World)server.getWorlds().get(i)).getName());
            ++i;
        }
    }

    public void loadWorldSettings(String worldName) {
        if (server.getWorld(worldName) == null) {
            return;
        }
        Settings.put(server.getWorld(worldName).getName(), new CartWorldSettings("FalseBookCart.properties", server.getWorld(worldName).getName()));
    }

    public static void setStation(Player player, String station) {
        if (playerStationSelection.containsKey(player.getName())) {
            playerStationSelection.remove(player.getName());
        }
        playerStationSelection.put(player.getName(), station);
    }

    public static void clearStation(Player player) {
        if (playerStationSelection.containsKey(player.getName())) {
            playerStationSelection.remove(player.getName());
        }
    }

    public static String getStation(Player player) {
        if (playerStationSelection.containsKey(player.getName())) {
            return playerStationSelection.get(player.getName());
        }
        return null;
    }

    public static HashMap<String, CartWorldSettings> getSettings() {
        return Settings;
    }
}

