/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.worldguard.blacklist.Blacklist;
import com.sk89q.worldguard.blacklist.BlacklistLogger;
import com.sk89q.worldguard.blacklist.loggers.ConsoleLoggerHandler;
import com.sk89q.worldguard.blacklist.loggers.DatabaseLoggerHandler;
import com.sk89q.worldguard.blacklist.loggers.FileLoggerHandler;
import com.sk89q.worldguard.bukkit.BukkitBlacklist;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.chest.ChestProtection;
import com.sk89q.worldguard.chest.SignChestProtection;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.CreatureType;
import org.bukkit.entity.Player;
import org.bukkit.util.config.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldConfiguration {
    public static final String CONFIG_HEADER = "#\r\n# WorldGuard's world configuration file\r\n#\r\n# This is a world configuration file. Anything placed into here will only\r\n# affect this world. If you don't put anything in this file, then the\r\n# settings will be inherited from the main configuration file.\r\n#\r\n# If you see {} below, that means that there are NO entries in this file.\r\n# Remove the {} and add your own entries.\r\n#\r\n";
    private static final Logger logger = Logger.getLogger("Minecraft.WorldGuard");
    private WorldGuardPlugin plugin;
    private String worldName;
    private Configuration parentConfig;
    private Configuration config;
    private File configFile;
    private File blacklistFile;
    private Blacklist blacklist;
    private ChestProtection chestProtection = new SignChestProtection();
    public boolean opPermissions;
    public boolean fireSpreadDisableToggle;
    public boolean enforceOneSession;
    public boolean itemDurability;
    public boolean classicWater;
    public boolean simulateSponge;
    public int spongeRadius;
    public boolean pumpkinScuba;
    public boolean redstoneSponges;
    public boolean noPhysicsGravel;
    public boolean noPhysicsSand;
    public boolean allowPortalAnywhere;
    public Set<Integer> preventWaterDamage;
    public boolean blockTNT;
    public boolean blockLighter;
    public boolean disableFireSpread;
    public Set<Integer> disableFireSpreadBlocks;
    public boolean preventLavaFire;
    public Set<Integer> allowedLavaSpreadOver;
    public boolean blockCreeperExplosions;
    public boolean blockCreeperBlockDamage;
    public int loginProtection;
    public int spawnProtection;
    public boolean kickOnDeath;
    public boolean exactRespawn;
    public boolean teleportToHome;
    public boolean disableContactDamage;
    public boolean disableFallDamage;
    public boolean disableLavaDamage;
    public boolean disableFireDamage;
    public boolean disableLightningDamage;
    public boolean disableDrowningDamage;
    public boolean disableSuffocationDamage;
    public boolean teleportOnSuffocation;
    public boolean disableVoidDamage;
    public boolean teleportOnVoid;
    public boolean disableExplosionDamage;
    public boolean disableMobDamage;
    public boolean useRegions;
    public boolean highFreqFlags;
    public int regionWand = 287;
    public Set<CreatureType> blockCreatureSpawn;
    public boolean useiConomy;
    public boolean buyOnClaim;
    public double buyOnClaimPrice;
    public int maxClaimVolume;
    public boolean claimOnlyInsideExistingRegions;
    public int maxRegionCountPerPlayer;
    public boolean antiWolfDumbness;
    public boolean signChestProtection;
    public boolean removeInfiniteStacks;
    public boolean disableCreatureCropTrampling;
    public boolean disablePlayerCropTrampling;
    public boolean preventLightningFire;
    public Set<Integer> disallowedLightningBlocks;
    public boolean disableThunder;
    public boolean disableWeather;
    public boolean alwaysRaining;
    public boolean alwaysThundering;
    public boolean disablePigZap;
    public boolean disableCreeperPower;
    public boolean disableHealthRegain;
    public boolean disableMushroomSpread;
    public boolean disableIceMelting;
    public boolean disableSnowMelting;
    public boolean disableSnowFormation;
    public boolean disableIceFormation;
    public boolean disableLeafDecay;

    public WorldConfiguration(WorldGuardPlugin plugin, String worldName) {
        File baseFolder = new File(plugin.getDataFolder(), "worlds/" + worldName);
        this.configFile = new File(baseFolder, "config.yml");
        this.blacklistFile = new File(baseFolder, "blacklist.txt");
        this.plugin = plugin;
        this.worldName = worldName;
        this.parentConfig = plugin.getConfiguration();
        WorldGuardPlugin.createDefaultConfiguration(this.configFile, "config_world.yml");
        WorldGuardPlugin.createDefaultConfiguration(this.blacklistFile, "blacklist.txt");
        this.config = new Configuration(this.configFile);
        this.loadConfiguration();
        logger.info("WorldGuard: Loaded configuration for world '" + worldName + '\"');
    }

    private boolean getBoolean(String node, boolean def) {
        if (this.config.getProperty(node) != null) {
            return this.config.getBoolean(node, def);
        }
        return this.parentConfig.getBoolean(node, def);
    }

    private String getString(String node, String def) {
        if (this.config.getProperty(node) != null) {
            return this.config.getString(node, def);
        }
        return this.parentConfig.getString(node, def);
    }

    private int getInt(String node, int def) {
        if (this.config.getProperty(node) != null) {
            return this.config.getInt(node, def);
        }
        return this.parentConfig.getInt(node, def);
    }

    private double getDouble(String node, double def) {
        if (this.config.getProperty(node) != null) {
            return this.config.getDouble(node, def);
        }
        return this.parentConfig.getDouble(node, def);
    }

    private List<Integer> getIntList(String node, List<Integer> def) {
        List res = this.config.getProperty(node) != null ? this.config.getIntList(node, def) : this.parentConfig.getIntList(node, def);
        if (res == null || res.size() == 0) {
            this.parentConfig.setProperty(node, new ArrayList());
        }
        return res;
    }

    private List<String> getStringList(String node, List<String> def) {
        List res = this.config.getProperty(node) != null ? this.config.getStringList(node, def) : this.parentConfig.getStringList(node, def);
        if (res == null || res.size() == 0) {
            this.parentConfig.setProperty(node, new ArrayList());
        }
        return res;
    }

    private void loadConfiguration() {
        this.config.load();
        this.opPermissions = this.getBoolean("op-permissions", true);
        this.enforceOneSession = this.getBoolean("protection.enforce-single-session", true);
        this.itemDurability = this.getBoolean("protection.item-durability", true);
        this.removeInfiniteStacks = this.getBoolean("protection.remove-infinite-stacks", false);
        this.classicWater = this.getBoolean("simulation.classic-water", false);
        this.simulateSponge = this.getBoolean("simulation.sponge.enable", true);
        this.spongeRadius = Math.max(1, this.getInt("simulation.sponge.radius", 3)) - 1;
        this.redstoneSponges = this.getBoolean("simulation.sponge.redstone", false);
        this.pumpkinScuba = this.getBoolean("pumpkin-scuba", false);
        this.disableHealthRegain = this.getBoolean("default.disable-health-regain", false);
        this.noPhysicsGravel = this.getBoolean("physics.no-physics-gravel", false);
        this.noPhysicsSand = this.getBoolean("physics.no-physics-sand", false);
        this.allowPortalAnywhere = this.getBoolean("physics.allow-portal-anywhere", false);
        this.preventWaterDamage = new HashSet<Integer>(this.getIntList("physics.disable-water-damage-blocks", null));
        this.blockTNT = this.getBoolean("ignition.block-tnt", false);
        this.blockLighter = this.getBoolean("ignition.block-lighter", false);
        this.preventLavaFire = this.getBoolean("fire.disable-lava-fire-spread", true);
        this.disableFireSpread = this.getBoolean("fire.disable-all-fire-spread", false);
        this.disableFireSpreadBlocks = new HashSet<Integer>(this.getIntList("fire.disable-fire-spread-blocks", null));
        this.allowedLavaSpreadOver = new HashSet<Integer>(this.getIntList("fire.lava-spread-blocks", null));
        this.blockCreeperExplosions = this.getBoolean("mobs.block-creeper-explosions", false);
        this.blockCreeperBlockDamage = this.getBoolean("mobs.block-creeper-block-damage", false);
        this.antiWolfDumbness = this.getBoolean("mobs.anti-wolf-dumbness", false);
        this.loginProtection = this.getInt("spawn.login-protection", 3);
        this.spawnProtection = this.getInt("spawn.spawn-protection", 0);
        this.kickOnDeath = this.getBoolean("spawn.kick-on-death", false);
        this.exactRespawn = this.getBoolean("spawn.exact-respawn", false);
        this.teleportToHome = this.getBoolean("spawn.teleport-to-home-on-death", false);
        this.disableFallDamage = this.getBoolean("player-damage.disable-fall-damage", false);
        this.disableLavaDamage = this.getBoolean("player-damage.disable-lava-damage", false);
        this.disableFireDamage = this.getBoolean("player-damage.disable-fire-damage", false);
        this.disableLightningDamage = this.getBoolean("player-damage.disable-lightning-damage", false);
        this.disableDrowningDamage = this.getBoolean("player-damage.disable-drowning-damage", false);
        this.disableSuffocationDamage = this.getBoolean("player-damage.disable-suffocation-damage", false);
        this.disableContactDamage = this.getBoolean("player-damage.disable-contact-damage", false);
        this.teleportOnSuffocation = this.getBoolean("player-damage.teleport-on-suffocation", false);
        this.disableVoidDamage = this.getBoolean("player-damage.disable-void-damage", false);
        this.teleportOnVoid = this.getBoolean("player-damage.teleport-on-void-falling", false);
        this.disableExplosionDamage = this.getBoolean("player-damage.disable-explosion-damage", false);
        this.disableMobDamage = this.getBoolean("player-damage.disable-mob-damage", false);
        this.signChestProtection = this.getBoolean("chest-protection.enable", false);
        this.disableCreatureCropTrampling = this.getBoolean("crops.disable-creature-trampling", false);
        this.disablePlayerCropTrampling = this.getBoolean("crops.disable-player-trampling", false);
        this.disallowedLightningBlocks = new HashSet<Integer>(this.getIntList("weather.prevent-lightning-strike-blocks", null));
        this.preventLightningFire = this.getBoolean("weather.disable-lightning-strike-fire", false);
        this.disableThunder = this.getBoolean("weather.disable-thunderstorm", false);
        this.disableWeather = this.getBoolean("weather.disable-weather", false);
        this.disablePigZap = this.getBoolean("weather.disable-pig-zombification", false);
        this.disableCreeperPower = this.getBoolean("weather.disable-powered-creepers", false);
        this.alwaysRaining = this.getBoolean("weather.always-raining", false);
        this.alwaysThundering = this.getBoolean("weather.always-thundering", false);
        this.disableMushroomSpread = this.getBoolean("dynamics.disable-mushroom-spread", false);
        this.disableIceMelting = this.getBoolean("dynamics.disable-ice-melting", false);
        this.disableSnowMelting = this.getBoolean("dynamics.disable-snow-melting", false);
        this.disableSnowFormation = this.getBoolean("dynamics.disable-snow-formation", false);
        this.disableIceFormation = this.getBoolean("dynamics.disable-ice-formation", false);
        this.disableLeafDecay = this.getBoolean("dynamics.disable-leaf-decay", false);
        this.useRegions = this.getBoolean("regions.enable", true);
        this.highFreqFlags = this.getBoolean("regions.high-frequency-flags", false);
        this.regionWand = this.getInt("regions.wand", 287);
        this.maxClaimVolume = this.getInt("regions.max-claim-volume", 30000);
        this.claimOnlyInsideExistingRegions = this.getBoolean("regions.claim-only-inside-existing-regions", false);
        this.maxRegionCountPerPlayer = this.getInt("regions.max-region-count-per-player", 7);
        this.useiConomy = this.getBoolean("iconomy.enable", false);
        this.buyOnClaim = this.getBoolean("iconomy.buy-on-claim", false);
        this.buyOnClaimPrice = this.getDouble("iconomy.buy-on-claim-price", 1.0);
        this.blockCreatureSpawn = new HashSet<CreatureType>();
        for (String creatureName : this.getStringList("mobs.block-creature-spawn", null)) {
            CreatureType creature = CreatureType.fromName((String)creatureName);
            if (creature == null) {
                logger.warning("WorldGuard: Unknown mob type '" + creatureName + "'");
                continue;
            }
            this.blockCreatureSpawn.add(creature);
        }
        boolean useBlacklistAsWhitelist = this.getBoolean("blacklist.use-as-whitelist", false);
        boolean logConsole = this.getBoolean("blacklist.logging.console.enable", true);
        boolean logDatabase = this.getBoolean("blacklist.logging.database.enable", false);
        String dsn = this.getString("blacklist.logging.database.dsn", "jdbc:mysql://localhost:3306/minecraft");
        String user = this.getString("blacklist.logging.database.user", "root");
        String pass = this.getString("blacklist.logging.database.pass", "");
        String table = this.getString("blacklist.logging.database.table", "blacklist_events");
        boolean logFile = this.getBoolean("blacklist.logging.file.enable", false);
        String logFilePattern = this.getString("blacklist.logging.file.path", "worldguard/logs/%Y-%m-%d.log");
        int logFileCacheSize = Math.max(1, this.getInt("blacklist.logging.file.open-files", 10));
        try {
            if (this.blacklist != null) {
                this.blacklist.getLogger().close();
            }
            BukkitBlacklist blist = new BukkitBlacklist(useBlacklistAsWhitelist, this.plugin);
            blist.load(this.blacklistFile);
            if (blist.isEmpty()) {
                this.blacklist = null;
            } else {
                this.blacklist = blist;
                logger.log(Level.INFO, "WorldGuard: Blacklist loaded.");
                BlacklistLogger blacklistLogger = blist.getLogger();
                if (logDatabase) {
                    blacklistLogger.addHandler(new DatabaseLoggerHandler(dsn, user, pass, table, this.worldName));
                }
                if (logConsole) {
                    blacklistLogger.addHandler(new ConsoleLoggerHandler(this.worldName));
                }
                if (logFile) {
                    FileLoggerHandler handler = new FileLoggerHandler(logFilePattern, logFileCacheSize, this.worldName);
                    blacklistLogger.addHandler(handler);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARNING, "WorldGuard blacklist does not exist.");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not load WorldGuard blacklist: " + e.getMessage());
        }
        if (this.getBoolean("summary-on-start", true)) {
            logger.log(Level.INFO, this.enforceOneSession ? "WorldGuard: (" + this.worldName + ") Single session is enforced." : "WorldGuard: (" + this.worldName + ") Single session is NOT ENFORCED.");
            logger.log(Level.INFO, this.blockTNT ? "WorldGuard: (" + this.worldName + ") TNT ignition is blocked." : "WorldGuard: (" + this.worldName + ") TNT ignition is PERMITTED.");
            logger.log(Level.INFO, this.blockLighter ? "WorldGuard: (" + this.worldName + ") Lighters are blocked." : "WorldGuard: (" + this.worldName + ") Lighters are PERMITTED.");
            logger.log(Level.INFO, this.preventLavaFire ? "WorldGuard: (" + this.worldName + ") Lava fire is blocked." : "WorldGuard: (" + this.worldName + ") Lava fire is PERMITTED.");
            if (this.disableFireSpread) {
                logger.log(Level.INFO, "WorldGuard: (" + this.worldName + ") All fire spread is disabled.");
            } else if (this.disableFireSpreadBlocks.size() > 0) {
                logger.log(Level.INFO, "WorldGuard: (" + this.worldName + ") Fire spread is limited to " + this.disableFireSpreadBlocks.size() + " block types.");
            } else {
                logger.log(Level.INFO, "WorldGuard: (" + this.worldName + ") Fire spread is UNRESTRICTED.");
            }
        }
        try {
            this.config.setHeader(CONFIG_HEADER);
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.config.save();
    }

    public Blacklist getBlacklist() {
        return this.blacklist;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public boolean isChestProtected(Block block, Player player) {
        if (!this.signChestProtection) {
            return false;
        }
        if (this.plugin.hasPermission((CommandSender)player, "worldguard.chest-protection.override") || this.plugin.hasPermission((CommandSender)player, "worldguard.override.chest-protection")) {
            return false;
        }
        return this.chestProtection.isProtected(block, player);
    }

    public boolean isChestProtected(Block block) {
        if (!this.signChestProtection) {
            return false;
        }
        return this.chestProtection.isProtected(block, null);
    }

    public boolean isChestProtectedPlacement(Block block, Player player) {
        if (!this.signChestProtection) {
            return false;
        }
        if (this.plugin.hasPermission((CommandSender)player, "worldguard.chest-protection.override") || this.plugin.hasPermission((CommandSender)player, "worldguard.override.chest-protection")) {
            return false;
        }
        return this.chestProtection.isProtectedPlacement(block, player);
    }

    public boolean isAdjacentChestProtected(Block block, Player player) {
        if (!this.signChestProtection) {
            return false;
        }
        if (this.plugin.hasPermission((CommandSender)player, "worldguard.chest-protection.override") || this.plugin.hasPermission((CommandSender)player, "worldguard.override.chest-protection")) {
            return false;
        }
        return this.chestProtection.isAdjacentChestProtected(block, player);
    }

    public ChestProtection getChestProtection() {
        return this.chestProtection;
    }
}

