/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import java.util.logging.Logger;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.WorldListener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class WorldGuardWorldListener
extends WorldListener {
    private static final Logger logger = Logger.getLogger("Minecraft.WorldGuard");
    private WorldGuardPlugin plugin;

    public WorldGuardWorldListener(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerEvents() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        this.registerEvent("CHUNK_LOAD", Event.Priority.Normal);
    }

    private void registerEvent(String typeName, Event.Priority priority) {
        try {
            Event.Type type = Event.Type.valueOf((String)typeName);
            PluginManager pm = this.plugin.getServer().getPluginManager();
            pm.registerEvent(type, (Listener)this, priority, (Plugin)this.plugin);
        }
        catch (IllegalArgumentException e) {
            logger.info("WorldGuard: Unable to register missing event type " + typeName);
        }
    }

    public void onChunkLoad(ChunkLoadEvent event) {
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        if (cfg.activityHaltToggle) {
            int removed = 0;
            for (Entity entity : event.getChunk().getEntities()) {
                if (!(entity instanceof Item) && (!(entity instanceof LivingEntity) || entity instanceof Tameable || entity instanceof Player)) continue;
                entity.remove();
                ++removed;
            }
            if (removed > 50) {
                logger.info("WG Halt-Act: " + removed + " entities (>50) auto-removed from " + event.getChunk().toString());
            }
        }
    }
}

