/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection.flags;

import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.InvalidFlagFormat;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorFlag
extends Flag<Vector> {
    public VectorFlag(String name, char legacyCode) {
        super(name, legacyCode);
    }

    public VectorFlag(String name) {
        super(name);
    }

    @Override
    public Vector parseInput(WorldGuardPlugin plugin, CommandSender sender, String input) throws InvalidFlagFormat {
        input = input.trim();
        try {
            return BukkitUtil.toVector(plugin.checkPlayer(sender).getLocation());
        }
        catch (CommandException e) {
            throw new InvalidFlagFormat(e.getMessage());
        }
    }

    @Override
    public Vector unmarshal(Object o) {
        if (o instanceof Map) {
            Map map = (Map)o;
            Object rawX = map.get("x");
            Object rawY = map.get("y");
            Object rawZ = map.get("z");
            if (rawX == null || rawY == null || rawZ == null) {
                return null;
            }
            return new Vector(this.toNumber(rawX), this.toNumber(rawY), this.toNumber(rawZ));
        }
        return null;
    }

    @Override
    public Object marshal(Vector o) {
        HashMap<String, Double> vec = new HashMap<String, Double>();
        vec.put("x", o.getX());
        vec.put("y", o.getY());
        vec.put("z", o.getZ());
        return vec;
    }

    private double toNumber(Object o) {
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).longValue();
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        return 0.0;
    }
}

