/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.myhome.timers;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import me.taylorkelly.myhome.HomePermissions;
import me.taylorkelly.myhome.HomeSettings;
import me.taylorkelly.myhome.timers.PlayerTaskDetails;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class CoolDownManager {
    private static final int SERVER_TICKS_PER_SEC = 20;
    private final HashMap<String, PlayerTaskDetails> players = new HashMap();

    public void addPlayer(Player player, Plugin plugin) {
        if (this.isCoolingBypassed(player)) {
            return;
        }
        int timer = this.getTimer(player);
        if (timer > 0) {
            if (this.players.containsKey(player.getName())) {
                plugin.getServer().getScheduler().cancelTask(this.players.get(player.getName()).getTaskIndex());
            }
            int taskIndex = plugin.getServer().getScheduler().scheduleSyncDelayedTask(plugin, (Runnable)new CoolTask(player, this), (long)(timer * 20));
            this.players.put(player.getName(), new PlayerTaskDetails(taskIndex, System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timer)));
        }
    }

    public boolean playerHasCooled(Player player) {
        return !this.players.containsKey(player.getName());
    }

    public int estimateTimeLeft(Player player) {
        PlayerTaskDetails taskDetails = this.players.get(player.getName());
        if (taskDetails == null) {
            return 0;
        }
        int secondsLeft = (int)TimeUnit.MILLISECONDS.toSeconds(taskDetails.getFinishTime() - System.currentTimeMillis());
        return secondsLeft > 0 ? secondsLeft : 0;
    }

    public int getTimer(Player player) {
        int timer = 0;
        if (HomeSettings.timerByPerms) {
            timer = HomePermissions.integer(player, this.getCoolDownPermissionName(), this.getCoolDownSetting());
            if (HomeSettings.additionalTime) {
                timer += this.getCoolDownSetting();
            }
        } else {
            timer = this.getCoolDownSetting();
        }
        return timer;
    }

    protected abstract int getCoolDownSetting();

    protected abstract String getCoolDownPermissionName();

    protected void removePlayer(String playerName) {
        this.players.remove(playerName);
    }

    protected abstract boolean isCoolingBypassed(Player var1);

    protected void onCoolDownExpiry(Player player) {
    }

    private static class CoolTask
    implements Runnable {
        private final Player player;
        private final CoolDownManager coolDownManager;

        public CoolTask(Player player, CoolDownManager coolDownManager) {
            this.player = player;
            this.coolDownManager = coolDownManager;
        }

        @Override
        public void run() {
            this.coolDownManager.onCoolDownExpiry(this.player);
            this.coolDownManager.removePlayer(this.player.getName());
        }
    }
}

