/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.converters;

import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.sql.PhysDB;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.bukkit.command.CommandSender;

public class ChestProtect
implements Runnable {
    private String[] CHESTS_FILES = new String[]{"../lockedChests.txt", "lockedChests.txt"};
    private int converted = 0;
    private PhysDB physicalDatabase;
    private CommandSender player;

    public ChestProtect() {
        new Thread(this).start();
        this.physicalDatabase = new PhysDB();
    }

    public ChestProtect(CommandSender player) {
        this();
        this.player = player;
    }

    public void convertChests() throws FileNotFoundException, IOException {
        String line;
        String path;
        File file = null;
        String[] arr$ = this.CHESTS_FILES;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(file = new File(path = arr$[i$])).exists(); ++i$) {
        }
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("No Chest Protect chest database found");
        }
        int lineNumber = 0;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            String[] extra;
            String[] split;
            line = line.trim();
            ++lineNumber;
            if (line.startsWith("#") || (split = line.split(",")).length < 5) continue;
            String owner = split[0];
            int x = Integer.parseInt(split[1]);
            int y = Integer.parseInt(split[2]);
            int z = Integer.parseInt(split[3]);
            int type = Integer.parseInt(split[4]);
            int rightsType = -1;
            String users = "";
            if (type == 1) {
                type = 0;
            } else if (type > 1) {
                if (type == 3) {
                    rightsType = 0;
                } else if (type == 4) {
                    rightsType = 1;
                }
                type = 2;
            }
            if (split.length > 5) {
                users = split[5].trim();
            }
            this.log(String.format("Registering chest to %s at location {%d,%d,%d}", owner, x, y, z));
            this.physicalDatabase.registerProtection(0, type, "", owner, "", x, y, z);
            ++this.converted;
            if (rightsType == -1) continue;
            int chestID = this.physicalDatabase.loadProtection("", x, y, z).getId();
            for (String entity : extra = users.split(";")) {
                this.physicalDatabase.registerProtectionRights(chestID, entity, 0, rightsType);
                this.log(String.format("  -> Registering rights to %s on chest %d", entity, chestID));
            }
        }
        reader.close();
    }

    public void log(String str) {
        System.out.println(str);
        if (this.player != null) {
            this.player.sendMessage(str);
        }
    }

    @Override
    public void run() {
        try {
            this.log("LWC Conversion tool for Chest Protect chests");
            this.log("");
            LWCPlugin plugin = new LWCPlugin();
            plugin.loadDatabase();
            this.physicalDatabase = new PhysDB();
            this.physicalDatabase.connect();
            this.physicalDatabase.load();
            this.convertChests();
            this.log("Done.");
            this.log("");
            this.log("Converted >" + this.converted + "< Chest Protect chests to LWC");
            this.log("LWC database now holds " + this.physicalDatabase.getProtectionCount() + " protected chests!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        new ChestProtect();
    }
}

