/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.integration.currency;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.api.Economy;
import com.earth2me.essentials.api.NoLoanPermittedException;
import com.earth2me.essentials.api.UserDoesNotExistException;
import com.griefcraft.integration.ICurrency;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EssentialsCurrency
implements ICurrency {
    private Essentials essentials;

    public EssentialsCurrency() {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("Essentials");
        if (plugin == null) {
            return;
        }
        this.essentials = (Essentials)plugin;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public String format(double money) {
        return Economy.format((double)money);
    }

    @Override
    public String getMoneyName() {
        return this.essentials.getSettings().getCurrencySymbol();
    }

    @Override
    public double getBalance(Player player) {
        try {
            return Economy.getMoney((String)player.getName());
        }
        catch (UserDoesNotExistException e) {
            return 0.0;
        }
    }

    @Override
    public boolean canAfford(Player player, double money) {
        try {
            return Economy.hasEnough((String)player.getName(), (double)money);
        }
        catch (UserDoesNotExistException e) {
            return false;
        }
    }

    @Override
    public double addMoney(Player player, double money) {
        try {
            Economy.add((String)player.getName(), (double)money);
        }
        catch (UserDoesNotExistException e) {
            return 0.0;
        }
        catch (NoLoanPermittedException e) {
            return 0.0;
        }
        return this.getBalance(player);
    }

    @Override
    public double removeMoney(Player player, double money) {
        try {
            Economy.subtract((String)player.getName(), (double)money);
        }
        catch (UserDoesNotExistException e) {
            return 0.0;
        }
        catch (NoLoanPermittedException e) {
            return 0.0;
        }
        return this.getBalance(player);
    }
}

