/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.integration.currency;

import com.griefcraft.integration.ICurrency;
import com.griefcraft.util.config.Configuration;
import com.iCo6.Constants;
import com.iCo6.iConomy;
import com.iCo6.system.Account;
import com.iCo6.system.Accounts;
import com.iCo6.system.Holdings;
import org.bukkit.entity.Player;

public class iConomy6Currency
implements ICurrency {
    private final Accounts accounts = new Accounts();
    private Configuration configuration = Configuration.load("iconomy.yml");
    private String serverAccount = this.configuration.getString("iConomy.serverBankAccount", "");

    public iConomy6Currency() {
        if (!this.serverAccount.isEmpty()) {
            this.accounts.get(this.serverAccount);
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public boolean usingCentralBank() {
        return !this.serverAccount.isEmpty();
    }

    @Override
    public String format(double money) {
        return iConomy.format((double)money);
    }

    @Override
    public String getMoneyName() {
        return (String)Constants.Nodes.Major.getStringList().get(1);
    }

    @Override
    public double getBalance(Player player) {
        if (player == null) {
            return 0.0;
        }
        Account account = this.accounts.get(player.getName());
        if (account == null) {
            return 0.0;
        }
        return account.getHoldings().getBalance();
    }

    @Override
    public boolean canAfford(Player player, double money) {
        if (player == null) {
            return false;
        }
        Account account = this.accounts.get(player.getName());
        return account != null && account.getHoldings().hasEnough(money);
    }

    public boolean canCentralBankAfford(double money) {
        if (!this.usingCentralBank()) {
            return true;
        }
        Account account = this.accounts.get(this.serverAccount);
        return account != null && account.getHoldings().hasEnough(money);
    }

    @Override
    public double addMoney(Player player, double money) {
        Account account;
        if (player == null) {
            return 0.0;
        }
        if (this.usingCentralBank()) {
            if (!this.canCentralBankAfford(money)) {
                return 0.0;
            }
            Account central = this.accounts.get(this.serverAccount);
            if (central == null) {
                return 0.0;
            }
            central.getHoldings().subtract(money);
        }
        if ((account = this.accounts.get(player.getName())) == null) {
            return 0.0;
        }
        Holdings holdings = account.getHoldings();
        holdings.add(money);
        return holdings.getBalance();
    }

    @Override
    public double removeMoney(Player player, double money) {
        Account account;
        if (player == null) {
            return 0.0;
        }
        if (money < 0.0) {
            money = -money;
        }
        if (this.usingCentralBank()) {
            Account central = this.accounts.get(this.serverAccount);
            if (central == null) {
                return 0.0;
            }
            central.getHoldings().add(money);
        }
        if ((account = this.accounts.get(player.getName())) == null) {
            return 0.0;
        }
        Holdings holdings = account.getHoldings();
        if (!holdings.hasEnough(money)) {
            return holdings.getBalance();
        }
        holdings.subtract(money);
        return holdings.getBalance();
    }
}

