/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.listeners;

import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.model.Protection;
import org.bukkit.block.Block;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityListener;

public class LWCEntityListener
extends EntityListener {
    private LWCPlugin plugin;
    public static final int BLAST_RADIUS = 4;

    public LWCEntityListener(LWCPlugin plugin) {
        this.plugin = plugin;
    }

    public void onEntityExplode(EntityExplodeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        boolean ignoreExplosions = this.plugin.getLWC().getConfiguration().getBoolean("core.ignoreExplosions", false);
        for (Block block : event.blockList()) {
            Protection protection = this.plugin.getLWC().getPhysicalDatabase().loadProtection(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
            if (protection == null) continue;
            if (ignoreExplosions) {
                protection.remove();
                continue;
            }
            event.setCancelled(true);
        }
    }
}

