/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.lwc;

import com.firestar.mcbans.mcbans;
import com.griefcraft.cache.CacheSet;
import com.griefcraft.integration.ICurrency;
import com.griefcraft.integration.IPermissions;
import com.griefcraft.integration.currency.BOSECurrency;
import com.griefcraft.integration.currency.EssentialsCurrency;
import com.griefcraft.integration.currency.NoCurrency;
import com.griefcraft.integration.currency.iConomy5Currency;
import com.griefcraft.integration.currency.iConomy6Currency;
import com.griefcraft.integration.permissions.BukkitPermissions;
import com.griefcraft.integration.permissions.NijiPermissions;
import com.griefcraft.integration.permissions.NoPermissions;
import com.griefcraft.integration.permissions.PEXPermissions;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.migration.ConfigPost300;
import com.griefcraft.migration.MySQLPost200;
import com.griefcraft.model.LWCPlayer;
import com.griefcraft.model.Protection;
import com.griefcraft.modules.admin.AdminCache;
import com.griefcraft.modules.admin.AdminCleanup;
import com.griefcraft.modules.admin.AdminClear;
import com.griefcraft.modules.admin.AdminConfig;
import com.griefcraft.modules.admin.AdminConvert;
import com.griefcraft.modules.admin.AdminDebug;
import com.griefcraft.modules.admin.AdminExpire;
import com.griefcraft.modules.admin.AdminFind;
import com.griefcraft.modules.admin.AdminFlush;
import com.griefcraft.modules.admin.AdminForceOwner;
import com.griefcraft.modules.admin.AdminLocale;
import com.griefcraft.modules.admin.AdminPurge;
import com.griefcraft.modules.admin.AdminPurgeBanned;
import com.griefcraft.modules.admin.AdminQuery;
import com.griefcraft.modules.admin.AdminReload;
import com.griefcraft.modules.admin.AdminRemove;
import com.griefcraft.modules.admin.AdminReport;
import com.griefcraft.modules.admin.AdminUpdate;
import com.griefcraft.modules.admin.AdminVersion;
import com.griefcraft.modules.admin.AdminView;
import com.griefcraft.modules.admin.BaseAdminModule;
import com.griefcraft.modules.create.CreateModule;
import com.griefcraft.modules.credits.CreditsModule;
import com.griefcraft.modules.debug.DebugModule;
import com.griefcraft.modules.destroy.DestroyModule;
import com.griefcraft.modules.doors.DoorsModule;
import com.griefcraft.modules.flag.BaseFlagModule;
import com.griefcraft.modules.flag.MagnetModule;
import com.griefcraft.modules.free.FreeModule;
import com.griefcraft.modules.info.InfoModule;
import com.griefcraft.modules.limits.LimitsModule;
import com.griefcraft.modules.lists.ListsModule;
import com.griefcraft.modules.menu.MenuModule;
import com.griefcraft.modules.modes.BaseModeModule;
import com.griefcraft.modules.modes.DropTransferModule;
import com.griefcraft.modules.modes.NoSpamModule;
import com.griefcraft.modules.modes.PersistModule;
import com.griefcraft.modules.modify.ModifyModule;
import com.griefcraft.modules.owners.OwnersModule;
import com.griefcraft.modules.redstone.RedstoneModule;
import com.griefcraft.modules.unlock.UnlockModule;
import com.griefcraft.modules.worldguard.WorldGuardModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.ModuleLoader;
import com.griefcraft.scripting.event.LWCSendLocaleEvent;
import com.griefcraft.sql.Database;
import com.griefcraft.sql.MemDB;
import com.griefcraft.sql.PhysDB;
import com.griefcraft.util.Colors;
import com.griefcraft.util.Performance;
import com.griefcraft.util.StringUtils;
import com.griefcraft.util.UpdateThread;
import com.griefcraft.util.config.Configuration;
import java.security.MessageDigest;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.ContainerBlock;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.command.ColouredConsoleSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class LWC {
    private static LWC instance;
    public static boolean ENABLED;
    private Configuration configuration;
    private ModuleLoader moduleLoader;
    private Logger logger = Logger.getLogger("LWC");
    private CacheSet caches;
    private MemDB memoryDatabase;
    private PhysDB physicalDatabase;
    private LWCPlugin plugin;
    private UpdateThread updateThread;
    private ColouredConsoleSender console;
    private IPermissions permissions;
    private ICurrency currency;
    private boolean bug656workaround;

    public LWC(LWCPlugin plugin) {
        this.plugin = plugin;
        if (instance == null) {
            instance = this;
        }
        this.configuration = Configuration.load("core.yml");
        this.moduleLoader = new ModuleLoader();
        this.caches = new CacheSet();
        this.bug656workaround = this.configuration.getBoolean("core.bukkitBug656workaround", false);
        try {
            this.console = new ColouredConsoleSender((CraftServer)Bukkit.getServer());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LWCPlayer wrapPlayer(Player player) {
        return new LWCPlayer(this, player);
    }

    public boolean isBug656WorkAround() {
        return this.bug656workaround;
    }

    public static LWC getInstance() {
        return instance;
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public CacheSet getCaches() {
        return this.caches;
    }

    public void removeModes(Player player) {
        if (this.notInPersistentMode(player.getName())) {
            this.memoryDatabase.unregisterAllActions(player.getName());
        }
    }

    public Map<Integer, ItemStack> depositItems(Block block, ItemStack itemStack) {
        BlockState blockState = block.getState();
        if (blockState != null && blockState instanceof ContainerBlock) {
            Block doubleChestBlock = this.findAdjacentBlock(block, Material.CHEST, new Block[0]);
            ContainerBlock containerBlock = (ContainerBlock)blockState;
            HashMap remaining = containerBlock.getInventory().addItem(new ItemStack[]{itemStack});
            if (remaining.size() > 0) {
                int key = (Integer)remaining.keySet().iterator().next();
                ItemStack remainingItemStack = (ItemStack)remaining.get(key);
                if (doubleChestBlock != null) {
                    ContainerBlock containerBlock2 = (ContainerBlock)doubleChestBlock.getState();
                    remaining = containerBlock2.getInventory().addItem(new ItemStack[]{remainingItemStack});
                }
                if (remaining.size() > 0) {
                    return remaining;
                }
            }
        }
        return new HashMap<Integer, ItemStack>();
    }

    public boolean canAccessProtection(Player player, Block block) {
        Protection protection = this.findProtection(block);
        return protection != null && this.canAccessProtection(player, protection);
    }

    public boolean canAccessProtection(Player player, int x, int y, int z) {
        return this.canAccessProtection(player, this.physicalDatabase.loadProtection(player.getWorld().getName(), x, y, z));
    }

    public boolean canAccessProtection(Player player, Protection protection) {
        if (protection == null || player == null) {
            return true;
        }
        Module.Result canAccess = this.moduleLoader.dispatchEvent(ModuleLoader.Event.ACCESS_PROTECTION, player, protection);
        if (canAccess != Module.Result.DEFAULT) {
            return canAccess == Module.Result.ALLOW;
        }
        if (this.isAdmin(player)) {
            return true;
        }
        if (this.isMod(player)) {
            Player protectionOwner = this.plugin.getServer().getPlayer(protection.getOwner());
            if (protectionOwner == null) {
                return true;
            }
            if (!this.isAdmin(protectionOwner)) {
                return true;
            }
        }
        String playerName = player.getName();
        switch (protection.getType()) {
            case 0: {
                return true;
            }
            case 1: {
                return this.memoryDatabase.hasAccess(player.getName(), protection);
            }
            case 2: {
                if (playerName.equalsIgnoreCase(protection.getOwner())) {
                    return true;
                }
                if (protection.getAccess(1, playerName) >= 0) {
                    return true;
                }
                if (this.permissions.isActive()) {
                    for (String groupName : this.permissions.getGroups(player)) {
                        if (protection.getAccess(0, groupName) < 0) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean canAdminProtection(Player player, Block block) {
        Protection protection = this.findProtection(block);
        return protection != null && this.canAdminProtection(player, protection);
    }

    public boolean canAdminProtection(Player player, Protection protection) {
        if (protection == null || player == null) {
            return true;
        }
        Module.Result canAdmin = this.moduleLoader.dispatchEvent(ModuleLoader.Event.ADMIN_PROTECTION, player, protection);
        if (canAdmin != Module.Result.DEFAULT) {
            return canAdmin == Module.Result.ALLOW;
        }
        if (this.isAdmin(player)) {
            return true;
        }
        String playerName = player.getName();
        switch (protection.getType()) {
            case 0: {
                return player.getName().equalsIgnoreCase(protection.getOwner());
            }
            case 1: {
                return player.getName().equalsIgnoreCase(protection.getOwner()) && this.memoryDatabase.hasAccess(player.getName(), protection);
            }
            case 2: {
                if (playerName.equalsIgnoreCase(protection.getOwner())) {
                    return true;
                }
                if (protection.getAccess(1, playerName) == 1) {
                    return true;
                }
                if (this.permissions.isActive()) {
                    for (String groupName : this.permissions.getGroups(player)) {
                        if (protection.getAccess(0, groupName) != 1) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public void destruct() {
        this.moduleLoader.shutdown();
        this.moduleLoader = null;
        this.log("Flushing final updates (" + this.updateThread.size() + ")");
        if (this.updateThread != null) {
            this.updateThread.stop();
            this.updateThread = null;
        }
        this.log("Freeing " + (Object)((Object)Database.DefaultType));
        if (this.physicalDatabase != null) {
            this.physicalDatabase.dispose();
        }
        if (this.memoryDatabase != null) {
            this.memoryDatabase.dispose();
        }
        this.physicalDatabase = null;
        this.memoryDatabase = null;
    }

    public String encrypt(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(text.getBytes("UTF-8"));
            byte[] raw = md.digest();
            return this.byteArray2Hex(raw);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean enforceAccess(Player player, Block block) {
        if (block == null) {
            return true;
        }
        Protection protection = this.findProtection(block);
        boolean hasAccess = this.canAccessProtection(player, protection);
        if (protection == null) {
            return true;
        }
        if (protection.getBlockId() == 0) {
            protection.setBlockId(block.getTypeId());
            protection.save();
        }
        if (protection.getWorld() == null || protection.getWorld().isEmpty()) {
            protection.setWorld(block.getWorld().getName());
            protection.save();
        }
        if (hasAccess) {
            long timestamp = System.currentTimeMillis() / 1000L;
            protection.setLastAccessed(timestamp);
            protection.save();
        }
        if (this.configuration.getBoolean("core.showNotices", true)) {
            boolean isOwner = protection.isOwner(player);
            boolean showMyNotices = this.configuration.getBoolean("core.showMyNotices", true);
            if (this.isAdmin(player) || this.isMod(player) || isOwner && showMyNotices) {
                String owner = protection.getOwner();
                if (owner.equals(player.getName())) {
                    owner = this.getLocale("you", new Object[0]);
                }
                String blockName = LWC.materialToString(block);
                if (!this.getLocale("protection." + blockName.toLowerCase() + ".notice.protected", new Object[0]).startsWith("UNKNOWN_LOCALE")) {
                    this.sendLocale((CommandSender)player, "protection." + blockName.toLowerCase() + ".notice.protected", "type", this.getLocale(protection.typeToString().toLowerCase(), new Object[0]), "block", blockName, "owner", owner);
                } else {
                    this.sendLocale((CommandSender)player, "protection.general.notice.protected", "type", this.getLocale(protection.typeToString().toLowerCase(), new Object[0]), "block", blockName, "owner", owner);
                }
            }
        }
        switch (protection.getType()) {
            case 1: {
                if (hasAccess) break;
                this.getMemoryDatabase().unregisterUnlock(player.getName());
                this.getMemoryDatabase().registerUnlock(player.getName(), protection.getId());
                this.sendLocale((CommandSender)player, "protection.general.locked.password", "block", LWC.materialToString(block));
                break;
            }
            case 2: {
                if (hasAccess) break;
                this.sendLocale((CommandSender)player, "protection.general.locked.private", "block", LWC.materialToString(block));
                break;
            }
            case 3: {
                if (hasAccess) break;
                player.kickPlayer(protection.getData());
                this.log(player.getName() + " triggered the kick trap: " + protection.toString());
                break;
            }
            case 4: {
                if (hasAccess) break;
                Plugin mcbansPlugin = this.plugin.getServer().getPluginManager().getPlugin("MCBans");
                if (mcbansPlugin != null) {
                    mcbans mcbans2 = (mcbans)mcbansPlugin;
                    mcbans2.mcb_handler.ban(player.getName(), "LWC", protection.getData(), "");
                }
                this.log(player.getName() + " triggered the ban trap: " + protection.toString());
            }
        }
        return hasAccess;
    }

    public Block findAdjacentBlock(Block block, Material material, Block ... ignore) {
        BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
        List<Block> ignoreList = Arrays.asList(ignore);
        for (BlockFace face : faces) {
            Block adjacentBlock = block.getRelative(face);
            if (adjacentBlock.getType() != material || ignoreList.contains(adjacentBlock)) continue;
            return adjacentBlock;
        }
        return null;
    }

    public Block findAdjacentDoubleChest(Block block) {
        Block lastBlock = null;
        ArrayList<Block> attempts = new ArrayList<Block>(5);
        attempts.add(block);
        int found = 0;
        for (int attempt = 0; attempt < 4; ++attempt) {
            Block[] attemptsArray = attempts.toArray(new Block[attempts.size()]);
            Block adjacentBlock = this.findAdjacentBlock(block, Material.CHEST, attemptsArray);
            if (adjacentBlock == null) continue;
            if (this.findAdjacentBlock(adjacentBlock, Material.CHEST, block) != null) {
                return adjacentBlock;
            }
            ++found;
            lastBlock = adjacentBlock;
            attempts.add(adjacentBlock);
        }
        if (found > 1) {
            return lastBlock;
        }
        return null;
    }

    public Protection findProtection(Block block) {
        return this.findProtection(block.getWorld(), block.getX(), block.getY(), block.getZ());
    }

    public Protection findProtection(World world, int x, int y, int z) {
        if (world == null) {
            return null;
        }
        Block block = world.getBlockAt(x, y, z);
        if (block == null) {
            return null;
        }
        List<Block> protections = this.getProtectionSet(world, x, y, z);
        for (Block protectableBlock : protections) {
            Protection protection = this.physicalDatabase.loadProtection(world.getName(), protectableBlock.getX(), protectableBlock.getY(), protectableBlock.getZ());
            if (protection == null) continue;
            if (this.bug656workaround && (protectableBlock.getX() != x || protectableBlock.getY() != y || protectableBlock.getZ() != z) && this.physicalDatabase.getCachedProtection(world.getName(), x, y, z) == null) {
                this.physicalDatabase.addCachedProtection(world.getName(), x, y, z, protection);
            }
            return protection;
        }
        return null;
    }

    public String getLocale(String key, Object ... args) {
        key = key.replaceAll(" ", "_");
        if (!this.plugin.getLocale().containsKey(key)) {
            return "UNKNOWN_LOCALE_" + key;
        }
        Map<String, Object> bind = this.parseBinds(args);
        String value = this.plugin.getLocale().getString(key);
        for (String colorKey : Colors.localeColors.keySet()) {
            String color = Colors.localeColors.get(colorKey);
            if (!value.contains(colorKey)) continue;
            value = value.replaceAll(colorKey, color);
        }
        for (String bindKey : bind.keySet()) {
            Object object = bind.get(bindKey);
            value = value.replaceAll("%" + bindKey + "%", object.toString());
        }
        return value;
    }

    public MemDB getMemoryDatabase() {
        return this.memoryDatabase;
    }

    public IPermissions getPermissions() {
        return this.permissions;
    }

    public ICurrency getCurrency() {
        return this.currency;
    }

    public PhysDB getPhysicalDatabase() {
        return this.physicalDatabase;
    }

    public LWCPlugin getPlugin() {
        return this.plugin;
    }

    public List<Block> getProtectionSet(World world, int x, int y, int z) {
        List<Block> entities = new ArrayList<Block>(3);
        if (world == null) {
            return entities;
        }
        Block baseBlock = world.getBlockAt(x, y, z);
        entities = this._validateBlock(entities, baseBlock, true);
        if (this.bug656workaround && entities.size() == 0) {
            entities.add(baseBlock);
        }
        int dev = -1;
        boolean isXDir = true;
        while (true) {
            Block block = world.getBlockAt(x + (isXDir ? dev : 0), y, z + (isXDir ? 0 : dev));
            entities = this._validateBlock(entities, block);
            if (dev == 1) {
                if (!isXDir) break;
                isXDir = false;
                dev = -1;
                continue;
            }
            dev = 1;
        }
        if (entities.isEmpty()) {
            this.findCachedProtection(entities, baseBlock);
        }
        return entities;
    }

    public UpdateThread getUpdateThread() {
        return this.updateThread;
    }

    public double getVersion() {
        return Double.parseDouble(this.plugin.getDescription().getVersion());
    }

    public boolean isAdmin(CommandSender sender) {
        return !(sender instanceof Player) || this.isAdmin((Player)sender);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean hasAdminPermission(CommandSender sender, String node) {
        return this.isAdmin(sender) || this.permissions.isActive() && this.hasPermission(sender, node, "lwc.admin");
    }

    public boolean hasPlayerPermission(CommandSender sender, String node) {
        return !this.permissions.isActive() || this.hasPermission(sender, node, "lwc.protect");
    }

    public boolean hasPermission(CommandSender sender, String node, String ... fallback) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        boolean hasNode = this.hasPermission(player, node);
        if (!hasNode) {
            for (String temp : fallback) {
                if (!this.hasPermission(player, temp)) continue;
                return true;
            }
        }
        return hasNode;
    }

    public boolean hasPermission(Player player, String node) {
        if (!this.permissions.isActive()) {
            return !node.contains("admin") && !node.contains("mod");
        }
        return this.permissions.permission(player, node);
    }

    public boolean isAdmin(Player player) {
        if (player.isOp() && this.configuration.getBoolean("core.opIsLWCAdmin", true)) {
            return true;
        }
        return this.permissions.isActive() && this.hasPermission(player, "lwc.admin");
    }

    public boolean isMod(Player player) {
        return this.permissions.isActive() && this.hasPermission(player, "lwc.mod");
    }

    public boolean isModeEnabled(String mode) {
        return this.configuration.getBoolean("modes." + mode + ".enabled", true);
    }

    public boolean isModeWhitelisted(Player player, String mode) {
        return this.permissions.isActive() && this.hasPermission((CommandSender)player, "lwc.mode." + mode, "lwc.allmodes");
    }

    public boolean isProtectable(Block block) {
        return this.isProtectable(block.getType());
    }

    public boolean isProtectable(Material material) {
        return Boolean.parseBoolean(this.resolveProtectionConfiguration(material, "enabled"));
    }

    public void load() {
        this.configuration = Configuration.load("core.yml");
        this.registerCoreModules();
        new ConfigPost300().run();
        this.plugin.loadDatabase();
        Performance.init();
        this.physicalDatabase = new PhysDB();
        this.memoryDatabase = new MemDB();
        this.updateThread = new UpdateThread(this);
        this.permissions = new NoPermissions();
        if (this.resolvePlugin("PermissionsBukkit") != null) {
            this.permissions = new BukkitPermissions();
        } else if (this.resolvePlugin("PermissionsEx") != null) {
            this.permissions = new PEXPermissions();
        } else if (this.resolvePlugin("Permissions") != null) {
            this.permissions = new NijiPermissions();
        }
        this.currency = new NoCurrency();
        if (this.resolvePlugin("iConomy") != null) {
            Plugin plugin = this.resolvePlugin("iConomy");
            String className = plugin.getClass().getName();
            this.currency = className.startsWith("com.iConomy") ? new iConomy5Currency() : new iConomy6Currency();
        } else if (this.resolvePlugin("BOSEconomy") != null) {
            this.currency = new BOSECurrency();
        } else if (this.resolvePlugin("Essentials") != null) {
            this.currency = new EssentialsCurrency();
        }
        this.log("Permissions API: \u00a74" + this.permissions.getClass().getSimpleName());
        this.log("Currency API: \u00a74" + this.currency.getClass().getSimpleName());
        this.log("Loading " + (Object)((Object)Database.DefaultType));
        try {
            this.physicalDatabase.connect();
            this.memoryDatabase.connect();
            this.physicalDatabase.load();
            this.memoryDatabase.load();
            this.log("Using: " + StringUtils.capitalizeFirstLetter(this.physicalDatabase.getConnection().getMetaData().getDriverVersion()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new MySQLPost200().run();
        this.physicalDatabase.precache();
        this.moduleLoader.loadAll();
    }

    private void registerCoreModules() {
        this.registerModule(new LimitsModule());
        this.registerModule(new CreateModule());
        this.registerModule(new ModifyModule());
        this.registerModule(new DestroyModule());
        this.registerModule(new FreeModule());
        this.registerModule(new InfoModule());
        this.registerModule(new MenuModule());
        this.registerModule(new UnlockModule());
        this.registerModule(new OwnersModule());
        this.registerModule(new DoorsModule());
        this.registerModule(new DebugModule());
        this.registerModule(new CreditsModule());
        this.registerModule(new BaseAdminModule());
        this.registerModule(new AdminCache());
        this.registerModule(new AdminCleanup());
        this.registerModule(new AdminClear());
        this.registerModule(new AdminConfig());
        this.registerModule(new AdminConvert());
        this.registerModule(new AdminDebug());
        this.registerModule(new AdminFind());
        this.registerModule(new AdminFlush());
        this.registerModule(new AdminForceOwner());
        this.registerModule(new AdminLocale());
        this.registerModule(new AdminPurge());
        this.registerModule(new AdminReload());
        this.registerModule(new AdminRemove());
        this.registerModule(new AdminReport());
        this.registerModule(new AdminUpdate());
        this.registerModule(new AdminVersion());
        this.registerModule(new AdminView());
        this.registerModule(new AdminQuery());
        this.registerModule(new AdminPurgeBanned());
        this.registerModule(new AdminExpire());
        this.registerModule(new BaseFlagModule());
        this.registerModule(new RedstoneModule());
        this.registerModule(new MagnetModule());
        this.registerModule(new BaseModeModule());
        this.registerModule(new PersistModule());
        this.registerModule(new DropTransferModule());
        this.registerModule(new NoSpamModule());
        this.registerModule(new ListsModule());
        this.registerModule(new WorldGuardModule());
    }

    private void registerModule(Module module) {
        this.moduleLoader.registerModule((Plugin)this.plugin, module);
    }

    private Plugin resolvePlugin(String name) {
        Plugin temp = this.plugin.getServer().getPluginManager().getPlugin(name);
        if (temp == null) {
            return null;
        }
        return temp;
    }

    public ItemStack[] mergeInventories(List<Block> blocks) {
        ItemStack[] stacks = new ItemStack[54];
        int index = 0;
        try {
            for (Block block : blocks) {
                if (!(block.getState() instanceof ContainerBlock)) continue;
                ContainerBlock containerBlock = (ContainerBlock)block.getState();
                Inventory inventory = containerBlock.getInventory();
                ItemStack[] arr$ = inventory.getContents();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    ItemStack stack;
                    stacks[index] = stack = arr$[i$];
                    ++index;
                }
            }
        }
        catch (Exception e) {
            return this.mergeInventories(blocks);
        }
        return stacks;
    }

    public boolean notInPersistentMode(String player) {
        return !this.memoryDatabase.hasMode(player, "persist");
    }

    public void sendFullHelp(CommandSender sender) {
        boolean isPlayer = sender instanceof Player;
        String menuStyle = "advanced";
        if (isPlayer) {
            menuStyle = this.physicalDatabase.getMenuStyle(((Player)sender).getName()).toLowerCase();
        }
        if (menuStyle.equals("advanced")) {
            this.sendLocale(sender, "help.advanced", new Object[0]);
        } else {
            this.sendLocale(sender, "help.basic", new Object[0]);
        }
        if (this.isAdmin(sender)) {
            sender.sendMessage("");
            sender.sendMessage("\u00a74/lwc admin - Administration");
        }
    }

    public void sendLocale(CommandSender sender, String key, Object ... args) {
        String[] aliasvars;
        String message = this.getLocale(key, args);
        String menuStyle = null;
        if (sender instanceof Player) {
            Module.Result result = this.moduleLoader.dispatchEvent(ModuleLoader.Event.SEND_LOCALE, sender, key);
            LWCSendLocaleEvent evt = new LWCSendLocaleEvent((Player)sender, key);
            this.moduleLoader.dispatchEvent(evt);
            if (result == Module.Result.CANCEL || evt.isCancelled()) {
                return;
            }
        }
        if (message == null) {
            sender.sendMessage("\u00a74LWC: \u00a7fUndefined locale: \"\u00a78" + key + "\u00a7f" + "\"");
            return;
        }
        for (String alias : aliasvars = new String[]{"cprivate", "cpublic", "cpassword", "cmodify", "cunlock", "cinfo", "cremove"}) {
            String replace = "%" + alias + "%";
            if (!message.contains(replace)) continue;
            if (menuStyle == null) {
                menuStyle = sender instanceof Player ? this.physicalDatabase.getMenuStyle(((Player)sender).getName()) : "advanced";
            }
            String localeName = alias + "." + menuStyle;
            message = message.replace(replace, this.getLocale(localeName, new Object[0]));
        }
        for (String line : message.split("\\n")) {
            if (line.isEmpty()) {
                line = " ";
            }
            sender.sendMessage(line);
        }
    }

    public void sendSimpleUsage(CommandSender player, String command) {
        this.sendLocale(player, "help.simpleusage", "command", command);
    }

    private List<Block> _validateBlock(List<Block> entities, Block block) {
        return this._validateBlock(entities, block, false);
    }

    private boolean findCachedProtection(List<Block> entities, Block block) {
        boolean foundProtection = false;
        if (this.physicalDatabase.getCachedProtection(block.getWorld().getName(), block.getX(), block.getY(), block.getZ()) != null) {
            if (!entities.contains(block)) {
                entities.add(block);
            }
            foundProtection = true;
        }
        return foundProtection;
    }

    public List<Block> getRelatedBlocks(World world, int x, int y, int z) {
        Block block = world.getBlockAt(x, y, z);
        List<Block> entities = this.getProtectionSet(world, x, y, z);
        switch (block.getTypeId()) {
            case 64: 
            case 71: {
                Block down = block.getRelative(BlockFace.DOWN);
                if (down.getTypeId() == 64 || down.getTypeId() == 71) {
                    down = down.getRelative(BlockFace.DOWN);
                }
                if (entities.contains(down)) break;
                entities.add(down);
            }
        }
        return entities;
    }

    private boolean isDestroyedByGravity(Block block) {
        switch (block.getType()) {
            case SIGN_POST: 
            case RAILS: 
            case POWERED_RAIL: 
            case DETECTOR_RAIL: {
                return true;
            }
        }
        return false;
    }

    private List<Block> _validateBlock(List<Block> entities, Block block, boolean isBaseBlock) {
        if (block == null) {
            return entities;
        }
        if (entities.size() > 2) {
            return entities;
        }
        Material type = block.getType();
        Block up = block.getRelative(BlockFace.UP);
        if (entities.size() == 1) {
            Block other = entities.get(0);
            switch (other.getTypeId()) {
                case 61: 
                case 62: {
                    return entities;
                }
                case 23: {
                    return entities;
                }
                case 63: 
                case 68: {
                    return entities;
                }
                case 54: {
                    if (type == Material.CHEST) break;
                    return entities;
                }
                case 64: {
                    if (type == Material.WOODEN_DOOR) break;
                    return entities;
                }
                case 71: {
                    if (type == Material.IRON_DOOR_BLOCK) break;
                    return entities;
                }
            }
            if (!entities.contains(block)) {
                entities.add(block);
            }
        } else if (this.isProtectable(block) && isBaseBlock && !this.isComplexBlock(block)) {
            entities.add(block);
        } else if (isBaseBlock && (up.getType() == Material.WOODEN_DOOR || up.getType() == Material.IRON_DOOR_BLOCK || type == Material.WOODEN_DOOR || type == Material.IRON_DOOR_BLOCK)) {
            if (type != Material.WOODEN_DOOR && type != Material.IRON_DOOR_BLOCK) {
                entities.clear();
                entities.add(block);
                entities.add(block.getRelative(BlockFace.UP));
                entities.add(block.getWorld().getBlockAt(block.getX(), block.getY() + 2, block.getZ()));
            } else {
                entities.clear();
                if (up.getType() == Material.WOODEN_DOOR || up.getType() == Material.IRON_DOOR_BLOCK) {
                    entities.add(block);
                    entities.add(up);
                } else {
                    entities.add(block.getRelative(BlockFace.DOWN));
                    entities.add(block);
                }
            }
        } else if (isBaseBlock && (this.isDestroyedByGravity(block) || this.isDestroyedByGravity(up))) {
            if (entities.size() == 0) {
                if (this.isProtectable(block)) {
                    entities.add(block);
                } else {
                    entities.add(up);
                }
            }
        } else {
            if (isBaseBlock && (type == Material.FURNACE || type == Material.DISPENSER || type == Material.JUKEBOX)) {
                if (entities.size() == 0) {
                    entities.add(block);
                }
                return entities;
            }
            if (isBaseBlock && !this.isProtectable(block)) {
                BlockFace[] faces;
                block20: for (BlockFace blockFace : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
                    Block face = block.getRelative(blockFace);
                    if (face == null) continue;
                    byte direction = face.getData();
                    if (face.getType() == Material.WALL_SIGN) {
                        switch (direction) {
                            case 2: {
                                if (blockFace != BlockFace.EAST) break;
                                entities.add(face);
                                break;
                            }
                            case 3: {
                                if (blockFace != BlockFace.WEST) break;
                                entities.add(face);
                                break;
                            }
                            case 4: {
                                if (blockFace != BlockFace.NORTH) break;
                                entities.add(face);
                                break;
                            }
                            case 5: {
                                if (blockFace != BlockFace.SOUTH) break;
                                entities.add(face);
                            }
                        }
                        continue;
                    }
                    if (face.getType() != Material.TRAP_DOOR) continue;
                    switch (direction) {
                        case 0: {
                            if (blockFace != BlockFace.EAST) continue block20;
                            entities.add(face);
                            continue block20;
                        }
                        case 1: {
                            if (blockFace != BlockFace.WEST) continue block20;
                            entities.add(face);
                            continue block20;
                        }
                        case 2: {
                            if (blockFace != BlockFace.NORTH) continue block20;
                            entities.add(face);
                            continue block20;
                        }
                        case 3: {
                            if (blockFace != BlockFace.SOUTH) continue block20;
                            entities.add(face);
                        }
                    }
                }
            }
        }
        return entities;
    }

    private String byteArray2Hex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    private boolean isComplexBlock(Block block) {
        switch (block.getTypeId()) {
            case 63: 
            case 64: 
            case 68: 
            case 71: {
                return true;
            }
        }
        return false;
    }

    private void log(String str) {
        str = "LWC: " + str;
        if (this.console != null) {
            this.console.sendMessage(str);
        } else {
            this.logger.info(ChatColor.stripColor((String)str));
        }
    }

    private Map<String, Object> parseBinds(Object ... args) {
        HashMap<String, Object> bind = new HashMap<String, Object>();
        if (args == null || args.length < 2) {
            return bind;
        }
        int size = args.length;
        for (int index = 0; index < args.length && index + 2 <= size; index += 2) {
            String key = args[index].toString();
            Object object = args[index + 1];
            bind.put(key, object);
        }
        return bind;
    }

    public static String materialToString(Block block) {
        return LWC.materialToString(block.getType());
    }

    public static String materialToString(int id) {
        return LWC.materialToString(Material.getMaterial((int)id));
    }

    private static String materialToString(Material material) {
        if (material != null) {
            String materialName = LWC.normalizeName(material);
            String locale = LWC.getInstance().getLocale(materialName.toLowerCase(), new Object[0]);
            if (locale.startsWith("UNKNOWN_LOCALE_")) {
                locale = materialName;
            }
            return StringUtils.capitalizeFirstLetter(locale);
        }
        return "";
    }

    private static String normalizeName(Material material) {
        String name = material.toString().toLowerCase().replaceAll("block", "");
        if (name.contains("sign")) {
            name = "Sign";
        }
        if (name.contains("furnace")) {
            name = "furnace";
        }
        if (name.endsWith("_")) {
            name = name.substring(0, name.length() - 1);
        }
        return name.toLowerCase();
    }

    public String resolveProtectionConfiguration(Material material, String node) {
        ArrayList<String> names = new ArrayList<String>();
        String materialName = LWC.normalizeName(material);
        names.add(materialName);
        names.add(material.getId() + "");
        if (!materialName.equals(material.toString().toLowerCase())) {
            names.add(material.toString().toLowerCase());
        }
        String value = this.configuration.getString("protections." + node);
        for (String name : names) {
            String temp = this.configuration.getString("protections.blocks." + name + "." + node);
            if (temp == null || temp.isEmpty()) continue;
            value = temp;
        }
        return value;
    }

    public boolean isHistoryEnabled() {
        return !this.configuration.getBoolean("core.disableHistory", false);
    }

    public int fastRemoveProtections(CommandSender sender, String where, boolean shouldRemoveBlocks) {
        LinkedList<Integer> toRemove = new LinkedList<Integer>();
        LinkedList<Block> removeBlocks = null;
        int totalProtections = this.physicalDatabase.getProtectionCount();
        int completed = 0;
        int count = 0;
        this.updateThread.flush();
        if (shouldRemoveBlocks) {
            removeBlocks = new LinkedList<Block>();
        }
        if (where != null || !where.trim().isEmpty()) {
            where = " WHERE " + where.trim();
        }
        sender.sendMessage("Loading protections via STREAM mode");
        try {
            Statement resultStatement = this.physicalDatabase.getConnection().createStatement(1003, 1007);
            if (this.physicalDatabase.getType() == Database.Type.MySQL) {
                resultStatement.setFetchSize(Integer.MIN_VALUE);
            }
            String prefix = this.physicalDatabase.getPrefix();
            ResultSet result = resultStatement.executeQuery("SELECT " + prefix + "protections.id AS protectionId, " + prefix + "protections.type AS protectionType, x, y, z, flags, blockId, world, owner, password, date, last_accessed FROM " + prefix + "protections" + where);
            while (result.next()) {
                Protection protection = this.physicalDatabase.resolveProtectionNoRights(result);
                World world = protection.getBukkitWorld();
                if (protection.hasFlag(Protection.Flag.EXEMPTION)) continue;
                if (++count % 100000 == 0 || count == totalProtections || count == 1) {
                    sender.sendMessage("\u00a74" + count + " / " + totalProtections);
                }
                if (world == null) continue;
                toRemove.add(protection.getId());
                if (shouldRemoveBlocks) {
                    removeBlocks.add(protection.getBlock());
                }
                ++completed;
            }
            result.close();
            resultStatement.close();
            this.fullRemoveProtections(sender, toRemove);
            if (shouldRemoveBlocks) {
                this.removeBlocks(sender, removeBlocks);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return completed;
    }

    private void removeBlocks(CommandSender sender, List<Block> blocks) {
        int count = 0;
        for (Block block : blocks) {
            Block doubleChest;
            if (block == null || !this.isProtectable(block)) continue;
            if (block.getType() == Material.CHEST && (doubleChest = this.findAdjacentBlock(block, Material.CHEST, new Block[0])) != null) {
                this.removeInventory(doubleChest);
                doubleChest.setType(Material.AIR);
            }
            this.removeInventory(block);
            block.setType(Material.AIR);
            ++count;
        }
        sender.sendMessage("Removed " + count + " blocks from the world");
    }

    private void removeInventory(Block block) {
        if (block == null) {
            return;
        }
        if (!(block.getState() instanceof ContainerBlock)) {
            return;
        }
        ContainerBlock container = (ContainerBlock)block.getState();
        container.getInventory().clear();
    }

    private void fullRemoveProtections(CommandSender sender, List<Integer> toRemove) throws SQLException {
        StringBuilder builder = new StringBuilder();
        int total = toRemove.size();
        int count = 0;
        Iterator<Integer> iter = toRemove.iterator();
        String prefix = this.getPhysicalDatabase().getPrefix();
        Statement statement = this.getPhysicalDatabase().getConnection().createStatement();
        while (iter.hasNext()) {
            int protectionId = iter.next();
            if (count % 100000 == 0) {
                builder.append("DELETE FROM " + prefix + "protections WHERE id IN (" + protectionId);
            } else {
                builder.append("," + protectionId);
            }
            if (count % 100000 == 99999 || count == total - 1) {
                builder.append(")");
                statement.executeUpdate(builder.toString());
                builder.setLength(0);
                sender.sendMessage("\u00a72REMOVED " + (count + 1) + " / " + total);
            }
            ++count;
        }
        statement.close();
    }

    static {
        ENABLED = false;
    }
}

