/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.debug;

import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCInfo;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCCommandEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DebugModule
extends JavaModule {
    private String yes = null;
    private String no = null;

    @Override
    public void load(LWC lwc) {
        this.yes = lwc.getLocale("yes", new Object[0]);
        this.no = lwc.getLocale("no", new Object[0]);
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("debug")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        event.setCancelled(true);
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command is only usable by real players :-)");
            return;
        }
        Player player = (Player)sender;
        player.sendMessage(" ");
        player.sendMessage("\u00a78LWC: " + LWCInfo.FULL_VERSION);
        player.sendMessage(" ");
        player.sendMessage("\u00a72Standard LWC permissions");
        this.doPermission(player, "lwc.protect");
        this.doPlayerPermission(player, "lwc.create.public");
        this.doPlayerPermission(player, "lwc.create.password");
        this.doPlayerPermission(player, "lwc.create.private");
        this.doPlayerPermission(player, "lwc.info");
        this.doPlayerPermission(player, "lwc.remove");
        this.doPlayerPermission(player, "lwc.modify");
        this.doPlayerPermission(player, "lwc.unlock");
        for (Protection.Flag flag : Protection.Flag.values()) {
            this.doPlayerPermission(player, "lwc.flag." + flag.toString().toLowerCase());
        }
        player.sendMessage(" ");
        player.sendMessage("\u00a7eMod permissions");
        this.doPermission(player, "lwc.mod");
        player.sendMessage(" ");
        player.sendMessage("\u00a74Admin permissions");
        this.doPermission(player, "lwc.admin");
    }

    private void doPermission(Player player, String node) {
        player.sendMessage(node + ": " + this.strval(LWC.getInstance().hasPermission(player, node)));
    }

    private void doPlayerPermission(Player player, String node) {
        player.sendMessage(node + ": " + this.strval(LWC.getInstance().hasPlayerPermission((CommandSender)player, node)));
    }

    private void doAdminPermission(Player player, String node) {
        player.sendMessage(node + ": " + this.strval(LWC.getInstance().hasAdminPermission((CommandSender)player, node)));
    }

    private String strval(boolean bool) {
        return bool ? this.yes : this.no;
    }
}

