/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.flag;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Action;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.util.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BaseFlagModule
extends JavaModule {
    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        if (!event.hasAction("flag")) {
            return;
        }
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        Player player = event.getPlayer();
        Action action = lwc.getMemoryDatabase().getAction("flag", player.getName());
        String data = action.getData();
        event.setResult(Module.Result.CANCEL);
        if (!event.canAdmin()) {
            lwc.sendLocale((CommandSender)player, "protection.accessdenied", new Object[0]);
            return;
        }
        boolean shouldAdd = data.substring(0, 1).equals("+");
        String flagName = data.substring(1);
        Protection.Flag flag = null;
        for (Protection.Flag tmp : Protection.Flag.values()) {
            if (!tmp.toString().equalsIgnoreCase(flagName)) continue;
            flag = tmp;
            break;
        }
        if (flag == null) {
            lwc.sendLocale((CommandSender)player, "protection.internalerror", "id", "flg");
            return;
        }
        if (shouldAdd) {
            protection.addFlag(flag);
            lwc.sendLocale((CommandSender)player, "protection.interact.flag.add", "flag", StringUtils.capitalizeFirstLetter(flagName));
        } else {
            protection.removeFlag(flag);
            lwc.sendLocale((CommandSender)player, "protection.interact.flag.remove", "flag", StringUtils.capitalizeFirstLetter(flagName));
        }
        protection.save();
        lwc.removeModes(player);
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        String internalType;
        if (!event.hasFlag("f", "flag")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        event.setCancelled(true);
        if (args.length < 2) {
            lwc.sendSimpleUsage(sender, "/lwc flag <flag> <on/off>");
            boolean denyRedstone = lwc.getConfiguration().getBoolean("protections.denyRedstone", false);
            String redstone = denyRedstone ? lwc.getLocale("help.flags.redstone.allow", new Object[0]) : lwc.getLocale("help.flags.redstone.deny", new Object[0]);
            lwc.sendLocale(sender, "help.flags", "redstone", redstone);
            return;
        }
        Player player = (Player)sender;
        String flagName = args[0];
        String type = args[1].toLowerCase();
        if (!lwc.hasPermission(sender, "lwc.flag." + flagName, "lwc.protect", "lwc.allflags")) {
            lwc.sendLocale(sender, "protection.accessdenied", new Object[0]);
            return;
        }
        Protection.Flag match = null;
        for (Protection.Flag flag : Protection.Flag.values()) {
            if (!flag.toString().equalsIgnoreCase(flagName) && !flag.toString().toLowerCase().startsWith(flagName.toLowerCase())) continue;
            match = flag;
            flagName = flag.toString();
            break;
        }
        if (match == null) {
            lwc.sendLocale(sender, "protection.flag.invalidflag", "flag", flagName);
            return;
        }
        if (match.isRestricted() && !lwc.isAdmin(player)) {
            lwc.sendLocale((CommandSender)player, "protection.accessdenied", new Object[0]);
            return;
        }
        if (type.equals("on") || type.equals("true") || type.equals("yes")) {
            internalType = "+";
        } else if (type.equals("off") || type.equals("false") || type.equals("no")) {
            internalType = "-";
        } else {
            lwc.sendLocale(sender, "protection.flag.invalidtype", "type", type);
            return;
        }
        lwc.getMemoryDatabase().unregisterAllActions(player.getName());
        lwc.getMemoryDatabase().registerAction("flag", player.getName(), internalType + flagName);
        lwc.sendLocale(sender, "protection.flag.finalize", new Object[0]);
    }
}

