/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.flag;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.util.config.Configuration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.ContainerBlock;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MagnetModule
extends JavaModule {
    private Configuration configuration = Configuration.load("magnet.yml");
    private boolean enabled = false;
    private List<Integer> itemBlacklist;
    private int radius;
    private int perSweep;
    private List<Entity> entities = null;
    private int taskId;

    @Override
    public void load(LWC lwc) {
        this.enabled = this.configuration.getBoolean("magnet.enabled", false);
        this.itemBlacklist = new ArrayList<Integer>();
        this.radius = this.configuration.getInt("magnet.radius", 3);
        this.perSweep = this.configuration.getInt("magnet.perSweep", 20);
        if (!this.enabled) {
            return;
        }
        List<String> temp = this.configuration.getStringList("magnet.blacklist", new ArrayList<String>());
        for (String item : temp) {
            Material material = Material.matchMaterial((String)item);
            if (material == null) continue;
            this.itemBlacklist.add(material.getId());
        }
        MagnetTask searchThread = new MagnetTask();
        this.taskId = lwc.getPlugin().getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)lwc.getPlugin(), (Runnable)searchThread, 50L, 50L);
    }

    private class MagnetTask
    implements Runnable {
        private MagnetTask() {
        }

        @Override
        public void run() {
            Server server = Bukkit.getServer();
            LWC lwc = LWC.getInstance();
            if (!LWC.ENABLED) {
                server.getScheduler().cancelTask(MagnetModule.this.taskId);
            }
            block0: for (World world : server.getWorlds()) {
                String worldName = world.getName();
                if (MagnetModule.this.entities == null || MagnetModule.this.entities.size() == 0) {
                    MagnetModule.this.entities = world.getEntities();
                }
                Iterator iterator = MagnetModule.this.entities.iterator();
                int count = 0;
                while (iterator.hasNext()) {
                    Entity entity = (Entity)iterator.next();
                    if (!(entity instanceof Item)) {
                        iterator.remove();
                        continue;
                    }
                    if (count > MagnetModule.this.perSweep) continue block0;
                    Item item = (Item)entity;
                    ItemStack itemStack = item.getItemStack();
                    if (MagnetModule.this.itemBlacklist.contains(itemStack.getTypeId())) {
                        iterator.remove();
                        continue;
                    }
                    Location location = item.getLocation();
                    int x = location.getBlockX();
                    int y = location.getBlockY();
                    int z = location.getBlockZ();
                    List<Protection> protections = lwc.getPhysicalDatabase().loadProtections(worldName, x, y, z, MagnetModule.this.radius);
                    for (Protection temp : protections) {
                        Protection protection = temp;
                        Block block = world.getBlockAt(protection.getX(), protection.getY(), protection.getZ());
                        if (!(block.getState() instanceof ContainerBlock) || !protection.hasFlag(Protection.Flag.MAGNET)) continue;
                        Map<Integer, ItemStack> remaining = lwc.depositItems(block, itemStack);
                        if (remaining.size() == 1) {
                            ItemStack other = remaining.values().iterator().next();
                            if (itemStack.getTypeId() == other.getTypeId() && itemStack.getAmount() == other.getAmount()) continue;
                        }
                        item.remove();
                        if (remaining.size() <= 0) break;
                        for (ItemStack stack : remaining.values()) {
                            world.dropItemNaturally(location, stack);
                        }
                    }
                    ++count;
                    iterator.remove();
                }
            }
        }
    }
}

