/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.limits;

import com.griefcraft.lwc.LWC;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.util.StringUtils;
import com.griefcraft.util.config.Configuration;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LimitsModule
extends JavaModule {
    private Configuration configuration = Configuration.load("limits.yml");
    private int UNLIMITED = Integer.MAX_VALUE;

    public void set(String path, Object value) {
        this.configuration.setProperty(path, value);
    }

    public boolean save() {
        return this.configuration.save();
    }

    public boolean hasReachedLimit(Player player, Block block) {
        int protections;
        LWC lwc = LWC.getInstance();
        int limit = this.mapProtectionLimit(player, block.getTypeId());
        if (limit == this.UNLIMITED) {
            return false;
        }
        Type type = Type.resolve(this.resolveValue(player, "type"));
        switch (type) {
            case CUSTOM: {
                protections = lwc.getPhysicalDatabase().getProtectionCount(player.getName(), block.getTypeId());
                break;
            }
            case DEFAULT: {
                protections = lwc.getPhysicalDatabase().getProtectionCount(player.getName());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Limit type " + type.toString() + " is undefined in LimitsModule::hasReachedLimit");
            }
        }
        return protections >= limit;
    }

    private int mapProtectionLimit(Player player, int blockId) {
        String limit = null;
        Type type = Type.resolve(this.resolveValue(player, "type"));
        if (type == Type.DEFAULT) {
            limit = this.resolveValue(player, "limit");
        } else if (type == Type.CUSTOM) {
            limit = this.resolveValue(player, blockId + "");
            if (limit == null && blockId > 0) {
                String name = Material.getMaterial((int)blockId).toString().toLowerCase().replaceAll("block", "");
                if (name.endsWith("_")) {
                    name = name.substring(0, name.length() - 1);
                }
                limit = this.resolveValue(player, name);
            }
            if (limit == null) {
                limit = this.resolveValue(player, "limit");
            }
        }
        if (limit == null || limit.equalsIgnoreCase("unlimited")) {
            return this.UNLIMITED;
        }
        return !limit.isEmpty() ? Integer.parseInt(limit) : this.UNLIMITED;
    }

    private String resolveValue(Player player, String node) {
        LWC lwc = LWC.getInstance();
        boolean hasPermissions = lwc.getPermissions().isActive();
        String value = this.configuration.getString("players." + player.getName() + "." + node);
        if (value == null && hasPermissions) {
            for (String groupName : lwc.getPermissions().getGroups(player)) {
                if (groupName == null || groupName.isEmpty() || value != null) continue;
                value = this.map("groups." + groupName + "." + node);
            }
        }
        if (value == null) {
            value = this.map("master." + node);
        }
        return value != null && !value.isEmpty() ? value : null;
    }

    private String map(String path) {
        String value = this.configuration.getString(path);
        if (value == null) {
            int lastIndex = path.lastIndexOf(".");
            String node = path.substring(lastIndex + 1);
            value = this.configuration.getString("master." + node);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public void onRegisterProtection(LWCProtectionRegisterEvent event) {
        Block block;
        if (event.isCancelled()) {
            return;
        }
        LWC lwc = event.getLWC();
        Player player = event.getPlayer();
        if (this.hasReachedLimit(player, block = event.getBlock())) {
            lwc.sendLocale((CommandSender)player, "protection.exceeded", new Object[0]);
            event.setCancelled(true);
        }
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        String playerName;
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("limits")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        event.setCancelled(true);
        if (args.length == 0 && !(sender instanceof Player)) {
            sender.sendMessage("\u00a74Unsupported");
            return;
        }
        if (args.length == 0) {
            playerName = ((Player)sender).getName();
        } else if (lwc.isAdmin(sender)) {
            playerName = args[0];
        } else {
            lwc.sendLocale(sender, "protection.accessdenied", new Object[0]);
            return;
        }
        Player player = lwc.getPlugin().getServer().getPlayer(playerName);
        if (player == null) {
            return;
        }
        Type type = Type.resolve(this.resolveValue(player, "type"));
        int limit = this.mapProtectionLimit(player, 0);
        String limitShow = limit + "";
        int current = lwc.getPhysicalDatabase().getProtectionCount(playerName);
        if (limit == this.UNLIMITED) {
            limitShow = "Unlimited";
        }
        String currColour = "\u00a72";
        if (limit == current) {
            currColour = "\u00a74";
        } else if (current > limit / 2) {
            currColour = "\u00a7e";
        }
        lwc.sendLocale(sender, "protection.limits", "type", StringUtils.capitalizeFirstLetter(type.toString()), "player", playerName, "limit", limitShow, "protected", currColour + current);
    }

    public static enum Type {
        NULL,
        DEFAULT,
        CUSTOM;


        public static Type resolve(String name) {
            for (Type type : Type.values()) {
                if (!type.toString().equalsIgnoreCase(name)) continue;
                return type;
            }
            return NULL;
        }
    }
}

