/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.modify;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.AccessRight;
import com.griefcraft.model.Action;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.util.StringUtils;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ModifyModule
extends JavaModule {
    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT) {
            return;
        }
        if (!event.hasAction("modify")) {
            return;
        }
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        Player player = event.getPlayer();
        event.setResult(Module.Result.CANCEL);
        if (lwc.canAdminProtection(player, protection)) {
            Action action = lwc.getMemoryDatabase().getAction("modify", player.getName());
            String defaultEntities = action.getData();
            String[] entities = new String[]{};
            if (defaultEntities.length() > 0) {
                entities = defaultEntities.split(" ");
            }
            lwc.removeModes(player);
            for (String rightsName : entities) {
                boolean remove = false;
                boolean isAdmin = false;
                int chestType = 1;
                if (rightsName.startsWith("-")) {
                    remove = true;
                    rightsName = rightsName.substring(1);
                }
                if (rightsName.startsWith("@")) {
                    isAdmin = true;
                    rightsName = rightsName.substring(1);
                }
                if (rightsName.toLowerCase().startsWith("g:")) {
                    chestType = 0;
                    rightsName = rightsName.substring(2);
                }
                if (rightsName.toLowerCase().startsWith("l:")) {
                    chestType = 2;
                    rightsName = rightsName.substring(2);
                }
                if (rightsName.toLowerCase().startsWith("list:")) {
                    chestType = 2;
                    rightsName = rightsName.substring(5);
                }
                int chestID = protection.getId();
                String localeChild = AccessRight.typeToString(chestType).toLowerCase();
                if (!remove) {
                    lwc.getPhysicalDatabase().unregisterProtectionRights(chestID, rightsName);
                    lwc.getPhysicalDatabase().registerProtectionRights(chestID, rightsName, isAdmin ? 1 : 0, chestType);
                    lwc.sendLocale((CommandSender)player, "protection.interact.rights.register." + localeChild, "name", rightsName, "isadmin", isAdmin ? "[\u00a74ADMIN\u00a76]" : "");
                } else {
                    lwc.getPhysicalDatabase().unregisterProtectionRights(chestID, rightsName);
                    lwc.sendLocale((CommandSender)player, "protection.interact.rights.remove." + localeChild, "name", rightsName, "isadmin", isAdmin ? "[\u00a74ADMIN\u00a76]" : "");
                }
                protection.update();
            }
        } else {
            lwc.sendLocale((CommandSender)player, "protection.interact.error.notowner", "block", LWC.materialToString(protection.getBlockId()));
            lwc.removeModes(player);
        }
    }

    @Override
    public void onBlockInteract(LWCBlockInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT) {
            return;
        }
        if (!event.hasAction("modify")) {
            return;
        }
        LWC lwc = event.getLWC();
        Block block = event.getBlock();
        Player player = event.getPlayer();
        event.setResult(Module.Result.CANCEL);
        lwc.sendLocale((CommandSender)player, "protection.interact.error.notregistered", "block", LWC.materialToString(block));
        lwc.removeModes(player);
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("m", "modify")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        event.setCancelled(true);
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a74Console not supported.");
            return;
        }
        if (!lwc.hasPlayerPermission(sender, "lwc.modify")) {
            lwc.sendLocale(sender, "protection.accessdenied", new Object[0]);
            return;
        }
        if (args.length < 1) {
            lwc.sendLocale(sender, "help.modify", new Object[0]);
            return;
        }
        String full = StringUtils.join(args, 0);
        Player player = (Player)sender;
        lwc.getMemoryDatabase().unregisterAllActions(player.getName());
        lwc.getMemoryDatabase().registerAction("modify", player.getName(), full);
        lwc.sendLocale(sender, "protection.modify.finalize", new Object[0]);
    }
}

