/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.owners;

import com.griefcraft.lwc.LWC;
import com.griefcraft.model.AccessRight;
import com.griefcraft.model.Action;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class OwnersModule
extends JavaModule {
    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT) {
            return;
        }
        if (!event.hasAction("owners")) {
            return;
        }
        LWC lwc = event.getLWC();
        Protection protection = event.getProtection();
        Player player = event.getPlayer();
        event.setResult(Module.Result.CANCEL);
        Action action = lwc.getMemoryDatabase().getAction("owners", player.getName());
        int accessPage = Integer.parseInt(action.getData());
        int start = (accessPage - 1) * 15;
        int max = start + 15;
        List<AccessRight> accessRights = lwc.getPhysicalDatabase().loadAccessRights(protection.getId(), start, max);
        int numRights = lwc.getPhysicalDatabase().countRightsForProtection(protection.getId());
        int realMax = start + accessRights.size();
        player.sendMessage("");
        player.sendMessage("\u00a72   LWC Protection");
        player.sendMessage("\u00a73Showing results \u00a7b" + start + "\u00a73" + "-" + "\u00a7b" + realMax + "\u00a73" + ". Total: " + "\u00a7b" + numRights);
        player.sendMessage("");
        player.sendMessage("");
        for (AccessRight accessRight : accessRights) {
            StringBuilder builder = new StringBuilder();
            builder.append("\u00a7b");
            builder.append(accessRight.getName());
            builder.append("\u00a73");
            builder.append(" (");
            builder.append(AccessRight.typeToString(accessRight.getType()));
            builder.append(") ");
            if (accessRight.getRights() == 1) {
                builder.append("\u00a7b");
                builder.append("(");
                builder.append("\u00a74");
                builder.append("ADMIN");
                builder.append("\u00a7b");
                builder.append(")");
            }
            player.sendMessage(builder.toString());
        }
        lwc.removeModes(player);
    }

    @Override
    public void onBlockInteract(LWCBlockInteractEvent event) {
        if (event.getResult() != Module.Result.DEFAULT) {
            return;
        }
        if (!event.hasAction("owners")) {
            return;
        }
        LWC lwc = event.getLWC();
        Player player = event.getPlayer();
        Block block = event.getBlock();
        lwc.sendLocale((CommandSender)player, "protection.interact.error.notregistered", "block", LWC.materialToString(block));
        lwc.removeModes(player);
    }

    @Override
    public void onCommand(LWCCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.hasFlag("o", "owner", "owners")) {
            return;
        }
        LWC lwc = event.getLWC();
        CommandSender sender = event.getSender();
        String[] args = event.getArgs();
        event.setCancelled(true);
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a74Console not supported.");
            return;
        }
        Player player = (Player)sender;
        int page = 1;
        if (args.length > 0) {
            try {
                page = Integer.parseInt(args[0]);
            }
            catch (Exception e) {
                lwc.sendSimpleUsage(sender, "/lwc -owners [page]");
                return;
            }
        }
        lwc.getMemoryDatabase().unregisterAllActions(player.getName());
        lwc.getMemoryDatabase().registerAction("owners", player.getName(), page + "");
        lwc.sendLocale(sender, "protection.owners.finalize", new Object[0]);
    }
}

