/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.scripting;

import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCInfo;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.MetaData;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.ModuleException;
import com.griefcraft.scripting.event.LWCAccessEvent;
import com.griefcraft.scripting.event.LWCBlockInteractEvent;
import com.griefcraft.scripting.event.LWCCommandEvent;
import com.griefcraft.scripting.event.LWCDropItemEvent;
import com.griefcraft.scripting.event.LWCEvent;
import com.griefcraft.scripting.event.LWCProtectionDestroyEvent;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.scripting.event.LWCProtectionRegisterEvent;
import com.griefcraft.scripting.event.LWCProtectionRegistrationPostEvent;
import com.griefcraft.scripting.event.LWCProtectionRemovePostEvent;
import com.griefcraft.scripting.event.LWCRedstoneEvent;
import com.griefcraft.scripting.event.LWCSendLocaleEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.OperationNotSupportedException;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ModuleLoader {
    private static Logger logger = Logger.getLogger("Loader");
    public static final String ROOT_PATH = "plugins/LWC/";
    private final Map<Plugin, List<MetaData>> pluginModules = new LinkedHashMap<Plugin, List<MetaData>>();

    public ModuleLoader() {
        this.pluginModules.put((Plugin)LWC.getInstance().getPlugin(), new ArrayList());
    }

    public void dispatchEvent(LWCEvent event) {
        if (event == null) {
            return;
        }
        try {
            for (List<MetaData> modules : this.pluginModules.values()) {
                for (MetaData metaData : modules) {
                    Module module = metaData.getModule();
                    if (event instanceof LWCAccessEvent) {
                        module.protectionAccessRequest((LWCAccessEvent)event);
                        continue;
                    }
                    if (event instanceof LWCBlockInteractEvent) {
                        module.onBlockInteract((LWCBlockInteractEvent)event);
                        continue;
                    }
                    if (event instanceof LWCCommandEvent) {
                        module.onCommand((LWCCommandEvent)event);
                        continue;
                    }
                    if (event instanceof LWCDropItemEvent) {
                        module.onDropItem((LWCDropItemEvent)event);
                        continue;
                    }
                    if (event instanceof LWCProtectionDestroyEvent) {
                        module.onDestroyProtection((LWCProtectionDestroyEvent)event);
                        continue;
                    }
                    if (event instanceof LWCProtectionInteractEvent) {
                        module.onProtectionInteract((LWCProtectionInteractEvent)event);
                        continue;
                    }
                    if (event instanceof LWCProtectionRegisterEvent) {
                        module.onRegisterProtection((LWCProtectionRegisterEvent)event);
                        continue;
                    }
                    if (event instanceof LWCProtectionRemovePostEvent) {
                        module.onPostRemoval((LWCProtectionRemovePostEvent)event);
                        continue;
                    }
                    if (event instanceof LWCProtectionRegistrationPostEvent) {
                        module.onPostRegistration((LWCProtectionRegistrationPostEvent)event);
                        continue;
                    }
                    if (event instanceof LWCSendLocaleEvent) {
                        module.onSendLocale((LWCSendLocaleEvent)event);
                        continue;
                    }
                    if (!(event instanceof LWCRedstoneEvent)) continue;
                    module.onRedstone((LWCRedstoneEvent)event);
                }
            }
        }
        catch (Throwable throwable) {
            throw new ModuleException("LWC Module threw an uncaught exception! LWC version: " + LWCInfo.FULL_VERSION, throwable);
        }
    }

    public Module.Result dispatchEvent(Event event, Object ... args) {
        if (event.getExpectedArguments() > args.length) {
            return Module.Result.DEFAULT;
        }
        LWC lwc = LWC.getInstance();
        Module.Result result = Module.Result.DEFAULT;
        try {
            for (List<MetaData> modules : this.pluginModules.values()) {
                for (MetaData metaData : modules) {
                    Module module = metaData.getModule();
                    Module.Result temp = Module.Result.DEFAULT;
                    switch (event) {
                        case COMMAND: {
                            temp = module.onCommand(lwc, (CommandSender)args[0], (String)args[1], (String[])args[2]);
                            break;
                        }
                        case REDSTONE: {
                            temp = module.onRedstone(lwc, (Protection)args[0], (Block)args[1], (Integer)args[2]);
                            break;
                        }
                        case DESTROY_PROTECTION: {
                            temp = module.onDestroyProtection(lwc, (Player)args[0], (Protection)args[1], (Block)args[2], (Boolean)args[3], (Boolean)args[4]);
                            break;
                        }
                        case INTERACT_PROTECTION: {
                            temp = module.onProtectionInteract(lwc, (Player)args[0], (Protection)args[1], (List)args[2], (Boolean)args[3], (Boolean)args[4]);
                            break;
                        }
                        case INTERACT_BLOCK: {
                            temp = module.onBlockInteract(lwc, (Player)args[0], (Block)args[1], (List)args[2]);
                            break;
                        }
                        case REGISTER_PROTECTION: {
                            temp = module.onRegisterProtection(lwc, (Player)args[0], (Block)args[1]);
                            break;
                        }
                        case ACCESS_PROTECTION: {
                            temp = module.canAccessProtection(lwc, (Player)args[0], (Protection)args[1]);
                            break;
                        }
                        case ADMIN_PROTECTION: {
                            temp = module.canAdminProtection(lwc, (Player)args[0], (Protection)args[1]);
                            break;
                        }
                        case DROP_ITEM: {
                            temp = module.onDropItem(lwc, (Player)args[0], (Item)args[1], (ItemStack)args[2]);
                            break;
                        }
                        case POST_REGISTRATION: {
                            module.onPostRegistration(lwc, (Protection)args[0]);
                            break;
                        }
                        case POST_REMOVAL: {
                            module.onPostRemoval(lwc, (Protection)args[0]);
                            break;
                        }
                        case SEND_LOCALE: {
                            temp = module.onSendLocale(lwc, (Player)args[0], (String)args[1]);
                            break;
                        }
                        case ACCESS_REQUEST: {
                            throw new OperationNotSupportedException("ACCESS_REQUEST");
                        }
                    }
                    if (temp != Module.Result.DEFAULT) {
                        result = temp;
                    }
                    if (result != Module.Result.CANCEL) continue;
                    return result;
                }
            }
        }
        catch (Throwable throwable) {
            throw new ModuleException("LWC Module threw an uncaught exception! LWC version: " + LWCInfo.FULL_VERSION, throwable);
        }
        if (result == null) {
            result = Module.Result.DEFAULT;
        }
        return result;
    }

    public void shutdown() {
        this.pluginModules.clear();
    }

    public void loadAll() {
        LWC lwc = LWC.getInstance();
        for (List<MetaData> modules : this.pluginModules.values()) {
            for (MetaData metaData : modules) {
                if (metaData.isLoaded()) continue;
                metaData.getModule().load(lwc);
                metaData.trigger();
            }
        }
    }

    public Module getModule(Class<? extends Module> clazz) {
        for (List<MetaData> modules : this.pluginModules.values()) {
            for (MetaData metaData : modules) {
                Module module = metaData.getModule();
                if (module.getClass() != clazz) continue;
                return module;
            }
        }
        return null;
    }

    public Map<Plugin, List<MetaData>> getRegisteredModules() {
        return Collections.unmodifiableMap(this.pluginModules);
    }

    public int getModuleCount() {
        int count = 0;
        for (List<MetaData> modules : this.pluginModules.values()) {
            count += modules.size();
        }
        return count;
    }

    public void registerModule(Plugin plugin, Module module) {
        List<MetaData> modules = null;
        if (plugin != null) {
            modules = this.pluginModules.get(plugin);
        }
        if (modules == null) {
            modules = new ArrayList<MetaData>();
        }
        MetaData metaData = new MetaData(module);
        modules.add(metaData);
        this.pluginModules.put(plugin, modules);
    }

    public void removeModules(Plugin plugin) {
        this.pluginModules.remove(plugin);
    }

    public static enum Event {
        LOAD(0),
        UNLOAD(0),
        COMMAND(3),
        REDSTONE(3),
        DESTROY_PROTECTION(5),
        INTERACT_PROTECTION(5),
        INTERACT_BLOCK(3),
        REGISTER_PROTECTION(2),
        ACCESS_PROTECTION(2),
        ADMIN_PROTECTION(2),
        DROP_ITEM(3),
        POST_REGISTRATION(1),
        POST_REMOVAL(1),
        SEND_LOCALE(2),
        ACCESS_REQUEST;

        int arguments;

        private Event() {
        }

        private Event(int arguments) {
            this.arguments = arguments;
        }

        public int getExpectedArguments() {
            return this.arguments;
        }
    }
}

