/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.sql;

import com.griefcraft.model.Action;
import com.griefcraft.model.Protection;
import com.griefcraft.sql.Column;
import com.griefcraft.sql.Database;
import com.griefcraft.sql.Table;
import com.griefcraft.util.Performance;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class MemDB
extends Database {
    public MemDB() {
    }

    public MemDB(Database.Type currentType) {
        super(currentType);
    }

    @Override
    protected void postPrepare() {
        Performance.addMemDBQuery();
    }

    public Action getAction(String action, String player) {
        try {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "actions WHERE player = ? AND action = ?");
            statement.setString(1, player);
            statement.setString(2, action);
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                int id = set.getInt("id");
                String actionString = set.getString("action");
                String playerString = set.getString("player");
                int chestID = set.getInt("chest");
                String data = set.getString("data");
                Action act = new Action();
                act.setID(id);
                act.setAction(actionString);
                act.setPlayer(playerString);
                act.setChestID(chestID);
                act.setData(data);
                return act;
            }
        }
        catch (Exception e) {
            this.printException(e);
        }
        return null;
    }

    public int getActionID(String action, String player) {
        try {
            int chestID = -1;
            PreparedStatement statement = this.prepare("SELECT chest FROM " + this.prefix + "actions WHERE action = ? AND player = ?");
            statement.setString(1, action);
            statement.setString(2, player);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                chestID = set.getInt("chest");
            }
            return chestID;
        }
        catch (Exception e) {
            this.printException(e);
            return -1;
        }
    }

    public List<String> getActions(String player) {
        ArrayList<String> actions = new ArrayList<String>();
        try {
            PreparedStatement statement = this.prepare("SELECT action FROM " + this.prefix + "actions WHERE player = ?");
            statement.setString(1, player);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                String action = set.getString("action");
                actions.add(action);
            }
        }
        catch (Exception e) {
            this.printException(e);
        }
        return actions;
    }

    @Override
    public String getDatabasePath() {
        if (this.currentType == Database.Type.MySQL) {
            return super.getDatabasePath();
        }
        return ":memory:";
    }

    public String getLockPassword(String player) {
        try {
            String password = "";
            PreparedStatement statement = this.prepare("SELECT password FROM " + this.prefix + "locks WHERE player = ?");
            statement.setString(1, player);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                password = set.getString("password");
            }
            return password;
        }
        catch (Exception e) {
            this.printException(e);
            return null;
        }
    }

    public String getModeData(String player, String mode) {
        String ret = null;
        try {
            PreparedStatement statement = this.prepare("SELECT data FROM " + this.prefix + "modes WHERE player = ? AND mode = ?");
            statement.setString(1, player);
            statement.setString(2, mode);
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                ret = set.getString("data");
            }
        }
        catch (Exception e) {
            this.printException(e);
        }
        return ret;
    }

    public List<String> getModes(String player) {
        ArrayList<String> modes = new ArrayList<String>();
        try {
            PreparedStatement statement = this.prepare("SELECT * FROM " + this.prefix + "modes WHERE player = ?");
            statement.setString(1, player);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                String mode = set.getString("mode");
                modes.add(mode);
            }
        }
        catch (Exception e) {
            this.printException(e);
        }
        return modes;
    }

    public List<String> getSessionUsers(int chestID) {
        ArrayList<String> sessionUsers = new ArrayList<String>();
        try {
            PreparedStatement statement = this.prepare("SELECT player FROM " + this.prefix + "sessions WHERE chest = ?");
            statement.setInt(1, chestID);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                String player = set.getString("player");
                sessionUsers.add(player);
            }
        }
        catch (Exception e) {
            this.printException(e);
        }
        return sessionUsers;
    }

    public int getUnlockID(String player) {
        return this.getActionID("unlock", player);
    }

    public boolean hasAccess(String player, int chestID) {
        try {
            PreparedStatement statement = this.prepare("SELECT player FROM " + this.prefix + "sessions WHERE chest = ?");
            statement.setInt(1, chestID);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                String player2 = set.getString("player");
                if (!player.equals(player2)) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.printException(e);
        }
        return false;
    }

    public boolean hasAccess(String player, Protection chest) {
        return chest == null || this.hasAccess(player, chest.getId());
    }

    public boolean hasMode(String player, String mode) {
        List<String> modes = this.getModes(player);
        return modes.size() > 0 && modes.contains(mode);
    }

    public boolean hasPendingAction(String action, String player) {
        return this.getAction(action, player) != null;
    }

    public boolean hasPendingChest(String player) {
        try {
            PreparedStatement statement = this.prepare("SELECT id FROM " + this.prefix + "locks WHERE player = ?");
            statement.setString(1, player);
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                set.close();
                return true;
            }
            set.close();
        }
        catch (Exception e) {
            this.printException(e);
        }
        return false;
    }

    public boolean hasPendingUnlock(String player) {
        return this.getUnlockID(player) != -1;
    }

    @Override
    public void load() {
        if (this.loaded) {
            return;
        }
        try {
            Table sessions = new Table(this, "sessions");
            sessions.setMemory(true);
            Column column = new Column("id");
            column.setType("INTEGER");
            column.setPrimary(true);
            sessions.add(column);
            column = new Column("player");
            column.setType("VARCHAR(255)");
            sessions.add(column);
            column = new Column("chest");
            column.setType("INTEGER");
            sessions.add(column);
            Table locks = new Table(this, "locks");
            locks.setMemory(true);
            column = new Column("id");
            column.setType("INTEGER");
            column.setPrimary(true);
            locks.add(column);
            column = new Column("player");
            column.setType("VARCHAR(255)");
            locks.add(column);
            column = new Column("password");
            column.setType("VARCHAR(100)");
            locks.add(column);
            Table actions = new Table(this, "actions");
            actions.setMemory(true);
            column = new Column("id");
            column.setType("INTEGER");
            column.setPrimary(true);
            actions.add(column);
            column = new Column("action");
            column.setType("VARCHAR(255)");
            actions.add(column);
            column = new Column("player");
            column.setType("VARCHAR(255)");
            actions.add(column);
            column = new Column("chest");
            column.setType("INTEGER");
            actions.add(column);
            column = new Column("data");
            column.setType("VARCHAR(255)");
            actions.add(column);
            Table modes = new Table(this, "modes");
            modes.setMemory(true);
            column = new Column("id");
            column.setType("INTEGER");
            column.setPrimary(true);
            modes.add(column);
            column = new Column("player");
            column.setType("VARCHAR(255)");
            modes.add(column);
            column = new Column("mode");
            column.setType("VARCHAR(255)");
            modes.add(column);
            column = new Column("data");
            column.setType("VARCHAR(255)");
            modes.add(column);
            sessions.execute();
            locks.execute();
            actions.execute();
            modes.execute();
        }
        catch (Exception e) {
            this.printException(e);
        }
        this.loaded = true;
    }

    public int pendingCount() {
        int count = 0;
        try {
            Statement statement = this.connection.createStatement();
            ResultSet set = statement.executeQuery("SELECT id FROM " + this.prefix + "locks");
            while (set.next()) {
                ++count;
            }
            statement.close();
        }
        catch (Exception e) {
            this.printException(e);
        }
        return count;
    }

    public void registerAction(String action, String player) {
        try {
            this.unregisterAction(action, player);
            PreparedStatement statement = this.prepare("INSERT INTO " + this.prefix + "actions (action, player, chest) VALUES (?, ?, ?)");
            statement.setString(1, action);
            statement.setString(2, player);
            statement.setInt(3, -1);
            statement.executeUpdate();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void registerAction(String action, String player, int chestID) {
        try {
            this.unregisterAction(action, player);
            PreparedStatement statement = this.prepare("INSERT INTO " + this.prefix + "actions (action, player, chest) VALUES (?, ?, ?)");
            statement.setString(1, action);
            statement.setString(2, player);
            statement.setInt(3, chestID);
            statement.executeUpdate();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void registerAction(String action, String player, String data) {
        try {
            this.unregisterAction(action, player);
            PreparedStatement statement = this.prepare("INSERT INTO " + this.prefix + "actions (action, player, data) VALUES (?, ?, ?)");
            statement.setString(1, action);
            statement.setString(2, player);
            statement.setString(3, data);
            statement.executeUpdate();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void registerMode(String player, String mode) {
        try {
            PreparedStatement statement = this.prepare("INSERT INTO " + this.prefix + "modes (player, mode) VALUES (?, ?)");
            statement.setString(1, player);
            statement.setString(2, mode);
            statement.executeUpdate();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void registerMode(String player, String mode, String data) {
        try {
            PreparedStatement statement = this.prepare("INSERT INTO " + this.prefix + "modes (player, mode, data) VALUES (?, ?, ?)");
            statement.setString(1, player);
            statement.setString(2, mode);
            statement.setString(3, data);
            statement.executeUpdate();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void registerPendingLock(String player, String password) {
        try {
            PreparedStatement statement = this.prepare("INSERT INTO " + this.prefix + "locks (player, password) VALUES (?, ?)");
            statement.setString(1, player);
            statement.setString(2, password);
            statement.executeUpdate();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void registerPlayer(String player, int chestID) {
        try {
            PreparedStatement statement = this.prepare("INSERT INTO " + this.prefix + "sessions (player, chest) VALUES(?, ?)");
            statement.setString(1, player);
            statement.setInt(2, chestID);
            statement.executeUpdate();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void registerUnlock(String player, int chestID) {
        this.registerAction("unlock", player, chestID);
    }

    public int sessionCount() {
        int count = 0;
        try {
            Statement statement = this.connection.createStatement();
            ResultSet set = statement.executeQuery("SELECT id FROM " + this.prefix + "sessions");
            while (set.next()) {
                ++count;
            }
            statement.close();
        }
        catch (Exception e) {
            this.printException(e);
        }
        return count;
    }

    public void unregisterAction(String action, String player) {
        try {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "actions WHERE action = ? AND player = ?");
            statement.setString(1, action);
            statement.setString(2, player);
            statement.executeUpdate();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void unregisterAllActions(String player) {
        try {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "actions WHERE player = ?");
            statement.setString(1, player);
            statement.executeUpdate();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void unregisterAllChests() {
        try {
            Statement statement = this.connection.createStatement();
            statement.executeUpdate("DELETE FROM " + this.prefix + "locks");
            statement.close();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void unregisterAllModes(String player) {
        try {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "modes WHERE player = ?");
            statement.setString(1, player);
            statement.executeUpdate();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void unregisterMode(String player, String mode) {
        try {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "modes WHERE player = ? AND mode = ?");
            statement.setString(1, player);
            statement.setString(2, mode);
            statement.executeUpdate();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void unregisterPendingLock(String player) {
        try {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "locks WHERE player = ?");
            statement.setString(1, player);
            statement.executeUpdate();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void unregisterPlayer(String player) {
        try {
            PreparedStatement statement = this.prepare("DELETE FROM " + this.prefix + "sessions WHERE player = ?");
            statement.setString(1, player);
            statement.executeUpdate();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void unregisterUnlock(String player) {
        this.unregisterAction("unlock", player);
    }
}

