/*
 * Decompiled with CFR 0.152.
 */
package com.sparkedia.valrix.ColorMe;

import com.sparkedia.valrix.ColorMe.ColorMe;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Property {
    private Logger log;
    protected ColorMe plugin;
    private LinkedHashMap<String, Object> properties = new LinkedHashMap();
    private String filename;
    private String pName;
    private String version;

    public Property(String filename, ColorMe plugin) {
        this.plugin = plugin;
        this.pName = plugin.pName;
        this.version = plugin.getDescription().getVersion();
        this.log = plugin.log;
        this.filename = filename;
        File file = new File(filename);
        if (file.exists()) {
            this.load();
        }
    }

    public void load() {
        BufferedReader br = null;
        try {
            try {
                String line;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filename), "UTF-8"));
                int cc = 0;
                int lc = 0;
                while ((line = br.readLine()) != null) {
                    if (lc == 0) {
                        String v = line.indexOf(45) > 0 ? line.substring(line.indexOf(45) + 1).trim() : "na";
                        this.properties.put(String.valueOf(this.pName) + "Version", v);
                        ++lc;
                        continue;
                    }
                    if (line.charAt(0) == '#' && lc > 0) {
                        this.properties.put("#" + cc, line.substring(line.indexOf(32) + 1).trim());
                        ++cc;
                        ++lc;
                        continue;
                    }
                    int delim = line.indexOf(61);
                    if (delim != -1) {
                        this.properties.put(line.substring(0, delim).trim(), line.substring(delim + 1).trim());
                    }
                    ++lc;
                }
            }
            catch (FileNotFoundException ex) {
                this.log.log(Level.SEVERE, String.valueOf('[') + this.pName + "]: Couldn't find file " + this.filename, ex);
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex2) {
                    this.log.log(Level.SEVERE, String.valueOf('[') + this.pName + "]: Unable to save " + this.filename, ex2);
                }
                return;
            }
            catch (IOException ex) {
                this.log.log(Level.SEVERE, String.valueOf('[') + this.pName + "]: Unable to save " + this.filename, ex);
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex3) {
                    this.log.log(Level.SEVERE, String.valueOf('[') + this.pName + "]: Unable to save " + this.filename, ex3);
                }
                return;
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                this.log.log(Level.SEVERE, String.valueOf('[') + this.pName + "]: Unable to save " + this.filename, ex);
            }
        }
    }

    public void save() {
        BufferedWriter bw = null;
        try {
            try {
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.filename), "UTF-8"));
                bw.write("# " + this.pName + " Color File -" + this.version);
                bw.newLine();
                if (this.properties.size() > 0) {
                    Set<Map.Entry<String, Object>> set = this.properties.entrySet();
                    for (Map.Entry<String, Object> me : set) {
                        String key = me.getKey().toString();
                        String val = me.getValue().toString();
                        if (key.charAt(0) == '#') {
                            bw.write("# " + val);
                            bw.newLine();
                            continue;
                        }
                        if (key.equalsIgnoreCase(String.valueOf(this.pName) + "Version")) continue;
                        bw.write(String.valueOf(key) + '=' + val);
                        bw.newLine();
                    }
                }
            }
            catch (FileNotFoundException ex) {
                this.log.log(Level.SEVERE, String.valueOf('[') + this.pName + "]: Couldn't find file " + this.filename, ex);
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException ex2) {
                    this.log.log(Level.SEVERE, String.valueOf('[') + this.pName + "]: Unable to save " + this.filename, ex2);
                }
                return;
            }
            catch (IOException ex) {
                this.log.log(Level.SEVERE, String.valueOf('[') + this.pName + "]: Unable to save " + this.filename, ex);
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException ex3) {
                    this.log.log(Level.SEVERE, String.valueOf('[') + this.pName + "]: Unable to save " + this.filename, ex3);
                }
                return;
            }
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException ex) {
                this.log.log(Level.SEVERE, String.valueOf('[') + this.pName + "]: Unable to save " + this.filename, ex);
            }
        }
    }

    public void rebuild(LinkedHashMap<String, Object> newMap) {
        this.properties.clear();
        this.properties.putAll(newMap);
        this.save();
    }

    public boolean match(LinkedHashMap<String, Object> prop) {
        return this.properties.keySet().containsAll(prop.keySet());
    }

    public boolean keyExists(String key) {
        return this.properties.containsKey(key);
    }

    public boolean isEmpty(String key) {
        return this.properties.get(key).toString().length() < 1;
    }

    public boolean remove(String key) {
        return this.properties.remove(key) != null;
    }

    public void clear() {
        this.properties.clear();
    }

    public Set<String> getKeys() {
        return this.properties.keySet();
    }

    public void setString(String key, String value) {
        this.properties.put(key, value);
    }

    public void setNumber(String key, Number value) {
        this.properties.put(key, String.valueOf(value));
    }

    public void setBool(String key, boolean value) {
        this.properties.put(key, String.valueOf(value));
    }

    public String getString(String key) {
        return this.properties.containsKey(key) ? this.properties.get(key).toString() : "";
    }

    public int getInt(String key) {
        return this.properties.containsKey(key) ? Integer.parseInt(this.properties.get(key).toString()) : 0;
    }

    public double getDouble(String key) {
        return this.properties.containsKey(key) ? Double.parseDouble(this.properties.get(key).toString()) : 0.0;
    }

    public boolean getBoolean(String key) {
        return this.properties.containsKey(key) ? Boolean.parseBoolean(this.properties.get(key).toString()) : false;
    }
}

