/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.easyban;

import javax.naming.NamingException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import uk.org.whoami.easyban.ConsoleLogger;
import uk.org.whoami.easyban.commands.AlternativeCommand;
import uk.org.whoami.easyban.commands.BanCommand;
import uk.org.whoami.easyban.commands.BanCountryCommand;
import uk.org.whoami.easyban.commands.BanInfoCommand;
import uk.org.whoami.easyban.commands.BanSubnetCommand;
import uk.org.whoami.easyban.commands.HistoryCommand;
import uk.org.whoami.easyban.commands.KickCommand;
import uk.org.whoami.easyban.commands.ListBansCommand;
import uk.org.whoami.easyban.commands.ListCountryBansCommand;
import uk.org.whoami.easyban.commands.ListSubnetBansCommand;
import uk.org.whoami.easyban.commands.ListTemporaryBansCommand;
import uk.org.whoami.easyban.commands.ListWhitelistCommand;
import uk.org.whoami.easyban.commands.UnbanCommand;
import uk.org.whoami.easyban.commands.UnbanCountryCommand;
import uk.org.whoami.easyban.commands.UnbanSubnetCommand;
import uk.org.whoami.easyban.commands.UnwhitelistCommand;
import uk.org.whoami.easyban.commands.WhitelistCommand;
import uk.org.whoami.easyban.datasource.DataSource;
import uk.org.whoami.easyban.datasource.HSQLDataSource;
import uk.org.whoami.easyban.datasource.MySQLDataSource;
import uk.org.whoami.easyban.datasource.YamlDataSource;
import uk.org.whoami.easyban.listener.EasyBanCountryListener;
import uk.org.whoami.easyban.listener.EasyBanPlayerListener;
import uk.org.whoami.easyban.settings.Settings;
import uk.org.whoami.easyban.tasks.UnbanTask;
import uk.org.whoami.easyban.util.DNSBL;
import uk.org.whoami.geoip.GeoIPLookup;
import uk.org.whoami.geoip.GeoIPTools;

public class EasyBan
extends JavaPlugin {
    private DataSource database;
    private Settings settings;

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        if (this.database != null) {
            this.database.close();
        }
        ConsoleLogger.info("EasyBan disabled; Version: " + this.getDescription().getVersion());
    }

    public void onEnable() {
        DNSBL dNSBL;
        this.settings = Settings.getInstance();
        switch (this.settings.getDatabase()) {
            case YAML: {
                this.database = new YamlDataSource();
                break;
            }
            case MYSQL: {
                try {
                    this.database = new MySQLDataSource(this.settings);
                    break;
                }
                catch (Exception exception) {
                    ConsoleLogger.info(exception.getMessage());
                    ConsoleLogger.info("Can't load database");
                    this.getServer().getPluginManager().disablePlugin((Plugin)this);
                    return;
                }
            }
            case HSQL: {
                try {
                    this.database = new HSQLDataSource(this);
                    break;
                }
                catch (Exception exception) {
                    ConsoleLogger.info(exception.getMessage());
                    ConsoleLogger.info("Can't load database");
                    this.getServer().getPluginManager().disablePlugin((Plugin)this);
                    return;
                }
            }
        }
        try {
            dNSBL = new DNSBL();
            for (String string : this.settings.getBlockLists()) {
                dNSBL.addLookupService(string);
            }
            Object object = new EasyBanPlayerListener(this.database, dNSBL);
            this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_LOGIN, object, Event.Priority.Lowest, (Plugin)this);
            this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_JOIN, object, Event.Priority.Lowest, (Plugin)this);
        }
        catch (NamingException namingException) {
            ConsoleLogger.info(namingException.getMessage());
            ConsoleLogger.info("DNSBL error");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        dNSBL = this.getGeoIPLookup();
        if (dNSBL != null) {
            this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_LOGIN, (Listener)new EasyBanCountryListener(this.database, (GeoIPLookup)dNSBL), Event.Priority.Lowest, (Plugin)this);
        }
        this.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this, (Runnable)new UnbanTask(this.database), 60L, 1200L);
        this.getCommand("ekick").setExecutor((CommandExecutor)new KickCommand());
        this.getCommand("eban").setExecutor((CommandExecutor)new BanCommand(this.database));
        this.getCommand("eunban").setExecutor((CommandExecutor)new UnbanCommand(this.database));
        this.getCommand("ehistory").setExecutor((CommandExecutor)new HistoryCommand(this.database));
        this.getCommand("ealternative").setExecutor((CommandExecutor)new AlternativeCommand(this.database));
        this.getCommand("ebaninfo").setExecutor((CommandExecutor)new BanInfoCommand(this.database));
        this.getCommand("elistbans").setExecutor((CommandExecutor)new ListBansCommand(this.database));
        this.getCommand("elisttmpbans").setExecutor((CommandExecutor)new ListTemporaryBansCommand(this.database));
        this.getCommand("ebansubnet").setExecutor((CommandExecutor)new BanSubnetCommand(this.database));
        this.getCommand("eunbansubnet").setExecutor((CommandExecutor)new UnbanSubnetCommand(this.database));
        this.getCommand("elistsubnets").setExecutor((CommandExecutor)new ListSubnetBansCommand(this.database));
        this.getCommand("ebancountry").setExecutor((CommandExecutor)new BanCountryCommand(this.database));
        this.getCommand("eunbancountry").setExecutor((CommandExecutor)new UnbanCountryCommand(this.database));
        this.getCommand("elistcountries").setExecutor((CommandExecutor)new ListCountryBansCommand(this.database));
        this.getCommand("ewhitelist").setExecutor((CommandExecutor)new WhitelistCommand(this.database));
        this.getCommand("eunwhitelist").setExecutor((CommandExecutor)new UnwhitelistCommand(this.database));
        this.getCommand("elistwhite").setExecutor((CommandExecutor)new ListWhitelistCommand(this.database));
        ConsoleLogger.info("EasyBan enabled; Version: " + this.getDescription().getVersion());
    }

    private GeoIPLookup getGeoIPLookup() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("GeoIPTools");
        if (plugin != null) {
            return ((GeoIPTools)plugin).getGeoIPLookup(364);
        }
        return null;
    }
}

