/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.easyban.commands;

import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import uk.org.whoami.easyban.ConsoleLogger;
import uk.org.whoami.easyban.commands.EasyBanCommand;
import uk.org.whoami.easyban.datasource.DataSource;
import uk.org.whoami.easyban.settings.Settings;
import uk.org.whoami.easyban.util.Subnet;

public class BanSubnetCommand
extends EasyBanCommand {
    private DataSource database;

    public BanSubnetCommand(DataSource dataSource) {
        this.database = dataSource;
    }

    @Override
    protected void execute(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (stringArray.length == 0) {
            return;
        }
        Subnet subnet = null;
        try {
            subnet = new Subnet(stringArray[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (subnet != null) {
            String string2 = null;
            if (stringArray.length == 1) {
                this.database.banSubnet(subnet, this.admin, null);
            } else {
                string2 = "";
                for (int i = 1; i < stringArray.length; ++i) {
                    string2 = string2 + stringArray[i] + " ";
                }
                this.database.banSubnet(subnet, this.admin, string2);
            }
            Settings settings = Settings.getInstance();
            if (settings.isSubnetBanPublic()) {
                commandSender.getServer().broadcastMessage(subnet.toString() + this.m._(" has been banned"));
            }
            if (string2 != null && settings.isSubnetBanReasonPublic()) {
                commandSender.getServer().broadcastMessage(this.m._("Reason: ") + string2);
            }
            ConsoleLogger.info(subnet.toString() + " has been banned by " + this.admin);
        } else {
            commandSender.sendMessage(this.m._("Invalid Subnet"));
        }
    }
}

