/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.easyban.datasource;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.bukkit.plugin.java.JavaPlugin;
import uk.org.whoami.easyban.ConsoleLogger;
import uk.org.whoami.easyban.datasource.SQLDataSource;

public class HSQLDataSource
extends SQLDataSource {
    private String path;

    public HSQLDataSource(JavaPlugin javaPlugin) throws ClassNotFoundException, SQLException {
        this.path = javaPlugin.getDataFolder().getAbsolutePath() + "/bans";
        this.connect();
        this.setup();
        ConsoleLogger.info("Database setup finished");
    }

    @Override
    protected final synchronized void connect() throws SQLException, ClassNotFoundException {
        Class.forName("org.hsqldb.jdbc.JDBCDriver");
        ConsoleLogger.info("HSQLDB driver loaded");
        this.con = DriverManager.getConnection("jdbc:hsqldb:file:" + this.path, "SA", "");
        ConsoleLogger.info("Connected to Database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final synchronized void setup() throws SQLException {
        Statement statement = null;
        try {
            statement = this.con.createStatement();
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS player (player_id INTEGER GENERATED BY DEFAULT AS IDENTITY,player VARCHAR(20) NOT NULL,CONSTRAINT player_const_prim PRIMARY KEY (player_id),CONSTRAINT player_const_uniq UNIQUE(player));");
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS ip (ip_id INTEGER GENERATED BY DEFAULT AS IDENTITY,player_id INTEGER NOT NULL,ip VARCHAR(40) NOT NULL,CONSTRAINT ip_const_prim PRIMARY KEY (ip_id),CONSTRAINT ip_const_ref FOREIGN KEY (player_id) REFERENCES player (player_id));");
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS player_ban (player_ban_id INTEGER GENERATED BY DEFAULT AS IDENTITY,player_id INTEGER NOT NULL,admin VARCHAR(20) NOT NULL,reason VARCHAR(100),until TIMESTAMP,CONSTRAINT player_ban_const_prim PRIMARY KEY (player_ban_id),CONSTRAINT player_ban_const_uniq UNIQUE (player_id),CONSTRAINT player_ban_const_ref FOREIGN KEY (player_id) REFERENCES player (player_id));");
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS subnet_ban (subnet_ban_id INTEGER GENERATED BY DEFAULT AS IDENTITY,subnet VARCHAR(100) NOT NULL,admin VARCHAR(20) NOT NULL,reason VARCHAR(100),CONSTRAINT subnet_ban_const_prim PRIMARY KEY (subnet_ban_id),CONSTRAINT subnet_ban_const_uniq UNIQUE (subnet));");
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS country_ban (country_ban_id INTEGER GENERATED BY DEFAULT AS IDENTITY,country VARCHAR(2) NOT NULL,CONSTRAINT country_ban_const_prim PRIMARY KEY (country_ban_id),CONSTRAINT country_ban_const_uniq UNIQUE (country));");
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS whitelist (whitelist_id INTEGER GENERATED BY DEFAULT AS IDENTITY,player_id INTEGER NOT NULL,CONSTRAINT whitelist_const_prim PRIMARY KEY (whitelist_id),CONSTRAINT whitelist_const_ref FOREIGN KEY (player_id) REFERENCES player (player_id));");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public synchronized void close() {
        try {
            Statement statement = this.con.createStatement();
            statement.execute("SHUTDOWN");
            this.con.close();
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
    }
}

