/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.easyban.datasource;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import uk.org.whoami.easyban.ConsoleLogger;
import uk.org.whoami.easyban.datasource.DataSource;
import uk.org.whoami.easyban.util.Subnet;

public abstract class SQLDataSource
implements DataSource {
    protected Connection con;

    protected abstract void connect() throws ClassNotFoundException, SQLException;

    protected abstract void setup() throws SQLException;

    @Override
    public abstract void close();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createNick(String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.con.prepareStatement("SELECT player FROM player WHERE player=?");
            preparedStatement.setString(1, string);
            if (!preparedStatement.executeQuery().next()) {
                preparedStatement.close();
                preparedStatement = this.con.prepareStatement("INSERT INTO player (player) VALUES(?);");
                preparedStatement.setString(1, string);
                preparedStatement.executeUpdate();
            }
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addIpToHistory(String string, String string2) {
        Statement statement = null;
        try {
            this.createNick(string);
            statement = this.con.prepareStatement("SELECT ip FROM ip WHERE player_id=(SELECT player_id FROM player WHERE player= ?) AND ip=?;");
            statement.setString(1, string);
            statement.setString(2, string2);
            if (!statement.executeQuery().next()) {
                statement.close();
                statement = this.con.prepareStatement("INSERT INTO ip (player_id,ip) VALUES((SELECT player_id FROM player WHERE player= ? ),?);");
                statement.setString(1, string);
                statement.setString(2, string2);
                statement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void banNick(String string, String string2, String string3, Calendar calendar) {
        Statement statement = null;
        try {
            this.createNick(string);
            statement = this.con.prepareStatement("INSERT INTO player_ban (player_id,admin,reason,until) VALUES((SELECT player_id FROM player WHERE player= ? ),?,?,?);");
            statement.setString(1, string);
            statement.setString(2, string2);
            if (string3 != null) {
                statement.setString(3, string3);
            } else {
                statement.setNull(3, 12);
            }
            if (calendar != null) {
                statement.setTimestamp(4, new Timestamp(calendar.getTimeInMillis()));
            } else {
                statement.setTimestamp(4, new Timestamp(100000L));
            }
            statement.executeUpdate();
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unbanNick(String string) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.con.prepareStatement("DELETE FROM player_ban WHERE player_id=(SELECT player_id FROM player WHERE player=?);");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void banSubnet(Subnet subnet, String string, String string2) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.con.prepareStatement("INSERT INTO subnet_ban (subnet,admin,reason) VALUES(?,?,?);");
            preparedStatement.setString(1, subnet.toString());
            preparedStatement.setString(2, string);
            if (string2 != null) {
                preparedStatement.setString(3, string2);
            } else {
                preparedStatement.setNull(3, 12);
            }
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unbanSubnet(Subnet subnet) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.con.prepareStatement("DELETE FROM subnet_ban WHERE subnet=?;");
            preparedStatement.setString(1, subnet.toString());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void banCountry(String string) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.con.prepareStatement("INSERT INTO country_ban (country) VALUES(?);");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unbanCountry(String string) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.con.prepareStatement("DELETE FROM country_ban WHERE country=?;");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void whitelist(String string) {
        Statement statement = null;
        try {
            this.createNick(string);
            statement = this.con.prepareStatement("INSERT INTO whitelist (player_id) VALUES(SELECT player_id FROM player WHERE player=?);");
            statement.setString(1, string);
            statement.executeUpdate();
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unWhitelist(String string) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.con.prepareStatement("DELETE FROM whitelist WHERE player_id=(SELECT player_id FROM player WHERE player=?);");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isIpBanned(String string) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.con.prepareStatement("SELECT ip FROM ip WHERE player_id IN (SELECT player_id FROM player_ban) AND ip=?;");
            preparedStatement.setString(1, string);
            boolean bl = preparedStatement.executeQuery().next();
            return bl;
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isSubnetBanned(String string) {
        boolean bl;
        Statement statement = null;
        try {
            statement = this.con.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT subnet FROM subnet_ban;");
            while (resultSet.next()) {
                try {
                    Subnet subnet = new Subnet(resultSet.getString(1));
                    if (!subnet.isIpInSubnet(InetAddress.getByName(string))) continue;
                    boolean bl2 = true;
                    return bl2;
                }
                catch (UnknownHostException unknownHostException) {}
            }
            bl = false;
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isNickBanned(String string) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.con.prepareStatement("SELECT player_id FROM player_ban WHERE player_id=(SELECT player_id FROM player WHERE player=?);");
            preparedStatement.setString(1, string);
            boolean bl = preparedStatement.executeQuery().next();
            return bl;
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isCountryBanned(String string) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.con.prepareStatement("SELECT country FROM country_ban WHERE country=?;");
            preparedStatement.setString(1, string);
            boolean bl = preparedStatement.executeQuery().next();
            return bl;
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isNickWhitelisted(String string) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.con.prepareStatement("SELECT player_id FROM whitelist WHERE player_id=(SELECT player_id FROM player WHERE player=?);");
            preparedStatement.setString(1, string);
            boolean bl = preparedStatement.executeQuery().next();
            return bl;
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] getHistory(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.con.prepareStatement("SELECT ip FROM ip WHERE player_id=(SELECT player_id FROM player WHERE player=?);");
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return arrayList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] getBannedNicks() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Statement statement = null;
        try {
            statement = this.con.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT player FROM player WHERE player_id IN (SELECT player_id FROM player_ban);");
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return arrayList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] getBannedSubnets() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Statement statement = null;
        try {
            statement = this.con.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT subnet FROM subnet_ban;");
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return arrayList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] getBannedCountries() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Statement statement = null;
        try {
            statement = this.con.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT country FROM country_ban;");
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return arrayList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] getWhitelistedNicks() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Statement statement = null;
        try {
            statement = this.con.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT player FROM player WHERE player_id IN (SELECT player_id FROM whitelist);");
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return arrayList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] getNicks(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.con.prepareStatement("SELECT player FROM player WHERE player_id IN (SELECT player_id FROM ip WHERE ip=?);");
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return arrayList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HashMap<String, Long> getTempBans() {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        Statement statement = null;
        try {
            statement = this.con.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT player,until FROM player_ban JOIN player ON player_ban.player_id=player.player_id WHERE until IS NOT NULL;");
            while (resultSet.next()) {
                if (resultSet.getTimestamp(2).getTime() == 100000L) continue;
                hashMap.put(resultSet.getString(1), resultSet.getTimestamp(2).getTime());
            }
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HashMap<String, String> getBanInformation(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.con.prepareStatement("SELECT admin,reason,until FROM player_ban WHERE player_id=(SELECT player_id FROM player WHERE player=?);");
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashMap.put("admin", resultSet.getString(1));
                if (resultSet.getString(2) != null) {
                    hashMap.put("reason", resultSet.getString(2));
                }
                if (resultSet.getTimestamp(3) == null) continue;
                hashMap.put("until", String.valueOf(resultSet.getTimestamp(3).getTime()));
            }
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HashMap<String, String> getBanInformation(Subnet subnet) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.con.prepareStatement("SELECT admin,reason FROM subnet_ban WHERE subnet=?;");
            preparedStatement.setString(1, subnet.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashMap.put("admin", resultSet.getString(1));
                if (resultSet.getString(2) == null) continue;
                hashMap.put("reason", resultSet.getString(2));
            }
        }
        catch (SQLException sQLException) {
            ConsoleLogger.info(sQLException.getMessage());
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return hashMap;
    }
}

