/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.easyban.datasource;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.util.config.Configuration;
import uk.org.whoami.easyban.datasource.DataSource;
import uk.org.whoami.easyban.util.Subnet;

public class YamlDataSource
extends Configuration
implements DataSource {
    private final String banPath = "bans";
    private final String historyPath = "history";
    private final String subnetPath = "subnets";
    private final String countryPath = "countries";
    private final String whitelistPath = "whitelist";
    private HashMap<String, List<String>> history;
    private HashMap<String, HashMap<String, String>> bans;
    private HashMap<String, HashMap<String, String>> subnets;
    private ArrayList<String> countries;
    private ArrayList<String> whitelist;

    public YamlDataSource() {
        super(new File("./plugins/EasyBan/bans.yml"));
        this.load();
        if (this.getProperty("bans") == null) {
            this.setProperty("bans", new HashMap());
        }
        if (this.getProperty("history") == null) {
            this.setProperty("history", new HashMap());
        }
        if (this.getProperty("subnets") == null) {
            this.setProperty("subnets", new HashMap());
        }
        if (this.getProperty("countries") == null) {
            this.setProperty("countries", new ArrayList());
        }
        if (this.getProperty("whitelist") == null) {
            this.setProperty("whitelist", new ArrayList());
        }
        this.history = (HashMap)this.getProperty("history");
        this.bans = (HashMap)this.getProperty("bans");
        this.subnets = (HashMap)this.getProperty("subnets");
        this.countries = (ArrayList)this.getProperty("countries");
        this.whitelist = (ArrayList)this.getProperty("whitelist");
        this.save();
    }

    @Override
    public synchronized void addIpToHistory(String string, String string2) {
        if (this.history.containsKey(string)) {
            if (!this.history.get(string).contains(string2)) {
                this.history.get(string).add(string2);
            }
        } else {
            this.history.put(string, new ArrayList());
            this.history.get(string).add(string2);
        }
        this.save();
    }

    @Override
    public synchronized void banNick(String string, String string2, String string3, Calendar calendar) {
        if (!this.bans.containsKey(string)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("admin", string2);
            if (string3 != null) {
                hashMap.put("reason", string3);
            }
            if (calendar != null) {
                hashMap.put("until", String.valueOf(calendar.getTimeInMillis()));
            }
            this.bans.put(string, hashMap);
            this.save();
        }
    }

    @Override
    public synchronized void unbanNick(String string) {
        if (this.bans.containsKey(string)) {
            this.bans.remove(string);
            this.save();
        }
    }

    @Override
    public synchronized void banSubnet(Subnet subnet, String string, String string2) {
        if (!this.subnets.containsKey(subnet.toString())) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("admin", string);
            hashMap.put("reason", string2);
            this.subnets.put(subnet.toString(), hashMap);
            this.save();
        }
    }

    @Override
    public synchronized void unbanSubnet(Subnet subnet) {
        if (this.subnets.containsKey(subnet.toString())) {
            this.subnets.remove(subnet.toString());
            this.save();
        }
    }

    @Override
    public synchronized void banCountry(String string) {
        if (!this.countries.contains(string)) {
            this.countries.add(string);
            this.save();
        }
    }

    @Override
    public synchronized void whitelist(String string) {
        if (!this.whitelist.contains(string)) {
            this.whitelist.add(string);
            this.save();
        }
    }

    @Override
    public synchronized void unWhitelist(String string) {
        this.whitelist.remove(string);
    }

    @Override
    public synchronized void unbanCountry(String string) {
        this.countries.remove(string);
    }

    @Override
    public synchronized boolean isIpBanned(String string) {
        for (String string2 : this.bans.keySet()) {
            if (!this.history.containsKey(string2) || !this.history.get(string2).contains(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSubnetBanned(String string) {
        Iterator<String> iterator = this.subnets.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                Subnet subnet = new Subnet(iterator.next());
                if (!subnet.isIpInSubnet(InetAddress.getByName(string))) continue;
                return true;
            }
            catch (UnknownHostException unknownHostException) {
            }
        }
        return false;
    }

    @Override
    public synchronized boolean isNickBanned(String string) {
        return this.bans.containsKey(string);
    }

    @Override
    public synchronized boolean isCountryBanned(String string) {
        return this.countries.contains(string);
    }

    @Override
    public synchronized boolean isNickWhitelisted(String string) {
        return this.whitelist.contains(string);
    }

    @Override
    public String[] getHistory(String string) {
        if (this.history.containsKey(string)) {
            return this.history.get(string).toArray(new String[0]);
        }
        return new String[0];
    }

    @Override
    public synchronized String[] getBannedNicks() {
        return this.bans.keySet().toArray(new String[0]);
    }

    @Override
    public synchronized String[] getBannedSubnets() {
        return this.subnets.keySet().toArray(new String[0]);
    }

    @Override
    public synchronized String[] getBannedCountries() {
        return this.countries.toArray(new String[0]);
    }

    @Override
    public synchronized String[] getWhitelistedNicks() {
        return this.whitelist.toArray(new String[0]);
    }

    @Override
    public String[] getNicks(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : this.history.entrySet()) {
            if (!entry.getValue().contains(string)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public synchronized HashMap<String, Long> getTempBans() {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (String string : this.bans.keySet()) {
            if (!this.bans.get(string).containsKey("until")) continue;
            hashMap.put(string, new Long(this.bans.get(string).get("until")));
        }
        return hashMap;
    }

    @Override
    public synchronized HashMap<String, String> getBanInformation(String string) {
        if (this.bans.containsKey(string)) {
            return this.bans.get(string);
        }
        return null;
    }

    @Override
    public synchronized HashMap<String, String> getBanInformation(Subnet subnet) {
        if (this.subnets.containsKey(subnet.toString())) {
            return this.subnets.get(subnet.toString());
        }
        return null;
    }

    @Override
    public void close() {
    }
}

