/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.easyban.settings;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.util.config.Configuration;
import uk.org.whoami.easyban.ConsoleLogger;
import uk.org.whoami.easyban.datasource.DataSource;

public final class Settings
extends Configuration {
    public static final String PLUGIN_FOLDER = "./plugins/EasyBan";
    public static final String MESSAGE_FILE = "./plugins/EasyBan/messages.yml";
    public static final String SETTINGS_FILE = "./plugins/EasyBan/config.yml";
    public static final String DATABASE_FILE = "./plugins/EasyBan/bans.yml";
    private static Settings singleton;

    private Settings() {
        super(new File(SETTINGS_FILE));
        this.reload();
    }

    public void reload() {
        this.load();
        this.write();
        this.save();
    }

    private void write() {
        this.getDatabase();
        this.getMySQLDatabaseName();
        this.getMySQLHost();
        this.getMySQLPort();
        this.getMySQLUsername();
        this.getMySQLPassword();
        this.isKickPublic();
        this.isKickReasonPublic();
        this.isBanPublic();
        this.isBanReasonPublic();
        this.isBanUntilPublic();
        this.isSubnetBanPublic();
        this.isSubnetBanReasonPublic();
        this.isCountryBanPublic();
        this.getBlockLists();
        this.isAppendCustomKickMessageEnabled();
        this.isAppendCustomBanMessageEnabled();
    }

    public DataSource.DataSourceType getDatabase() {
        String string = "database";
        if (this.getString(string) == null) {
            this.setProperty(string, "yaml");
        }
        try {
            return DataSource.DataSourceType.valueOf(this.getString(string).toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ConsoleLogger.info("Unknown database type; default to YAML");
            return DataSource.DataSourceType.YAML;
        }
    }

    public String getMySQLDatabaseName() {
        String string = "MySQLDatabaseName";
        if (this.getString("schema") != null) {
            String string2 = this.getString("schema");
            this.removeProperty("schema");
            this.setProperty(string, string2);
        }
        if (this.getString(string) == null) {
            this.setProperty(string, "easyban");
        }
        return this.getString(string);
    }

    public String getMySQLHost() {
        String string = "MySQLHost";
        if (this.getString("host") != null) {
            String string2 = this.getString("host");
            this.removeProperty("host");
            this.setProperty(string, string2);
        }
        if (this.getString(string) == null) {
            this.setProperty(string, "127.0.0.1");
        }
        return this.getString(string);
    }

    public String getMySQLPort() {
        String string = "MySQLPort";
        if (this.getString("port") != null) {
            String string2 = this.getString("port");
            this.removeProperty("port");
            this.setProperty(string, string2);
        }
        if (this.getString(string) == null) {
            this.setProperty(string, "3306");
        }
        return this.getString(string);
    }

    public String getMySQLUsername() {
        String string = "MySQLUsername";
        if (this.getString("username") != null) {
            String string2 = this.getString("username");
            this.removeProperty("username");
            this.setProperty(string, string2);
        }
        if (this.getString(string) == null) {
            this.setProperty(string, "easyban");
        }
        return this.getString(string);
    }

    public String getMySQLPassword() {
        String string = "MySQLPassword";
        if (this.getString("password") != null) {
            String string2 = this.getString("password");
            this.removeProperty("password");
            this.setProperty(string, string2);
        }
        if (this.getString(string) == null) {
            this.setProperty(string, "CHANGEME");
        }
        return this.getString(string);
    }

    public boolean isKickPublic() {
        String string = "settings.message.kick.public";
        if (this.getString(string) == null) {
            this.setProperty(string, true);
        }
        return this.getBoolean(string, true);
    }

    public boolean isKickReasonPublic() {
        String string = "settings.message.kick.publicReason";
        if (this.getString(string) == null) {
            this.setProperty(string, true);
        }
        return this.getBoolean(string, true);
    }

    public boolean isAppendCustomKickMessageEnabled() {
        String string = "settings.message.kick.appendCustomMessage";
        if (this.getString(string) == null) {
            this.setProperty(string, false);
        }
        return this.getBoolean(string, false);
    }

    public boolean isBanPublic() {
        String string = "settings.message.ban.public";
        if (this.getString(string) == null) {
            this.setProperty(string, true);
        }
        return this.getBoolean(string, true);
    }

    public boolean isBanReasonPublic() {
        String string = "settings.message.ban.publicReason";
        if (this.getString(string) == null) {
            this.setProperty(string, true);
        }
        return this.getBoolean(string, true);
    }

    public boolean isBanUntilPublic() {
        String string = "settings.message.ban.publicUntil";
        if (this.getString(string) == null) {
            this.setProperty(string, true);
        }
        return this.getBoolean(string, true);
    }

    public boolean isAppendCustomBanMessageEnabled() {
        String string = "settings.message.ban.appendCustomMessage";
        if (this.getString(string) == null) {
            this.setProperty(string, false);
        }
        return this.getBoolean(string, false);
    }

    public boolean isSubnetBanPublic() {
        String string = "settings.message.subnetBan.public";
        if (this.getString(string) == null) {
            this.setProperty(string, true);
        }
        return this.getBoolean(string, true);
    }

    public boolean isSubnetBanReasonPublic() {
        String string = "settings.message.subnetBan.publicReason";
        if (this.getString(string) == null) {
            this.setProperty(string, true);
        }
        return this.getBoolean(string, true);
    }

    public boolean isCountryBanPublic() {
        String string = "settings.message.countryBan.public";
        if (this.getString(string) == null) {
            this.setProperty(string, true);
        }
        return this.getBoolean(string, true);
    }

    public boolean isWhitelistPublic() {
        String string = "settings.message.whitelist.public";
        if (this.getString(string) == null) {
            this.setProperty(string, true);
        }
        return this.getBoolean(string, true);
    }

    public List<String> getBlockLists() {
        String string = "settings.dnsbl";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("dnsbl.proxybl.org");
        arrayList.add("tor.dnsbl.sectoor.de");
        if (this.getList(string) == null) {
            this.setProperty(string, arrayList);
        }
        return this.getStringList(string, arrayList);
    }

    public static Settings getInstance() {
        if (singleton == null) {
            singleton = new Settings();
        }
        return singleton;
    }
}

