/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.easyban.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class Subnet {
    short[] subnet;
    short[] mask;

    public Subnet(String string) throws IllegalArgumentException {
        if (!string.contains("/")) {
            throw new IllegalArgumentException("Invalid Subnet");
        }
        String[] stringArray = string.split("/");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Invalid Subnet");
        }
        try {
            this.subnet = Subnet.inetAddressToArray(InetAddress.getByName(stringArray[0]));
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("Invalid Networkprefix");
        }
        if (Subnet.isParseableInteger(stringArray[1])) {
            int n = Integer.parseInt(stringArray[1]);
            if (n < 0 || n > 32) {
                throw new IllegalArgumentException("Invalid CIDR-Mask");
            }
            this.mask = Subnet.cidrToArray(n);
        } else {
            try {
                this.mask = Subnet.inetAddressToArray(InetAddress.getByName(stringArray[1]));
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException("Invalid Subnetmask");
            }
        }
    }

    public Subnet(short[] sArray, short[] sArray2) {
        if (sArray.length > sArray2.length) {
            throw new IllegalArgumentException("Invalid Subnet");
        }
        this.subnet = sArray;
        this.mask = sArray2;
    }

    public boolean isIpInSubnet(short[] sArray) {
        if (this.mask.length < sArray.length) {
            throw new IllegalArgumentException("Invalid Subnet");
        }
        for (int i = 0; i < sArray.length; ++i) {
            short s = (short)(255 - this.mask[i]);
            if (sArray[i] - this.subnet[i] <= s && sArray[i] - this.subnet[i] >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isIpInSubnet(InetAddress inetAddress) {
        return this.isIpInSubnet(Subnet.inetAddressToArray(inetAddress));
    }

    public String toString() {
        return this.subnet.length > 4 ? this.toIpv6String() : this.toIpv4String();
    }

    private String toIpv4String() {
        int n;
        String string = "";
        for (n = 0; n < 4; ++n) {
            if (n != 0) {
                string = string + ".";
            }
            string = string + this.subnet[n];
        }
        string = string + "/";
        for (n = 0; n < 4; ++n) {
            if (n != 0) {
                string = string + ".";
            }
            string = string + this.mask[n];
        }
        return string;
    }

    private String toIpv6String() {
        String string;
        int n;
        String string2 = "";
        for (n = 0; n < 16; n += 2) {
            if (n != 0) {
                string2 = string2 + ":";
            }
            string2 = string2 + Integer.toHexString(this.subnet[n]);
            string = Integer.toHexString(this.subnet[n + 1]);
            if (string.length() == 1) {
                string = "0" + string;
            }
            string2 = string2 + string;
        }
        string2 = string2 + "/";
        for (n = 0; n < 16; n += 2) {
            if (n != 0) {
                string2 = string2 + ":";
            }
            string2 = string2 + Integer.toHexString(this.mask[n]);
            string = Integer.toHexString(this.mask[n + 1]);
            if (string.length() == 1) {
                string = "0" + string;
            }
            string2 = string2 + string;
        }
        return string2;
    }

    public static short[] cidrToArray(int n) {
        short[] sArray = new short[16];
        for (int i = 0; i < 16; ++i) {
            if (n > 8) {
                sArray[i] = 255;
                n -= 8;
                continue;
            }
            sArray[i] = (short)(256.0 - Math.pow(2.0, 8 - n));
            n = 0;
        }
        return sArray;
    }

    public static short[] inetAddressToArray(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        short[] sArray = new short[byArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)(0xFF & byArray[i]);
        }
        return sArray;
    }

    public static boolean isParseableInteger(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }
}

