/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.easyban.datasource;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import uk.org.whoami.easyban.ConsoleLogger;
import uk.org.whoami.easyban.datasource.SQLDataSource;
import uk.org.whoami.easyban.settings.Settings;

public class MySQLDataSource
extends SQLDataSource {
    private String databaseName;
    private String host;
    private String port;
    private String username;
    private String password;

    public MySQLDataSource(Settings settings) throws ClassNotFoundException, SQLException {
        this.databaseName = settings.getMySQLDatabaseName();
        this.host = settings.getMySQLHost();
        this.port = settings.getMySQLPort();
        this.username = settings.getMySQLUsername();
        this.password = settings.getMySQLPassword();
        this.connect();
        this.setup();
        ConsoleLogger.info("Database setup finished");
    }

    @Override
    protected final synchronized void connect() throws ClassNotFoundException, SQLException {
        Class.forName("com.mysql.jdbc.Driver");
        ConsoleLogger.info("MySQL driver loaded");
        this.con = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.databaseName, this.username, this.password);
        ConsoleLogger.info("Connected to Database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final synchronized void setup() throws SQLException {
        Statement statement = null;
        try {
            statement = this.con.createStatement();
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS player (player_id INTEGER AUTO_INCREMENT,player VARCHAR(20) NOT NULL,CONSTRAINT player_const_prim PRIMARY KEY (player_id),CONSTRAINT player_const_uniq UNIQUE(player));");
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS ip (ip_id INTEGER AUTO_INCREMENT,player_id INTEGER NOT NULL,ip VARCHAR(40) NOT NULL,CONSTRAINT ip_const_prim PRIMARY KEY (ip_id),CONSTRAINT ip_const_ref FOREIGN KEY (player_id) REFERENCES player (player_id));");
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS player_ban (player_ban_id INTEGER AUTO_INCREMENT,player_id INTEGER NOT NULL,admin VARCHAR(20) NOT NULL,reason VARCHAR(100),until TIMESTAMP,CONSTRAINT player_ban_const_prim PRIMARY KEY (player_ban_id),CONSTRAINT player_ban_const_uniq UNIQUE (player_id),CONSTRAINT player_ban_const_ref FOREIGN KEY (player_id) REFERENCES player (player_id));");
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS subnet_ban (subnet_ban_id INTEGER AUTO_INCREMENT,subnet VARCHAR(100) NOT NULL,admin VARCHAR(20) NOT NULL,reason VARCHAR(100),CONSTRAINT subnet_ban_const_prim PRIMARY KEY (subnet_ban_id),CONSTRAINT subnet_ban_const_uniq UNIQUE (subnet));");
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS country_ban (country_ban_id INTEGER AUTO_INCREMENT,country VARCHAR(2) NOT NULL,CONSTRAINT country_ban_const_prim PRIMARY KEY (country_ban_id),CONSTRAINT country_ban_const_uniq UNIQUE (country));");
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS whitelist (whitelist_id INTEGER AUTO_INCREMENT,player_id INTEGER NOT NULL,CONSTRAINT whitelist_const_prim PRIMARY KEY (whitelist_id),CONSTRAINT whitelist_const_ref FOREIGN KEY (player_id) REFERENCES player (player_id));");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public synchronized void close() {
        try {
            this.con.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

