/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.easyban.listener;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerLoginEvent;
import uk.org.whoami.easyban.ConsoleLogger;
import uk.org.whoami.easyban.datasource.DataSource;
import uk.org.whoami.easyban.settings.Message;
import uk.org.whoami.geoip.GeoIPLookup;

public class EasyBanCountryListener
extends PlayerListener {
    private DataSource database;
    private GeoIPLookup geo;
    private final Message m = Message.getInstance();

    public EasyBanCountryListener(DataSource dataSource, GeoIPLookup geoIPLookup) {
        this.database = dataSource;
        this.geo = geoIPLookup;
    }

    public void onPlayerLogin(PlayerLoginEvent playerLoginEvent) {
        if (playerLoginEvent.getPlayer() == null || !playerLoginEvent.getResult().equals((Object)PlayerLoginEvent.Result.ALLOWED)) {
            return;
        }
        String string = playerLoginEvent.getPlayer().getName();
        String string2 = playerLoginEvent.getKickMessage();
        if (this.database.isNickWhitelisted(string)) {
            return;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            String string3 = this.geo.getCountry(inetAddress).getCode();
            if (this.database.isCountryBanned(string3)) {
                ConsoleLogger.info("Player " + string + "is from banned country " + string3);
                playerLoginEvent.disallow(PlayerLoginEvent.Result.KICK_BANNED, this.m._("Your country has been banned"));
            }
        }
        catch (UnknownHostException unknownHostException) {
            ConsoleLogger.info(unknownHostException.getMessage());
        }
    }
}

