/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.easyban.listener;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerLoginEvent;
import uk.org.whoami.easyban.ConsoleLogger;
import uk.org.whoami.easyban.datasource.DataSource;
import uk.org.whoami.easyban.settings.Message;
import uk.org.whoami.easyban.settings.Settings;
import uk.org.whoami.easyban.util.DNSBL;

public class EasyBanPlayerListener
extends PlayerListener {
    private DataSource database;
    private DNSBL dnsbl;
    private Message msg = Message.getInstance();

    public EasyBanPlayerListener(DataSource dataSource, DNSBL dNSBL) {
        this.database = dataSource;
        this.dnsbl = dNSBL;
    }

    public void onPlayerLogin(PlayerLoginEvent playerLoginEvent) {
        if (playerLoginEvent.getPlayer() == null || !playerLoginEvent.getResult().equals((Object)PlayerLoginEvent.Result.ALLOWED)) {
            return;
        }
        String string = playerLoginEvent.getPlayer().getName();
        String string2 = playerLoginEvent.getKickMessage();
        this.database.addIpToHistory(string, string2);
        if (this.dnsbl.isBlocked(string2)) {
            playerLoginEvent.disallow(PlayerLoginEvent.Result.KICK_BANNED, this.msg._("DNSBL Ban"));
            return;
        }
        if (this.database.isNickBanned(string)) {
            HashMap<String, String> hashMap = this.database.getBanInformation(string);
            String string3 = this.msg._("You have been banned by ") + hashMap.get("admin");
            if (hashMap.containsKey("reason")) {
                string3 = string3 + " " + this.msg._("Reason: ") + hashMap.get("reason");
            }
            if (hashMap.containsKey("until")) {
                Long l = Long.parseLong(hashMap.get("until"));
                string3 = string3 + " " + this.msg._("Until: ") + DateFormat.getDateTimeInstance().format(new Date(l));
            }
            if (Settings.getInstance().isAppendCustomBanMessageEnabled()) {
                string3 = string3 + " " + this.msg._("custom_ban");
            }
            playerLoginEvent.disallow(PlayerLoginEvent.Result.KICK_BANNED, string3);
            ConsoleLogger.info("Ban for " + string + " detected");
            return;
        }
        if (this.database.isIpBanned(string2)) {
            playerLoginEvent.disallow(PlayerLoginEvent.Result.KICK_BANNED, this.msg._("You are banned"));
            ConsoleLogger.info("IP Ban for " + string + " detected");
            return;
        }
        if (this.database.isNickWhitelisted(playerLoginEvent.getPlayer().getName())) {
            ConsoleLogger.info("Whitelist entry for " + string + " found");
            return;
        }
        if (this.database.isSubnetBanned(string2)) {
            playerLoginEvent.disallow(PlayerLoginEvent.Result.KICK_BANNED, this.msg._("Your subnet is banned"));
            ConsoleLogger.info("Subnet ban for " + string + "/" + string2 + " detected");
        }
    }

    public void onPlayerJoin(PlayerJoinEvent playerJoinEvent) {
        if (playerJoinEvent.getPlayer() == null) {
            return;
        }
        Player player = playerJoinEvent.getPlayer();
        String string = player.getName();
        String string2 = player.getAddress().getAddress().getHostAddress();
        if (this.database.isNickBanned(string)) {
            HashMap<String, String> hashMap = this.database.getBanInformation(string);
            String string3 = this.msg._("You have been banned by ") + hashMap.get("admin");
            if (hashMap.containsKey("reason")) {
                string3 = string3 + " " + this.msg._("Reason: ") + hashMap.get("reason");
            }
            if (hashMap.containsKey("until")) {
                Long l = Long.parseLong(hashMap.get("until"));
                string3 = string3 + " " + this.msg._("Until: ") + DateFormat.getDateTimeInstance().format(new Date(l));
            }
            if (Settings.getInstance().isAppendCustomBanMessageEnabled()) {
                string3 = string3 + " " + this.msg._("custom_ban");
            }
            player.kickPlayer(string3);
            ConsoleLogger.info("Ban for " + string + " detected");
            return;
        }
        if (this.database.isIpBanned(string2)) {
            player.kickPlayer(this.msg._("You are banned"));
            ConsoleLogger.info("IP Ban for " + string + " detected");
            return;
        }
        if (this.database.isNickWhitelisted(playerJoinEvent.getPlayer().getName())) {
            ConsoleLogger.info("Whitelist entry for " + string + " found");
            return;
        }
        if (this.database.isSubnetBanned(string2)) {
            player.kickPlayer(this.msg._("Your subnet is banned"));
            ConsoleLogger.info("Subnet ban for " + string + "/" + string2 + " detected");
        }
    }
}

