/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.model;

import com.griefcraft.cache.CacheSet;
import com.griefcraft.cache.LRUCache;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.AccessRight;
import com.griefcraft.model.History;
import com.griefcraft.scripting.ModuleLoader;
import com.griefcraft.scripting.event.LWCProtectionRemovePostEvent;
import com.griefcraft.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class Protection {
    private Logger logger = Logger.getLogger("LWC");
    private final List<AccessRight> accessRightCache = new ArrayList<AccessRight>();
    private final Set<History> historyCache = new HashSet<History>();
    private int blockId;
    private String data;
    private String date;
    private int id;
    private int flags;
    private String owner;
    private int type;
    private String world;
    private int x;
    private int y;
    private int z;
    private long lastAccessed;
    private boolean removed = false;
    private boolean modified = false;

    public void checkHistory(History history) {
        if (!this.historyCache.contains(history)) {
            this.historyCache.add(history);
        }
    }

    public boolean isOwner(Player player) {
        LWC lwc = LWC.getInstance();
        return player != null && (this.owner.equals(player.getName()) || lwc.isAdmin(player));
    }

    public History createHistoryObject() {
        History history = new History();
        history.setProtectionId(this.id);
        history.setStatus(History.Status.INACTIVE);
        this.historyCache.add(history);
        return history;
    }

    public Set<History> getRelatedHistory() {
        if (this.historyCache.size() == 0) {
            this.historyCache.addAll(LWC.getInstance().getPhysicalDatabase().loadHistory(this));
        }
        return Collections.unmodifiableSet(this.historyCache);
    }

    public List<History> getRelatedHistory(History.Type type) {
        ArrayList<History> matches = new ArrayList<History>();
        Set<History> relatedHistory = this.getRelatedHistory();
        for (History history : relatedHistory) {
            if (history.getType() != type) continue;
            matches.add(history);
        }
        return matches;
    }

    public boolean hasFlag(Flag flag) {
        return (this.flags & flag.getBit()) == flag.getBit();
    }

    public boolean addFlag(Flag flag) {
        if (this.removed) {
            return false;
        }
        if (!this.hasFlag(flag)) {
            this.flags |= flag.getBit();
            this.modified = true;
            return true;
        }
        return false;
    }

    public void removeFlag(Flag flag) {
        if (this.removed) {
            return;
        }
        this.modified = true;
        if (!this.hasFlag(flag)) {
            return;
        }
        this.flags = 0;
        for (Flag tmp : Flag.values()) {
            if (flag == tmp) continue;
            this.addFlag(tmp);
        }
    }

    public int getAccess(int type, String name) {
        for (AccessRight right : this.accessRightCache) {
            if (right.getType() != type || !right.getName().equalsIgnoreCase(name)) continue;
            return right.getRights();
        }
        return -1;
    }

    public List<AccessRight> getAccessRights() {
        return this.accessRightCache;
    }

    public void removeTemporaryAccessRights() {
        Iterator<AccessRight> iter = this.accessRightCache.iterator();
        while (iter.hasNext()) {
            AccessRight right = iter.next();
            if (right.getType() != 3) continue;
            iter.remove();
        }
    }

    public void addAccessRight(AccessRight right) {
        if (this.removed) {
            return;
        }
        this.accessRightCache.add(right);
    }

    public int getFlags() {
        return this.flags;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public String getData() {
        return this.data;
    }

    public String getDate() {
        return this.date;
    }

    public int getId() {
        return this.id;
    }

    public String getOwner() {
        return this.owner;
    }

    public int getType() {
        return this.type;
    }

    public String getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void setBlockId(int blockId) {
        if (this.removed) {
            return;
        }
        this.blockId = blockId;
        this.modified = true;
    }

    public void setData(String data) {
        if (this.removed) {
            return;
        }
        this.data = data;
        this.modified = true;
    }

    public void setDate(String date) {
        if (this.removed) {
            return;
        }
        this.date = date;
        this.modified = true;
    }

    public void setId(int id) {
        if (this.removed) {
            return;
        }
        this.id = id;
        this.modified = true;
    }

    public void setFlags(int flags) {
        if (this.removed) {
            return;
        }
        this.flags = flags;
        this.modified = true;
    }

    public void setOwner(String owner) {
        if (this.removed) {
            return;
        }
        this.owner = owner;
        this.modified = true;
    }

    public void setType(int type) {
        if (this.removed) {
            return;
        }
        this.type = type;
        this.modified = true;
    }

    public void setWorld(String world) {
        if (this.removed) {
            return;
        }
        this.world = world;
        this.modified = true;
    }

    public void setX(int x) {
        if (this.removed) {
            return;
        }
        this.x = x;
        this.modified = true;
    }

    public void setY(int y) {
        if (this.removed) {
            return;
        }
        this.y = y;
        this.modified = true;
    }

    public void setZ(int z) {
        if (this.removed) {
            return;
        }
        this.z = z;
        this.modified = true;
    }

    public void setLastAccessed(long lastAccessed) {
        if (this.removed) {
            return;
        }
        this.lastAccessed = lastAccessed;
        this.modified = true;
    }

    public void remove() {
        if (this.removed) {
            return;
        }
        LWC lwc = LWC.getInstance();
        this.removeTemporaryAccessRights();
        this.modified = false;
        lwc.getModuleLoader().dispatchEvent(ModuleLoader.Event.POST_REMOVAL, this);
        lwc.getModuleLoader().dispatchEvent(new LWCProtectionRemovePostEvent(this));
        for (History history : this.getRelatedHistory(History.Type.TRANSACTION)) {
            if (history.getStatus() != History.Status.ACTIVE) continue;
            history.setStatus(History.Status.INACTIVE);
        }
        this.saveNow();
        this.removed = true;
        lwc.getUpdateThread().unqueueProtectionUpdate(this);
        lwc.getPhysicalDatabase().unregisterProtection(this.id);
        this.removeCache();
    }

    public void removeCache() {
        LWC lwc = LWC.getInstance();
        LRUCache<String, Protection> cache = lwc.getCaches().getProtections();
        cache.remove(this.getCacheKey());
        if (lwc.isBug656WorkAround()) {
            World worldObject = lwc.getPlugin().getServer().getWorld(this.world);
            List<Block> blocks = lwc.getRelatedBlocks(worldObject, this.x, this.y, this.z);
            for (Block b : blocks) {
                String cacheKey = b.getWorld().getName() + ":" + b.getX() + ":" + b.getY() + ":" + b.getZ();
                cache.remove(cacheKey);
            }
        }
    }

    public void update() {
        if (this.removed) {
            return;
        }
        CacheSet caches = LWC.getInstance().getCaches();
        this.removeCache();
        Protection temp = LWC.getInstance().getPhysicalDatabase().loadProtection(this.id);
        if (temp != null) {
            caches.getProtections().put(this.getCacheKey(), temp);
        }
    }

    public void save() {
        if (this.removed) {
            return;
        }
        LWC.getInstance().getUpdateThread().queueProtectionUpdate(this);
    }

    public void saveNow() {
        if (this.removed) {
            return;
        }
        if (this.modified) {
            LWC.getInstance().getPhysicalDatabase().saveProtection(this);
            this.update();
        }
        for (History history : this.historyCache) {
            if (!history.wasModified()) continue;
            history.saveNow();
        }
    }

    public String getCacheKey() {
        return this.world + ":" + this.x + ":" + this.y + ":" + this.z;
    }

    public World getBukkitWorld() {
        if (this.world == null || this.world.isEmpty()) {
            return (World)Bukkit.getServer().getWorlds().get(0);
        }
        return Bukkit.getServer().getWorld(this.world);
    }

    public Player getBukkitOwner() {
        return Bukkit.getServer().getPlayer(this.owner);
    }

    public Block getBlock() {
        World world = this.getBukkitWorld();
        if (world == null) {
            return null;
        }
        return world.getBlockAt(this.x, this.y, this.z);
    }

    public String toString() {
        String lastAccessed;
        String flags = "";
        for (Flag flag : Flag.values()) {
            if (!this.hasFlag(flag)) continue;
            flags = flags + flag.toString() + ",";
        }
        if (flags.endsWith(",")) {
            flags = flags.substring(0, flags.length() - 1);
        }
        if (!(lastAccessed = StringUtils.timeToString(System.currentTimeMillis() / 1000L - this.lastAccessed)).equals("Not yet known")) {
            lastAccessed = lastAccessed + " ago";
        }
        return String.format("%s %s\u00a7f \u00a72Id=%d Owner=%s Location=[%s %d,%d,%d] Created=%s Flags=%s LastAccessed=%s", this.typeToString(), this.blockId > 0 ? LWC.materialToString(this.blockId) : "Not yet cached", this.id, this.owner, this.world, this.x, this.y, this.z, this.date, flags, lastAccessed);
    }

    public String typeToString() {
        switch (this.type) {
            case 2: {
                return "Private";
            }
            case 0: {
                return "Public";
            }
            case 1: {
                return "Password";
            }
            case 3: {
                return "Kick trap";
            }
            case 4: {
                return "Ban trap";
            }
        }
        return "Unknown(raw:" + this.type + ")";
    }

    public static enum Flag {
        REDSTONE(2),
        MAGNET(3),
        EXEMPTION(8, true);

        private int bit;
        private boolean restricted;

        private Flag(int bit) {
            this(bit, false);
        }

        private Flag(int bit, boolean restricted) {
            this.bit = bit;
            this.restricted = restricted;
        }

        public int getBit() {
            return this.bit;
        }

        public boolean isRestricted() {
            return this.restricted;
        }
    }
}

